/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.api;

import com.sap.aii.util.log.api.NameMap;
import java.io.Serializable;

public class Level
implements Serializable,
Comparable {
    static final long serialVersionUID = -8597698560773402178L;
    private static NameMap levels = new NameMap();
    static final int PRIO_MAX = 10000;
    static final int PRIO_FATAL = 8000;
    static final int PRIO_ERROR = 7000;
    static final int PRIO_WARNING = 6000;
    static final int PRIO_INFO = 5000;
    static final int PRIO_PATH = 4250;
    static final int PRIO_DEBUG = 4000;
    static final int PRIO_FINE = 3000;
    static final int PRIO_FINER = 2000;
    static final int PRIO_FINEST = 1000;
    static final int PRIO_MIN = 0;
    public static final Level OFF = new Level("OFF", 10000);
    public static final Level FATAL = new Level("FATAL", 8000);
    public static final Level SEVERE = new Level("SEVERE", 8000);
    public static final Level ERROR = new Level("ERROR", 7000);
    public static final Level WARNING = new Level("WARNING", 6000);
    public static final Level INFO = new Level("INFO", 5000);
    public static final Level PATH = new Level("PATH", 4250);
    public static final Level DEBUG = new Level("DEBUG", 4000);
    public static final Level FINE = new Level("FINE", 3000);
    public static final Level FINER = new Level("FINER", 2000);
    public static final Level FINEST = new Level("FINEST", 1000);
    public static final Level ALL = new Level("ALL", 0);
    public static final Level DEFAULT = INFO;
    private String name;
    private int priority;

    Level(String name, int priority) {
        this.name = name;
        this.priority = priority < 0 ? 0 : (priority > 10000 ? 10000 : priority);
        levels.put(name, this);
    }

    public static Level getLevel(int priority) {
        Level level = Level.findExactLevel(priority);
        if (level != null) {
            return level;
        }
        String name = Integer.toString(priority);
        level = Level.getLevel(name);
        if (level != null) {
            return level;
        }
        return new Level(name, priority);
    }

    static Level findNextLevel(int prio) {
        if (prio <= 1000) {
            return FINEST;
        }
        if (prio <= 2000) {
            return FINER;
        }
        if (prio <= 3000) {
            return FINE;
        }
        if (prio <= 4250) {
            return PATH;
        }
        if (prio <= 5000) {
            return INFO;
        }
        if (prio <= 6000) {
            return WARNING;
        }
        if (prio <= 7000) {
            return ERROR;
        }
        return FATAL;
    }

    static Level findExactLevel(int prio) {
        if (prio == 1000) {
            return FINEST;
        }
        if (prio == 2000) {
            return FINER;
        }
        if (prio == 3000) {
            return FINE;
        }
        if (prio == 4250) {
            return PATH;
        }
        if (prio == 5000) {
            return INFO;
        }
        if (prio == 6000) {
            return WARNING;
        }
        if (prio == 7000) {
            return ERROR;
        }
        if (prio == 8000) {
            return FATAL;
        }
        if (prio == 0) {
            return OFF;
        }
        if (prio == 10000) {
            return ALL;
        }
        return null;
    }

    public static Level getLevel(String name) {
        return (Level)levels.get(name);
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public int intValue() {
        return this.priority;
    }

    public String toString() {
        return this.name;
    }

    public static Level[] getAllLevels() {
        return levels.values().toArray(new Level[0]);
    }

    public int compareTo(Object o) throws ClassCastException {
        return this.getPriority() - ((Level)o).getPriority();
    }

    public int hashCode() {
        return this.intValue();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Level)) {
            return false;
        }
        return this.intValue() == ((Level)obj).intValue();
    }
}

