/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.core.msg;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.HmiMethodFault;
import com.sap.aii.util.hmi.api.HmiMethodOutput;
import com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.GUIDFactory;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.guid.IGUID;

public class HmiResponse
implements GenericallyRepresentable {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$core$msg$HmiResponse == null ? (class$com$sap$aii$util$hmi$core$msg$HmiResponse = HmiResponse.class$("com.sap.aii.util.hmi.core.msg.HmiResponse")) : class$com$sap$aii$util$hmi$core$msg$HmiResponse).getName());
    private IGUID iClientId;
    private IGUID iRequestId;
    private HmiMethodOutput iMethodOutput;
    private HmiMethodFault iMethodFault;
    private HmiCoreException iCoreException;
    private int iControlFlag;
    private String iHmiSpecVersion;
    private static String sEmergencyResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<instance typeid=\"com.sap.aii.util.hmi.core.msg.HmiResponse\"><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"ClientId\"><value index=\"0\" isnull=\"false\">2519c060ed2011d7afb1c9fc0a140a6c</value></attribute><attribute isleave=\"false\" name=\"MethodOutput\"><value index=\"0\" isnull=\"true\"></value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"HmiSpecVersion\"><value index=\"0\" isnull=\"false\">1.0</value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"RequestId\"><value index=\"0\" isnull=\"false\">2516b320ed2011d7a0c9c9fc0a140a6c</value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"ControlFlag\"><value index=\"0\" isnull=\"false\">0</value></attribute><attribute isleave=\"false\" name=\"MethodFault\"><value index=\"0\" isnull=\"true\"></value></attribute><attribute isleave=\"false\" name=\"CoreException\"><value index=\"0\" isnull=\"false\"><instance typeid=\"com.sap.aii.util.hmi.api.HmiCoreException\"><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"Severity\"><value index=\"0\" isnull=\"false\">FATAL</value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"OriginalStackTrace\"><value index=\"0\" isnull=\"true\"></value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"SubtypeId\"><value index=\"0\" isnull=\"false\">UNEXPECTED_SERVER_EXCEPTION</value></attribute><attribute isleave=\"true\" leave_encoding=\"none\" leave_typeid=\"string\" name=\"LocalizedMessage\"><value index=\"0\" isnull=\"false\">Emergency message -- server could not render HmiResponse with HmiCoreException! See server log for details!</value></attribute></instance></value></attribute></instance>";
    private static String[] sAttributeNames = new String[]{"ClientId", "RequestId", "MethodOutput", "MethodFault", "CoreException", "ControlFlag", "HmiSpecVersion"};
    static /* synthetic */ Class class$com$sap$aii$util$hmi$core$msg$HmiResponse;

    private HmiResponse(IGUID aClientId, IGUID aRequestId, HmiMethodOutput aMethodOutput, HmiMethodFault aMethodFault, HmiCoreException aCoreException, int aControlFlag) {
        this.iClientId = aClientId;
        this.iRequestId = aRequestId;
        this.iMethodOutput = aMethodOutput;
        this.iMethodFault = aMethodFault;
        this.iCoreException = aCoreException;
        this.iControlFlag = aControlFlag;
        this.iHmiSpecVersion = "1.0";
    }

    public static HmiResponse createResponse(IGUID aClientId, IGUID aRequestId, HmiMethodOutput aMethodOutput, HmiMethodFault aMethodFault, HmiCoreException aCoreException, int aControlFlag) {
        return new HmiResponse(aClientId, aRequestId, aMethodOutput, aMethodFault, aCoreException, aControlFlag);
    }

    public IGUID getClientId() {
        return this.iClientId;
    }

    public IGUID getRequestId() {
        return this.iRequestId;
    }

    public HmiMethodOutput getMethodOutput() {
        return this.iMethodOutput;
    }

    public HmiMethodFault getMethodFault() {
        return this.iMethodFault;
    }

    public HmiCoreException getCoreException() {
        return this.iCoreException;
    }

    public int getControlFlag() {
        return this.iControlFlag;
    }

    public String getHmiSpecVersion() {
        return this.iHmiSpecVersion;
    }

    public static String createRenderedResponseFromCoreException(IGUID aClientId, IGUID aRequestId, HmiCoreException aCoreException) {
        try {
            HmiResponse lResponse = new HmiResponse(aClientId, aRequestId, null, null, aCoreException, 0);
            GenericDataInstance lResponseAsGdi = HmiResponse.renderGdi(lResponse);
            String lResponseAsString = GdiCharStreamer.gdiToString(lResponseAsGdi);
            return lResponseAsString;
        }
        catch (Exception e) {
            String lMsg = "createRenderedResponseFromCoreException: caught unexpected exception:\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error(lMsg);
            return sEmergencyResponse;
        }
    }

    private HmiResponse() {
    }

    public static GenericDataInstance renderGdi(HmiResponse aResponse) throws HmiCoreException {
        GenericDataInstance lResponseAsGdi = aResponse.getState();
        return lResponseAsGdi;
    }

    public static HmiResponse parseGdi(GenericDataInstance aResponse) throws HmiCoreException {
        HmiResponse lResponse = new HmiResponse();
        lResponse.setState(aResponse);
        return lResponse;
    }

    public static String render(HmiResponse aResponse) throws HmiCoreException {
        GenericDataInstance lResponseAsGdi = HmiResponse.renderGdi(aResponse);
        String lResponseAsString = GdiCharStreamer.gdiToString(lResponseAsGdi);
        return lResponseAsString;
    }

    public static HmiResponse parse(String aResponse) throws HmiCoreException {
        GenericDataInstance lResponseAsGdi = GdiCharStreamer.stringToGdi(aResponse);
        HmiResponse lResponse = HmiResponse.parseGdi(lResponseAsGdi);
        return lResponse;
    }

    public void setState(GenericDataInstance aState) throws HmiCoreException {
        try {
            String lRequestId = aState.getAttributes().getValue("RequestId").getString(0);
            this.iRequestId = GUIDFactory.getInstance().parseHexGUID(lRequestId);
            String lClientId = aState.getAttributes().getValue("ClientId").getString(0);
            this.iClientId = GUIDFactory.getInstance().parseHexGUID(lClientId);
            GenericDataInstance lMethodOutput = aState.getAttributes().getValue("MethodOutput").getGenericDataInstance(0);
            this.iMethodOutput = HmiMethodOutput.parseGdi(lMethodOutput);
            GenericDataInstance lMethodFault = aState.getAttributes().getValue("MethodFault").getGenericDataInstance(0);
            this.iMethodFault = HmiMethodFault.parseGdi(lMethodFault);
            GenericDataInstance lCoreException = aState.getAttributes().getValue("CoreException").getGenericDataInstance(0);
            this.iCoreException = HmiCoreException.parseGdi(lCoreException);
            this.iControlFlag = Integer.parseInt(aState.getAttributes().getValue("ControlFlag").getString(0));
            GenericAttributeMultivalue lHmiSpecVersion = aState.getAttributes().getValue("HmiSpecVersion");
            this.iHmiSpecVersion = lHmiSpecVersion == null ? "1.0" : lHmiSpecVersion.getString(0);
        }
        catch (Exception e) {
            String lMsg = "Unexpected exception!\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error("Parsing GDI (method setState): " + lMsg);
            throw HmiCoreException.newParsingError(this.getClass().getName(), lMsg);
        }
    }

    public GenericDataInstance getState() throws HmiCoreException {
        try {
            String lRequestIdAsString = this.iRequestId == null ? null : this.iRequestId.toHexString();
            GenericAttributeMultivalue lRequestId = new GenericAttributeMultivalue(lRequestIdAsString);
            String lClientIdAsString = this.iClientId == null ? null : this.iClientId.toHexString();
            GenericAttributeMultivalue lClientId = new GenericAttributeMultivalue(lClientIdAsString);
            GenericDataInstance lMethodOutputGdi = HmiMethodOutput.renderGdi(this.iMethodOutput);
            GenericAttributeMultivalue lMethodOutput = new GenericAttributeMultivalue(lMethodOutputGdi);
            GenericDataInstance lMethodFaultAsGdi = HmiMethodFault.renderGdi(this.iMethodFault);
            GenericAttributeMultivalue lMethodFault = new GenericAttributeMultivalue(lMethodFaultAsGdi);
            GenericDataInstance lCoreExceptionAsGdi = HmiCoreException.renderGdi(this.iCoreException);
            GenericAttributeMultivalue lCoreException = new GenericAttributeMultivalue(lCoreExceptionAsGdi);
            String lControlFlagAsString = String.valueOf(this.iControlFlag);
            GenericAttributeMultivalue lControlFlag = new GenericAttributeMultivalue(lControlFlagAsString);
            GenericAttributeMultivalue lHmiSpecVersion = new GenericAttributeMultivalue(this.iHmiSpecVersion);
            GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lRequestId, lClientId, lMethodOutput, lMethodFault, lCoreException, lControlFlag, lHmiSpecVersion});
            return new GenericDataInstance(this.getClass().getName(), lAttributes);
        }
        catch (Exception e) {
            String lMsg = "Unexpected exception!\n" + HelperFunctions.getThrowableAsString(e);
            sLogger.error("Rendering into GDI (method getState): " + lMsg);
            throw HmiCoreException.newRenderingError(this.getClass().getName(), lMsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ControlFlags {
        public static final int None = 0;
        public static final int ClientDestructionAcknowledge = 1;
    }
}

