/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.core.gdi2;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.base64.api.Base64;
import com.sap.aii.util.hmi.core.gdi2.EntryStringString;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.guid.IGUID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class GdiForPrimitives {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$core$gdi2$GdiForPrimitives == null ? (class$com$sap$aii$util$hmi$core$gdi2$GdiForPrimitives = GdiForPrimitives.class$("com.sap.aii.util.hmi.core.gdi2.GdiForPrimitives")) : class$com$sap$aii$util$hmi$core$gdi2$GdiForPrimitives).getName());
    static /* synthetic */ Class class$com$sap$aii$util$hmi$core$gdi2$GdiForPrimitives;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class GdiArrayGuid {
        public static GenericAttributeMultivalue render(IGUID[] aArrayGuid) {
            String[] lArrayString = new String[aArrayGuid.length];
            int i = 0;
            while (i < aArrayGuid.length) {
                lArrayString[i] = aArrayGuid[i].toHexString();
                ++i;
            }
            return GdiArrayString.render(lArrayString);
        }

        public static IGUID[] parse(GenericAttributeMultivalue aArrayGuid) {
            String[] lArrayString = GdiArrayString.parse(aArrayGuid);
            IGUID[] lArrayGuid = new IGUID[aArrayGuid.getSize()];
            int i = 0;
            while (i < aArrayGuid.getSize()) {
                lArrayGuid[i] = HelperFunctions.createGuidFromHexString(lArrayString[i]);
                ++i;
            }
            return lArrayGuid;
        }
    }

    public static abstract class GdiArrayByte {
        public static GenericAttributeMultivalue render(byte[] aArrayByte) {
            String lBytesAsString = aArrayByte == null ? null : Base64.encode(aArrayByte);
            return new GenericAttributeMultivalue(lBytesAsString);
        }

        public static byte[] parse(GenericAttributeMultivalue aArrayByte) {
            String lBytesAsString = aArrayByte.getString(0);
            return lBytesAsString == null ? null : Base64.decode(lBytesAsString);
        }
    }

    public static abstract class GdiArrayString {
        public static GenericAttributeMultivalue render(String[] aArrayString) {
            return new GenericAttributeMultivalue(aArrayString);
        }

        public static String[] parse(GenericAttributeMultivalue aArrayString) {
            String[] lArrayString = new String[aArrayString.getSize()];
            int i = 0;
            while (i < aArrayString.getSize()) {
                lArrayString[i] = aArrayString.getString(i);
                ++i;
            }
            return lArrayString;
        }
    }

    public static abstract class GdiMapStringString {
        public static GenericAttributeMultivalue render(Map aMapStringString) {
            GenericDataInstance[] lEntries = new GenericDataInstance[aMapStringString.size()];
            Iterator lEntryIterator = aMapStringString.entrySet().iterator();
            int i = 0;
            while (lEntryIterator.hasNext()) {
                Map.Entry lMapEntry = lEntryIterator.next();
                EntryStringString lEntry = new EntryStringString(lMapEntry.getKey(), lMapEntry.getValue());
                lEntries[i++] = lEntry.getState();
            }
            return new GenericAttributeMultivalue(lEntries);
        }

        public static Map parse(GenericAttributeMultivalue aMapStringString) {
            HashMap<Object, Object> lMap = new HashMap<Object, Object>();
            int i = 0;
            while (i < aMapStringString.getSize()) {
                EntryStringString lEntry = new EntryStringString();
                lEntry.setState(aMapStringString.getGenericDataInstance(i));
                lMap.put(lEntry.getKey(), lEntry.getValue());
                ++i;
            }
            return lMap;
        }
    }

    public static abstract class GdiApplCompLevel {
        private static String[] sAttributeNames = new String[]{"Release", "SupportPackage"};

        public static ApplCompLevel parse(GenericDataInstance aLevel) {
            if (aLevel == null) {
                return null;
            }
            String lRelease = aLevel.getAttributes().getValue("Release").getString(0);
            String lSupportPackage = aLevel.getAttributes().getValue("SupportPackage").getString(0);
            return new ApplCompLevel(lRelease, lSupportPackage);
        }

        public static GenericDataInstance render(ApplCompLevel aLevel) {
            if (aLevel == null) {
                return null;
            }
            GenericAttributeMultivalue lRelease = new GenericAttributeMultivalue(aLevel.getRelease());
            GenericAttributeMultivalue lSupportPackage = new GenericAttributeMultivalue(aLevel.getSupportPackage());
            GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lRelease, lSupportPackage});
            return new GenericDataInstance(aLevel.getClass().getName(), lAttributes);
        }
    }
}

