/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.HelperFunctions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HmiUrlQuery {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$api$HmiUrlQuery == null ? (class$com$sap$aii$util$hmi$api$HmiUrlQuery = HmiUrlQuery.class$("com.sap.aii.util.hmi.api.HmiUrlQuery")) : class$com$sap$aii$util$hmi$api$HmiUrlQuery).getName());
    private static final String sClassName = (class$com$sap$aii$util$hmi$api$HmiUrlQuery == null ? (class$com$sap$aii$util$hmi$api$HmiUrlQuery = HmiUrlQuery.class$("com.sap.aii.util.hmi.api.HmiUrlQuery")) : class$com$sap$aii$util$hmi$api$HmiUrlQuery).getName();
    private Map iAllParameters;
    private Map iServletParameters;
    private Map iWorkerParameters;
    private Map iMethodInputParameters;
    static /* synthetic */ Class class$com$sap$aii$util$hmi$api$HmiUrlQuery;

    public HmiUrlQuery(HttpServletRequest aRequest) {
        HashMap<String, String> lRequestParameters = new HashMap<String, String>();
        Enumeration lEnum = aRequest.getParameterNames();
        while (lEnum.hasMoreElements()) {
            String lParameterName = (String)lEnum.nextElement();
            String lParameterValue = aRequest.getParameter(lParameterName);
            lRequestParameters.put(lParameterName, lParameterValue);
        }
        this.iAllParameters = new HashMap(lRequestParameters);
        this.iServletParameters = HmiUrlQuery.extractEntries(ReservedParameterNames.getServletParameterNames(), lRequestParameters, true);
        this.iWorkerParameters = HmiUrlQuery.extractEntries(ReservedParameterNames.getWorkerParameterNames(), lRequestParameters, true);
        this.iMethodInputParameters = new HashMap();
        String lMipp = this.getValue("mipnp", null);
        if (lMipp != null) {
            this.iMethodInputParameters.putAll(HmiUrlQuery.extractEntries(lMipp, lRequestParameters, true));
        }
        this.iMethodInputParameters.putAll(lRequestParameters);
        String lLogExtractionAsString = this.getValue("logex", "false");
        boolean lLogExtraction = Boolean.valueOf(lLogExtractionAsString);
        sLogger.log(Level.FINEST, "Log extraction: " + lLogExtraction);
        if (lLogExtraction) {
            String lLogMsg = "HmiUrlQuery = \n" + this.toString();
            sLogger.log(Level.INFO, lLogMsg);
        }
    }

    public String getValue(String aParameterName, String aParameterValueDefault) {
        String lValue = (String)this.iAllParameters.get(aParameterName);
        if (lValue == null) {
            lValue = aParameterValueDefault;
        }
        return lValue;
    }

    public String getValue(String aParameterName) throws HmiCoreException {
        String lValue = (String)this.iAllParameters.get(aParameterName);
        if (lValue == null) {
            throw HmiCoreException.newProgrammingModelViolation(sClassName, "getValue(String aParameter)", "The parameter with name \"" + aParameterName + "\" is mandatory but not set in URL query string!");
        }
        return lValue;
    }

    public String getContainer() {
        return this.getValue("container", "ejb");
    }

    public Map getServletParameters() {
        return this.iServletParameters;
    }

    public Map getWorkerParameters() {
        return this.iWorkerParameters;
    }

    public Map getMethodInputParameters() {
        return this.iMethodInputParameters;
    }

    private static Map extractEntries(Object[] aKeys, Map aMap, boolean aDeleteExtracted) {
        HashMap lExtractedEntries = new HashMap();
        int i = 0;
        while (i < aKeys.length) {
            Object lValue = aMap.get(aKeys[i]);
            if (lValue != null) {
                lExtractedEntries.put(aKeys[i], lValue);
                if (aDeleteExtracted) {
                    aMap.remove(aKeys[i]);
                }
            }
            ++i;
        }
        return lExtractedEntries;
    }

    private static Map extractEntries(String aPrefix, Map aMap, boolean aDeleteExtracted) {
        HashMap lExtractedEntries = new HashMap();
        Iterator lEntries = aMap.entrySet().iterator();
        while (lEntries.hasNext()) {
            Map.Entry lEntry = lEntries.next();
            String lKey = (String)lEntry.getKey();
            if (!lKey.substring(0, aPrefix.length()).equals(aPrefix)) continue;
            Object lValue = lEntry.getValue();
            lExtractedEntries.put(lKey.substring(aPrefix.length()), lValue);
            if (!aDeleteExtracted) continue;
            aMap.remove(lKey);
        }
        return lExtractedEntries;
    }

    public String toString() {
        HashMap<String, String> lAttributes = new HashMap<String, String>();
        lAttributes.put("AllParameters", HelperFunctions.mapToString(this.iAllParameters));
        lAttributes.put("ServletParameters", HelperFunctions.mapToString(this.iServletParameters));
        lAttributes.put("WorkerParameters", HelperFunctions.mapToString(this.iWorkerParameters));
        lAttributes.put("MethodInputParameters", HelperFunctions.mapToString(this.iMethodInputParameters));
        return HelperFunctions.mapToString(lAttributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class ParameterValues {
        public static final String DefaultNameOfParameterInBody = "body";
        public static final String DefaultClientUser = "";
        public static final String DefaultClientPassword = "";
        public static final String DefaultClientLanguage = "EN";
        public static final String DefaultLogExtraction = "false";
        public static final String DefaultContainer = "ejb";
    }

    public static abstract class ReservedParameterNames {
        public static final String Container = "container";
        public static final String ServiceId = "service";
        public static final String MethodId = "method";
        public static final String Release = "release";
        public static final String SupportPackage = "sp";
        public static final String ClientUser = "user";
        public static final String ClientPassword = "pwd";
        public static final String ClientLanguage = "language";
        public static final String NameOfParameterInBody = "body";
        public static final String MethodInputParameterNamePrefix = "mipnp";
        public static final String LogExtraction = "logex";
        private static final String[] sServletParameterNames = new String[]{"container"};
        private static final String[] sWorkerParameterNames = new String[]{"service", "method", "release", "sp", "user", "pwd", "language", "body", "mipnp", "logex"};

        public static String[] getServletParameterNames() {
            return sServletParameterNames;
        }

        public static String[] getWorkerParameterNames() {
            return sWorkerParameterNames;
        }
    }
}

