/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.base64.api.Base64;
import com.sap.aii.util.hmi.api.HmiClientAdapter;
import com.sap.aii.util.hmi.api.HmiCoreException;
import com.sap.aii.util.hmi.api.IHmiHttpURLConnectionFactory;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.hmi.core.gdi2.GdiCharStreamer;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.msg.HmiRequest;
import com.sap.aii.util.hmi.core.msg.HmiResponse;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.HelperFunctions;
import com.sap.aii.util.misc.api.Language;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;

public class HmiHttpClientImpl
extends HmiClientAdapter {
    private static final Logger sLogger = Logger.getLogger((class$com$sap$aii$util$hmi$api$HmiHttpClientImpl == null ? (class$com$sap$aii$util$hmi$api$HmiHttpClientImpl = HmiHttpClientImpl.class$("com.sap.aii.util.hmi.api.HmiHttpClientImpl")) : class$com$sap$aii$util$hmi$api$HmiHttpClientImpl).getName());
    private URL iServletUrl;
    private String iHttpRequestMethod;
    private String iSessionCookie;
    private IHmiHttpURLConnectionFactory iHttpURLConnectionFactory;
    static /* synthetic */ Class class$com$sap$aii$util$hmi$api$HmiHttpClientImpl;

    private IHmiHttpURLConnectionFactory getHttpURLConnectionFactory() {
        return this.iHttpURLConnectionFactory;
    }

    HmiHttpClientImpl(IHmiHttpURLConnectionFactory aHttpURLConnectionFactory, String aHttpRequestMethod, URL aServletUrl, boolean aRequiresSession, UriElement aServiceId, String aUser, String aPassword, Language aLanguage, ApplCompLevel aLevel) {
        super(aRequiresSession, aServiceId, aUser, aPassword, aLanguage, aLevel);
        this.iServletUrl = aServletUrl;
        this.iHttpRequestMethod = aHttpRequestMethod;
        this.iSessionCookie = null;
        this.iHttpURLConnectionFactory = aHttpURLConnectionFactory;
    }

    public void allocateResources() throws HmiCoreException {
        if (this.iAreResourcesAllocated) {
            return;
        }
        this.iAreResourcesAllocated = true;
    }

    public void freeResources() throws HmiCoreException {
        this.iAreResourcesAllocated = false;
    }

    public URL getServletUrl() {
        return this.iServletUrl;
    }

    public HmiResponse sendRequestAndReceiveResponse(HmiRequest aRequest) throws HmiCoreException {
        String lRequestAsString = HmiRequest.render(aRequest);
        String lResponseAsString = this.sendRequestAndReceiveResponseViaHttp(lRequestAsString);
        GenericDataInstance lResponseAsGdi = GdiCharStreamer.stringToGdi(lResponseAsString);
        HmiResponse lResponse = HmiResponse.parseGdi(lResponseAsGdi);
        return lResponse;
    }

    /*
     * WARNING - void declaration
     */
    public String sendRequestAndReceiveResponseViaHttp(String aRequest) throws HmiCoreException {
        sLogger.log(Level.FINE, "Processing request ...");
        HttpURLConnection lUrlConnection = null;
        String lResponse = "";
        try {
            lUrlConnection = this.getHttpURLConnectionFactory().createConnection(this.iServletUrl);
            lUrlConnection.setRequestMethod(this.iHttpRequestMethod);
            lUrlConnection.setDoOutput(true);
            lUrlConnection.setDoInput(true);
            sLogger.log(Level.FINE, "Opened \"" + this.iHttpRequestMethod + "\" http url connection to \"" + this.iServletUrl.toString() + "\".");
        }
        catch (Exception e) {
            String lMsg = "Exception while openting http url connection to \"" + this.iServletUrl.toString() + "\"! Message is: " + e.getMessage();
            String lExc = HelperFunctions.getThrowableAsString(e);
            String lDetails = lMsg + "\nException:\n" + lExc;
            throw HmiCoreException.newCommunicationError(this.getServerLogicalSystemName(), this.getServerApplicationId(), lDetails);
        }
        try {
            if (this.iRequiresSession) {
                if (this.iSessionCookie != null) {
                    lUrlConnection.setRequestProperty("Cookie", this.iSessionCookie);
                    sLogger.log(Level.FINEST, "Continuing session --- cookie is:\n" + this.iSessionCookie);
                } else {
                    sLogger.log(Level.INFO, "Beginning session --- no cookie available yet!");
                }
            }
            if (this.getUser() == null || this.getUser().length() == 0 || "hmitestusenoauthorization".equals(this.getUser())) {
                sLogger.log(Level.FINEST, "No authentication.");
            } else {
                sLogger.log(Level.FINEST, "Using http basic authentication with user \"" + this.getUser() + "\".");
                String lUserAndPassword = this.getUser() + ":" + this.getPassword();
                String lAuthenticationString = Base64.encode(lUserAndPassword.getBytes());
                lUrlConnection.setRequestProperty("Authorization", "Basic " + lAuthenticationString);
            }
            String lCharacterEncoding = "UTF-8";
            String lContentTypeAndCharset = "text/xml; charset=" + lCharacterEncoding;
            lUrlConnection.setRequestProperty("Content-Type", lContentTypeAndCharset);
            sLogger.log(Level.FINEST, "Request content type = " + lContentTypeAndCharset);
            OutputStream lOutputStream = lUrlConnection.getOutputStream();
            OutputStreamWriter lOutputStreamWriter = new OutputStreamWriter(lOutputStream, lCharacterEncoding);
            BufferedWriter lBufferedWriter = new BufferedWriter(lOutputStreamWriter);
            lBufferedWriter.write(aRequest);
            lBufferedWriter.close();
            sLogger.log(Level.FINE, "Sent request to \"" + this.iServletUrl.toString() + "\".");
            sLogger.log(Level.FINEST, "Request is:\n" + aRequest);
        }
        catch (IOException e) {
            String lDetailedInformation = "IOException while sending request to \"" + this.iServletUrl.toString() + "\"! Message is: " + e.getMessage();
            throw HmiCoreException.newCommunicationError(this.getServerLogicalSystemName(), this.getServerApplicationId(), lDetailedInformation);
        }
        String lContentEncoding = null;
        try {
            String lInputLine;
            String lContentTypeAndCharset;
            sLogger.log(Level.FINE, "Waiting for response from \"" + this.iServletUrl.toString() + "\" ...");
            lUrlConnection.connect();
            int lResponseCode = lUrlConnection.getResponseCode();
            switch (lResponseCode) {
                case 200: 
                case 201: 
                case 202: {
                    break;
                }
                default: {
                    String lMsg = "Error accessing \"" + this.iServletUrl.toString() + "\" with user \"" + this.getUser() + "\"." + " Response code is " + lResponseCode + ", response message is \"" + lUrlConnection.getResponseMessage() + "\"";
                    sLogger.error(lMsg + " ==> throwing exception now ...");
                    throw HmiCoreException.newCommunicationError(super.getServerLogicalSystemName(), super.getServerApplicationId(), lMsg);
                }
            }
            if (this.iRequiresSession) {
                String lMessage;
                String lSessionCookie = lUrlConnection.getHeaderField("Set-Cookie");
                if (lSessionCookie != null) {
                    lMessage = "Setting cookie from \"" + this.iSessionCookie + "\" to \"" + lSessionCookie + "\".";
                    sLogger.log(Level.FINEST, lMessage);
                    this.iSessionCookie = lSessionCookie;
                } else if (this.iSessionCookie != null) {
                    lMessage = "Keeping cookie \"" + this.iSessionCookie + "\".";
                    sLogger.log(Level.FINEST, lMessage);
                } else {
                    sLogger.log(Level.WARNING, "No cookie! This causes problems in case of a cluster J2EE server!");
                }
            }
            if ((lContentTypeAndCharset = lUrlConnection.getContentType()) != null) {
                sLogger.log(Level.FINEST, "Response content type = " + lContentTypeAndCharset);
            } else {
                sLogger.log(Level.FINEST, "Response content type is not known!");
            }
            lContentEncoding = lUrlConnection.getContentEncoding();
            if (lContentEncoding == null) {
                lContentEncoding = "UTF-8";
                sLogger.log(Level.FINEST, "Response content encoding (default) = " + lContentEncoding);
            } else {
                sLogger.log(Level.FINEST, "Response content encoding (from URL connection) = " + lContentEncoding);
            }
            InputStream lInputStream = lUrlConnection.getInputStream();
            InputStreamReader lInputStreamReader = new InputStreamReader(lInputStream, lContentEncoding);
            BufferedReader lBufferedReader = new BufferedReader(lInputStreamReader);
            sLogger.log(Level.FINE, "Reading response ...");
            while ((lInputLine = lBufferedReader.readLine()) != null) {
                void var11_19;
                lResponse = lResponse + (String)var11_19 + "\n";
            }
            lBufferedReader.close();
            sLogger.log(Level.FINEST, "Response is:\n" + HelperFunctions.trunc(lResponse, 4096, true));
        }
        catch (IOException e) {
            this.logErrorStream(lUrlConnection, lContentEncoding);
            String lDetailedInformation = "Error receiving http response from URL \"" + this.iServletUrl.toString() + "\"! Details: caught exception\n" + HelperFunctions.getThrowableAsString(e);
            throw HmiCoreException.newCommunicationError(this.getServerLogicalSystemName(), this.getServerApplicationId(), lDetailedInformation);
        }
        sLogger.log(Level.FINE, "Processed request to \"" + this.iServletUrl.toString() + "\".");
        return lResponse;
    }

    private void logErrorStream(HttpURLConnection aUrlConnection, String aEncoding) {
        String lErrorString = "Content of HTTP Response:\n";
        try {
            InputStream lErrorStream = aUrlConnection.getErrorStream();
            if (lErrorStream == null) {
                return;
            }
            if (aEncoding == null) {
                aEncoding = "UTF-8";
            }
            BufferedReader lReader = new BufferedReader(new InputStreamReader(lErrorStream, aEncoding));
            String lLine = null;
            while ((lLine = lReader.readLine()) != null) {
                lErrorString = lErrorString + lLine + "\n";
            }
        }
        catch (UnsupportedEncodingException e) {
            lErrorString = lErrorString + "\n ... caught exception\n" + HelperFunctions.getThrowableAsString(e);
        }
        catch (IOException e) {
            lErrorString = lErrorString + "\n ... caught exception\n" + HelperFunctions.getThrowableAsString(e);
        }
        sLogger.fine(lErrorString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

