/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.hmi.api;

import com.sap.aii.util.applcomp.ApplCompLevel;
import com.sap.aii.util.hmi.api.HmiExceptionAdapter;
import com.sap.aii.util.hmi.api.UriElement;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributeMultivalue;
import com.sap.aii.util.hmi.core.gdi2.GenericAttributes;
import com.sap.aii.util.hmi.core.gdi2.GenericDataInstance;
import com.sap.aii.util.hmi.core.gdi2.GenericallyRepresentable;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.misc.api.BabelMessage;

public class HmiCoreException
extends HmiExceptionAdapter
implements GenericallyRepresentable {
    private static final String sResourceBundleId = "com.sap.aii.util.hmi.api.rb_all";
    private static final String sPrefixOfKey = "HCX_";
    private String iSubtypeId;
    private static String[] sAttributeNames = new String[]{"LocalizedMessage", "OriginalStackTrace", "SubtypeId", "Severity"};

    public String getSubtypeId() {
        return this.iSubtypeId;
    }

    private static String getResourceId(String aSubtypeId) {
        return "com.sap.aii.util.hmi.api.rb_all.HCX_" + aSubtypeId;
    }

    private HmiCoreException(String aSubtypeId, Level aSeverity, BabelMessage aMessage) {
        super(aMessage);
        this.setSeverity(aSeverity);
        this.iSubtypeId = aSubtypeId;
    }

    public static HmiCoreException newCannotSetAuthenticator(String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("CANNOT_SET_AUTHENTICATOR"), aDetailedInformation);
        return new HmiCoreException("CANNOT_SET_AUTHENTICATOR", Level.FATAL, lMessage);
    }

    public static HmiCoreException newCommunicationError(String aSystem, String aApplication, String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("COMMUNICATION_ERROR"), (Object)aSystem, (Object)aApplication, (Object)aDetailedInformation);
        return new HmiCoreException("COMMUNICATION_ERROR", Level.ERROR, lMessage);
    }

    public static HmiCoreException newMethodDoesNotExist(UriElement aServiceId, UriElement aMethodId, ApplCompLevel aLevel) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("METHOD_DOES_NOT_EXIST"), new Object[]{aServiceId, aMethodId, aLevel.getRelease(), aLevel.getSupportPackage()});
        return new HmiCoreException("METHOD_DOES_NOT_EXIST", Level.FATAL, lMessage);
    }

    public static HmiCoreException newNotAuthorized(String aSystem, String aApplication, String aService, String aMethod, String aUser) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("NOT_AUTHORIZED"), new String[]{aSystem, aApplication, aService, aMethod, aUser});
        return new HmiCoreException("NOT_AUTHORIZED", Level.INFO, lMessage);
    }

    public static HmiCoreException newParsingError(String aClassName, String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("PARSING_ERROR"), (Object)aClassName, (Object)aDetailedInformation);
        return new HmiCoreException("PARSING_ERROR", Level.FATAL, lMessage);
    }

    public static HmiCoreException newRenderingError(String aClassName, String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("RENDERING_ERROR"), (Object)aClassName, (Object)aDetailedInformation);
        return new HmiCoreException("RENDERING_ERROR", Level.FATAL, lMessage);
    }

    public static HmiCoreException newParameterNameNotOfTypeString(Object aParameterName, Object aParameterValue, String aTypeOfParameterName) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("PNAME_NOT_OF_TYPE_STRING"), aParameterName, aParameterValue, (Object)aTypeOfParameterName);
        return new HmiCoreException("PNAME_NOT_OF_TYPE_STRING", Level.FATAL, lMessage);
    }

    public static HmiCoreException newParameterValueNotOfTypeString(Object aParameterName, Object aParameterValue, String aTypeOfParameterValue) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("PVALUE_NOT_OF_TYPE_STRING"), aParameterName, aParameterValue, (Object)aTypeOfParameterValue);
        return new HmiCoreException("PVALUE_NOT_OF_TYPE_STRING", Level.FATAL, lMessage);
    }

    public static HmiCoreException newConfigurationError(String aPropertyName, String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("CONFIGURATION_ERROR"), (Object)aPropertyName, (Object)aDetailedInformation);
        return new HmiCoreException("CONFIGURATION_ERROR", Level.ERROR, lMessage);
    }

    public static HmiCoreException newProgrammingModelViolation(String aClassName, String aMethodName, String aDetailedInformation) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("PROGRAMMING_MODEL_VIOLATION"), (Object)aClassName, (Object)aMethodName, (Object)aDetailedInformation);
        return new HmiCoreException("PROGRAMMING_MODEL_VIOLATION", Level.FATAL, lMessage);
    }

    public static HmiCoreException newUnexpectedServerException(String aSystem, String aApplication, String aDetailedInformation, String aServerStackTrace) {
        BabelMessage lMessage = new BabelMessage(HmiCoreException.getResourceId("UNEXPECTED_SERVER_EXCEPTION"), new Object[]{aSystem, aApplication, aDetailedInformation, "\n" + aServerStackTrace});
        return new HmiCoreException("UNEXPECTED_SERVER_EXCEPTION", Level.FATAL, lMessage);
    }

    private HmiCoreException() {
        this.iSubtypeId = null;
    }

    public static GenericDataInstance renderGdi(HmiCoreException aCoreException) throws HmiCoreException {
        if (aCoreException == null) {
            return null;
        }
        GenericDataInstance lCoreException = aCoreException.getState();
        return lCoreException;
    }

    public static HmiCoreException parseGdi(GenericDataInstance aCoreException) throws HmiCoreException {
        if (aCoreException == null) {
            return null;
        }
        HmiCoreException lCoreException = new HmiCoreException();
        lCoreException.setState(aCoreException);
        return lCoreException;
    }

    public void setState(GenericDataInstance aState) {
        this.setMessage(aState.getAttributes().getValue("LocalizedMessage").getString(0));
        this.iOriginalStackTrace = aState.getAttributes().getValue("OriginalStackTrace").getString(0);
        this.iSubtypeId = aState.getAttributes().getValue("SubtypeId").getString(0);
        String lSeverity = aState.getAttributes().getValue("Severity").getString(0);
        Level lSeverityAsLevel = Level.getLevel(lSeverity);
        if (lSeverityAsLevel == null) {
            lSeverityAsLevel = Level.FATAL;
        }
        this.setSeverity(lSeverityAsLevel);
    }

    public GenericDataInstance getState() {
        GenericAttributeMultivalue lLocalizedMessage = new GenericAttributeMultivalue(this.getMessage());
        GenericAttributeMultivalue lOriginalStackTrace = new GenericAttributeMultivalue(this.iOriginalStackTrace);
        GenericAttributeMultivalue lSubtypeId = new GenericAttributeMultivalue(this.iSubtypeId);
        Level lSeverityAsLevel = this.getSeverity();
        String lSeverityAsString = lSeverityAsLevel != null ? lSeverityAsLevel.getName() : null;
        GenericAttributeMultivalue lSeverity = new GenericAttributeMultivalue(lSeverityAsString);
        GenericAttributes lAttributes = new GenericAttributes(sAttributeNames, new GenericAttributeMultivalue[]{lLocalizedMessage, lOriginalStackTrace, lSubtypeId, lSeverity});
        return new GenericDataInstance(this.getClass().getName(), lAttributes);
    }

    public static interface SubtypeIds {
        public static final String CannotSetAuthenticator = "CANNOT_SET_AUTHENTICATOR";
        public static final String CommunicationError = "COMMUNICATION_ERROR";
        public static final String ConfigurationError = "CONFIGURATION_ERROR";
        public static final String MethodDoesNotExist = "METHOD_DOES_NOT_EXIST";
        public static final String NotAuthorized = "NOT_AUTHORIZED";
        public static final String ParsingError = "PARSING_ERROR";
        public static final String RenderingError = "RENDERING_ERROR";
        public static final String ParameterNameNotOfTypeString = "PNAME_NOT_OF_TYPE_STRING";
        public static final String ParameterValueNotOfTypeString = "PVALUE_NOT_OF_TYPE_STRING";
        public static final String ProgrammingModelViolation = "PROGRAMMING_MODEL_VIOLATION";
        public static final String UnexpectedServerException = "UNEXPECTED_SERVER_EXCEPTION";
    }
}

