/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.base64.api;

import com.sap.aii.util.misc.api.UnexpectedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Base64OutputStream
extends OutputStream {
    private static char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private int col = 0;
    private int i = 0;
    private int[] inbuf = new int[3];
    private int linelength = 0;
    private Writer out;

    public Base64OutputStream(Writer out) {
        this.out = out;
    }

    public Base64OutputStream(OutputStream out) {
        try {
            this.out = new OutputStreamWriter(out, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e);
        }
    }

    public void setLineLength(int length) {
        this.linelength = length - 3;
    }

    public void write(int c) throws IOException {
        this.inbuf[this.i] = c;
        ++this.i;
        if (this.i == 3) {
            this.out.write(toBase64[(this.inbuf[0] & 0xFC) >> 2]);
            this.out.write(toBase64[(this.inbuf[0] & 3) << 4 | (this.inbuf[1] & 0xF0) >> 4]);
            this.out.write(toBase64[(this.inbuf[1] & 0xF) << 2 | (this.inbuf[2] & 0xC0) >> 6]);
            this.out.write(toBase64[this.inbuf[2] & 0x3F]);
            this.col += 4;
            this.i = 0;
            if (this.linelength > 0 && this.col >= this.linelength) {
                this.out.write(10);
                this.col = 0;
            }
        }
    }

    public void flush() throws IOException {
        if (this.i == 1) {
            this.out.write(toBase64[(this.inbuf[0] & 0xFC) >> 2]);
            this.out.write(toBase64[(this.inbuf[0] & 3) << 4]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.i == 2) {
            this.out.write(toBase64[(this.inbuf[0] & 0xFC) >> 2]);
            this.out.write(toBase64[(this.inbuf[0] & 3) << 4 | (this.inbuf[1] & 0xF0) >> 4]);
            this.out.write(toBase64[(this.inbuf[1] & 0xF) << 2]);
            this.out.write(61);
        }
        this.i = 0;
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
    }
}

