/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.applcomp;

import com.sap.aii.util.misc.api.HelperFunctions;

public class ApplCompLevel
implements Comparable {
    public static final String sAnyRelease = "*";
    public static final String sNoRelease = "0";
    public static final String sAnySupportPackage = "*";
    public static final String sNoSupportPackage = "0";
    private String iRelease;
    private String iSupportPackage;

    public ApplCompLevel(String aRelease, String aSupportPackage) {
        this.iRelease = aRelease;
        this.iSupportPackage = aSupportPackage;
    }

    private String getId() {
        return "R_" + this.iRelease + "__SP_" + this.iSupportPackage;
    }

    public String getRelease() {
        return this.iRelease;
    }

    public String getSupportPackage() {
        return this.iSupportPackage;
    }

    public boolean hasAnySupportPackage() {
        return this.iSupportPackage.equals("*");
    }

    public boolean hasNoSupportPackage() {
        return this.iSupportPackage.equals("0");
    }

    public int hashCode() {
        return this.iRelease.hashCode() + this.iSupportPackage.hashCode();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof ApplCompLevel)) {
            return false;
        }
        ApplCompLevel that = (ApplCompLevel)aObject;
        return this.iRelease.equals(that.iRelease) && this.iSupportPackage.equals(that.iSupportPackage);
    }

    public int compareTo(Object aObject) {
        if (!(aObject instanceof ApplCompLevel)) {
            return this.getClass().getName().compareTo(aObject.getClass().getName());
        }
        ApplCompLevel that = (ApplCompLevel)aObject;
        if (!this.iRelease.equals(that.iRelease)) {
            return this.iRelease.compareTo(that.iRelease);
        }
        return this.iSupportPackage.compareTo(that.iSupportPackage);
    }

    public String toString() {
        return HelperFunctions.tupelToString(this.iRelease, this.iSupportPackage);
    }

    public static interface Constants {
        public static final ApplCompLevel XI_20_N = new ApplCompLevel("2.0", "0");
        public static final ApplCompLevel XI_30_N = new ApplCompLevel("3.0", "0");
        public static final ApplCompLevel CurrentLevel = new ApplCompLevel("3.0", "0");
    }
}

