/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MsgType;
import com.sap.tc.logging.Severity;

public class XMLFormatter
extends Formatter {
    static String version = "$Id: //sapmarkets/Logging/630_REL/src/_Logging/java/com/sap/tc/logging/XMLFormatter.java#5 $";
    private static final String VERSION = "1.6";
    private static final int INITIAL_CAPACITY = 512;

    public String format(LogRecord rec) {
        StringBuffer res = new StringBuffer(512);
        StringBuffer esc = new StringBuffer();
        res.append("  <record>");
        res.append(Formatter.EOL);
        res.append("    <id>");
        res.append(rec.getId());
        res.append("</id>");
        res.append(Formatter.EOL);
        res.append("    <time>");
        res.append(rec.getTime().getTime());
        res.append("</time>");
        res.append(Formatter.EOL);
        res.append("    <source>");
        res.append((Object)this.escape(rec.getSourceName(), esc));
        res.append("</source>");
        res.append(Formatter.EOL);
        res.append("    <application>");
        res.append((Object)this.escape(rec.getApplication(), esc));
        res.append("</application>");
        res.append(Formatter.EOL);
        res.append("    <location>");
        res.append((Object)this.escape(rec.getLocationName(), esc));
        res.append("</location>");
        res.append(Formatter.EOL);
        res.append("    <user>");
        res.append((Object)this.escape(rec.getUser(), esc));
        res.append("</user>");
        res.append(Formatter.EOL);
        res.append("    <session>");
        res.append((Object)this.escape(rec.getSession(), esc));
        res.append("</session>");
        res.append(Formatter.EOL);
        res.append("    <transaction>");
        res.append((Object)this.escape(rec.getTransaction(), esc));
        res.append("</transaction>");
        res.append(Formatter.EOL);
        res.append("    <dsr-component>");
        res.append((Object)this.escape(rec.getDsrComponent(), esc));
        res.append("</dsr-component>");
        res.append(Formatter.EOL);
        res.append("    <dsr-user>");
        res.append((Object)this.escape(rec.getDsrUser(), esc));
        res.append("</dsr-user>");
        res.append(Formatter.EOL);
        res.append("    <dsr-transaction>");
        res.append((Object)this.escape(rec.getDsrTransaction(), esc));
        res.append("</dsr-transaction>");
        res.append(Formatter.EOL);
        res.append("    <thread>");
        res.append((Object)this.escape(rec.getThreadName(), esc));
        res.append("</thread>");
        res.append(Formatter.EOL);
        if (rec.getGroupLevel() > 0) {
            res.append("    <group>");
            res.append(Formatter.EOL);
            res.append("      <id>");
            res.append(rec.getGroupID());
            res.append("</id>");
            res.append(Formatter.EOL);
            res.append("      <level>");
            res.append(rec.getGroupLevel());
            res.append("</level>");
            res.append(Formatter.EOL);
            res.append("      <indent>");
            res.append(rec.getGroupIndent());
            res.append("</indent>");
            res.append(Formatter.EOL);
            res.append("    </group>");
            res.append(Formatter.EOL);
        }
        res.append("    <severity>");
        res.append(Severity.toString(rec.getSeverity()));
        res.append("</severity>");
        res.append(Formatter.EOL);
        String[] relatives = rec.getRelativesInt();
        if (relatives != null && relatives.length > 0) {
            res.append("    <relatives>");
            res.append(Formatter.EOL);
            int i = 0;
            while (i < relatives.length) {
                res.append("      <relative>");
                res.append((Object)this.escape(relatives[i], esc));
                res.append("</relative>");
                res.append(Formatter.EOL);
                ++i;
            }
            res.append("    </relatives>");
            res.append(Formatter.EOL);
        }
        res.append("    <msg-type>");
        res.append(MsgType.toString(rec.getMsgType()));
        res.append("</msg-type>");
        res.append(Formatter.EOL);
        if (rec.getMsgCode().length() > 0) {
            res.append("    <msg-code>");
            res.append(rec.getMsgCode());
            res.append("</msg-code>");
            res.append(Formatter.EOL);
        }
        if (rec.getResourceBundleName().length() > 0) {
            res.append("    <bundle>");
            res.append(rec.getResourceBundleName());
            res.append("</bundle>");
            res.append(Formatter.EOL);
        }
        if (rec.getMsgClear().length() > 0) {
            res.append("    <msg-clear>");
            res.append((Object)this.escape(rec.getMsgClear(), esc));
            res.append("</msg-clear>");
            res.append(Formatter.EOL);
        }
        switch (rec.getMsgType()) {
            case 0: {
                break;
            }
            case 1: {
                Object[] args = rec.getArgsInt();
                if (args == null || args.length <= 0) break;
                res.append("    <args>");
                res.append(Formatter.EOL);
                int i = 0;
                while (i < args.length) {
                    res.append("      <arg>");
                    try {
                        res.append((Object)this.escape(args[i].toString(), esc));
                    }
                    catch (Exception ex) {
                        res.append((Object)this.escape("<null>", esc));
                    }
                    res.append("</arg>");
                    res.append(Formatter.EOL);
                    ++i;
                }
                res.append("    </args>");
                res.append(Formatter.EOL);
                break;
            }
        }
        res.append("  </record>");
        res.append(Formatter.EOL);
        return res.toString();
    }

    public String getHeader(Log log) {
        String enc = log.getEncoding();
        String res = "<?xml version=\"1.0\"";
        if (enc != null) {
            res = res + " encoding=\"" + enc + "\"";
        }
        res = res + "?>" + Formatter.EOL + Formatter.EOL + "<!DOCTYPE log" + Formatter.EOL + "[" + Formatter.EOL + "<!ELEMENT log (version, record*)>" + Formatter.EOL + "<!ELEMENT version (#PCDATA)>" + Formatter.EOL + "<!ELEMENT record (id, time, source, application, location, user, session, transaction, dsr-component, dsr-user, dsr-transaction, thread, group?, severity, relatives?, msg-type, msg-code?, bundle?, msg-clear?, args?)>" + Formatter.EOL + "<!ELEMENT id (#PCDATA)>" + Formatter.EOL + "<!ELEMENT time (#PCDATA)>" + Formatter.EOL + "<!ELEMENT source (#PCDATA)>" + Formatter.EOL + "<!ELEMENT application (#PCDATA)>" + Formatter.EOL + "<!ELEMENT location (#PCDATA)>" + Formatter.EOL + "<!ELEMENT user (#PCDATA)>" + Formatter.EOL + "<!ELEMENT session (#PCDATA)>" + Formatter.EOL + "<!ELEMENT transaction (#PCDATA)>" + Formatter.EOL + "<!ELEMENT dsr-component (#PCDATA)>" + Formatter.EOL + "<!ELEMENT dsr-user (#PCDATA)>" + Formatter.EOL + "<!ELEMENT dsr-transaction (#PCDATA)>" + Formatter.EOL + "<!ELEMENT thread (#PCDATA)>" + Formatter.EOL + "<!ELEMENT group (id, level, indent)>" + Formatter.EOL + "<!ELEMENT level (#PCDATA)>" + Formatter.EOL + "<!ELEMENT indent (#PCDATA)>" + Formatter.EOL + "<!ELEMENT severity (#PCDATA)>" + Formatter.EOL + "<!ELEMENT relatives (relative+)>" + Formatter.EOL + "<!ELEMENT relative (#PCDATA)>" + Formatter.EOL + "<!ELEMENT msg-type (#PCDATA)>" + Formatter.EOL + "<!ELEMENT msg-code (#PCDATA)>" + Formatter.EOL + "<!ELEMENT bundle (#PCDATA)>" + Formatter.EOL + "<!ELEMENT msg-clear (#PCDATA)>" + Formatter.EOL + "<!ELEMENT args (arg+)>" + Formatter.EOL + "<!ELEMENT arg (#PCDATA)>" + Formatter.EOL + "]>" + Formatter.EOL + Formatter.EOL + "<log>" + Formatter.EOL + "  <version>" + VERSION + "</version>" + Formatter.EOL;
        return res.toString();
    }

    public String getFooter(Log log) {
        return "</log>" + Formatter.EOL;
    }

    protected StringBuffer escape(String s, StringBuffer buf) {
        int len = 0;
        if (s == null) {
            s = "";
        }
        len = s.length();
        buf.setLength(0);
        buf.append(s);
        int i = 0;
        while (i < len) {
            switch (buf.charAt(i)) {
                case '<': {
                    buf.replace(i, i + 1, "&lt;");
                    len += 3;
                    i += 3;
                    break;
                }
                case '>': {
                    buf.replace(i, i + 1, "&gt;");
                    len += 3;
                    i += 3;
                }
            }
            ++i;
        }
        return buf;
    }
}

