/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.bc.krn.perf.PerfTimes;
import java.net.InetAddress;

public class UID {
    private final short threadID;
    private final int threadCounter;
    private final long timeStamp;
    private final long nodeAddress;
    private final int processID;
    private static long nodeaddress;
    private static int pid;
    private static short sThreadID;
    private static ThreadLocal sThreadLocal;
    private static final char[] hexDigits;
    static PerfTimes perf;

    public UID() {
        this.nodeAddress = nodeaddress;
        this.processID = pid;
        ThreadLocalInfo info = UID.getThreadLocalInfo();
        this.threadID = info.getTID();
        this.threadCounter = info.incThreadCounter();
        this.timeStamp = perf != null ? perf.elapsed() : System.currentTimeMillis() * 1000L;
    }

    private UID(long node, int pid, short tid, int tidcount, long time) {
        this.nodeAddress = node;
        this.processID = pid;
        this.threadID = tid;
        this.threadCounter = tidcount;
        this.timeStamp = time;
    }

    public String toString() {
        char[] buf = new char[48];
        int n1 = (int)this.timeStamp;
        buf[47] = hexDigits[n1 & 0xF];
        buf[46] = hexDigits[n1 >>> 4 & 0xF];
        buf[45] = hexDigits[n1 >>> 8 & 0xF];
        buf[44] = hexDigits[n1 >>> 12 & 0xF];
        buf[43] = hexDigits[n1 >>> 16 & 0xF];
        buf[42] = hexDigits[n1 >>> 20 & 0xF];
        buf[41] = hexDigits[n1 >>> 24 & 0xF];
        buf[40] = hexDigits[n1 >>> 28 & 0xF];
        int n2 = (int)(this.timeStamp >>> 32);
        buf[39] = hexDigits[n2 & 0xF];
        buf[38] = hexDigits[n2 >>> 4 & 0xF];
        buf[37] = hexDigits[n2 >>> 8 & 0xF];
        buf[36] = hexDigits[n2 >>> 12 & 0xF];
        buf[35] = hexDigits[n2 >>> 16 & 0xF];
        buf[34] = hexDigits[n2 >>> 20 & 0xF];
        buf[33] = hexDigits[n2 >>> 24 & 0xF];
        buf[32] = hexDigits[n2 >>> 28 & 0xF];
        int n3 = this.processID;
        buf[31] = hexDigits[n3 & 0xF];
        buf[30] = hexDigits[n3 >>> 4 & 0xF];
        buf[29] = hexDigits[n3 >>> 8 & 0xF];
        buf[28] = hexDigits[n3 >>> 12 & 0xF];
        buf[27] = hexDigits[n3 >>> 16 & 0xF];
        buf[26] = hexDigits[n3 >>> 20 & 0xF];
        buf[25] = hexDigits[n3 >>> 24 & 0xF];
        buf[24] = hexDigits[n3 >>> 28 & 0xF];
        int n4 = this.threadCounter;
        buf[23] = hexDigits[n4 & 0xF];
        buf[22] = hexDigits[n4 >>> 4 & 0xF];
        buf[21] = hexDigits[n4 >>> 8 & 0xF];
        buf[20] = hexDigits[n4 >>> 12 & 0xF];
        buf[19] = hexDigits[n4 >>> 16 & 0xF];
        buf[18] = hexDigits[n4 >>> 20 & 0xF];
        buf[17] = hexDigits[n4 >>> 24 & 0xF];
        buf[16] = hexDigits[n4 >>> 28 & 0xF];
        short n5 = this.threadID;
        buf[15] = hexDigits[n5 & 0xF];
        buf[14] = hexDigits[n5 >>> 4 & 0xF];
        buf[13] = hexDigits[n5 >>> 8 & 0xF];
        buf[12] = hexDigits[n5 >>> 12 & 0xF];
        int n6 = (int)this.nodeAddress;
        buf[11] = hexDigits[n6 & 0xF];
        buf[10] = hexDigits[n6 >>> 4 & 0xF];
        buf[9] = hexDigits[n6 >>> 8 & 0xF];
        buf[8] = hexDigits[n6 >>> 12 & 0xF];
        buf[7] = hexDigits[n6 >>> 16 & 0xF];
        buf[6] = hexDigits[n6 >>> 20 & 0xF];
        buf[5] = hexDigits[n6 >>> 24 & 0xF];
        buf[4] = hexDigits[n6 >>> 28 & 0xF];
        int n7 = (int)(this.nodeAddress >>> 32);
        buf[3] = hexDigits[n7 & 0xF];
        buf[2] = hexDigits[n7 >>> 4 & 0xF];
        buf[1] = hexDigits[n7 >>> 8 & 0xF];
        buf[0] = hexDigits[n7 >>> 12 & 0xF];
        return new String(buf);
    }

    public static final UID parseUID(String uid) throws NumberFormatException {
        if (uid == null || uid.length() != 48) {
            throw new NumberFormatException("Invalid uid :" + uid);
        }
        long node = Long.parseLong(uid.substring(0, 12), 16);
        short tid = (short)Long.parseLong(uid.substring(12, 16), 16);
        int tidcount = (int)Long.parseLong(uid.substring(16, 24), 16);
        int pid = (int)Long.parseLong(uid.substring(24, 32), 16);
        long time = Long.parseLong(uid.substring(32, 40), 16) << 32 | Long.parseLong(uid.substring(40, 48), 16);
        return new UID(node, pid, tid, tidcount, time);
    }

    public long getNodeAddress() {
        return this.nodeAddress;
    }

    public int getProcessID() {
        return this.processID;
    }

    public short getThreadID() {
        return this.threadID;
    }

    public int getThreadCounter() {
        return this.threadCounter;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public static void main(String[] args) {
        try {
            UID uid1 = new UID();
            Thread.sleep(50L);
            UID uid2 = new UID();
            String uidStr1 = uid1.toString();
            String uidStr2 = uid2.toString();
            UID uid = UID.parseUID(uidStr1);
            System.out.println(uidStr1);
            System.out.println("Node:      " + uid.getNodeAddress());
            System.out.println("PID:       " + uid.getProcessID());
            System.out.println("TID:       " + uid.getThreadID());
            System.out.println("TID count: " + uid.getThreadCounter());
            System.out.println("timestamp: " + uid.getTimeStamp());
            uid = UID.parseUID(uidStr2);
            System.out.println(uidStr2);
            System.out.println("Node:      " + uid.getNodeAddress());
            System.out.println("PID:       " + uid.getProcessID());
            System.out.println("TID:       " + uid.getThreadID());
            System.out.println("TID count: " + uid.getThreadCounter());
            System.out.println("timestamp: " + uid.getTimeStamp());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int getCurrentProcessID() {
        int result = 0;
        String pidStr = System.getProperty("jstartup.ownProcessId");
        if (pidStr != null) {
            try {
                result = (int)Long.parseLong(pidStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == 0) {
            result = new Object().hashCode();
        }
        return result;
    }

    private static long getnodeaddress() {
        String nodestr;
        try {
            perf = new PerfTimes();
            nodestr = perf.getMacAddress();
            if (nodestr != null && nodestr.length() == 12) {
                long value = Long.parseLong(nodestr, 16);
                return value;
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            nodestr = System.getProperty("ieee802.address");
            if (nodestr != null && nodestr.length() == 17) {
                long value = Long.parseLong(nodestr.substring(0, 2), 16) << 40 | Long.parseLong(nodestr.substring(3, 5), 16) << 32 | Long.parseLong(nodestr.substring(6, 8), 16) << 24 | Long.parseLong(nodestr.substring(9, 11), 16) << 16 | Long.parseLong(nodestr.substring(12, 14), 16) << 8 | Long.parseLong(nodestr.substring(15, 17), 16);
                return value;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            byte[] ipaddr = InetAddress.getLocalHost().getAddress();
            return 0xC00000000000L | (long)(0xFF & ipaddr[0]) << 24 | (long)(0xFF & ipaddr[1]) << 16 | (long)(0xFF & ipaddr[2]) << 8 | (long)(0xFF & ipaddr[3]);
        }
        catch (Exception exception) {
            return System.currentTimeMillis();
        }
    }

    private static final ThreadLocalInfo getThreadLocalInfo() {
        ThreadLocalInfo ti = (ThreadLocalInfo)sThreadLocal.get();
        if (ti == null) {
            short tid;
            ThreadLocal threadLocal = sThreadLocal;
            synchronized (threadLocal) {
                short s = sThreadID;
                sThreadID = (short)(s + 1);
                tid = s;
            }
            ti = new ThreadLocalInfo(tid);
            sThreadLocal.set(ti);
        }
        return ti;
    }

    static {
        sThreadID = 0;
        sThreadLocal = new ThreadLocal();
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        perf = null;
        nodeaddress = UID.getnodeaddress();
        pid = UID.getCurrentProcessID();
    }

    static final class ThreadLocalInfo {
        private short tid;
        private int threadCounter = 0;

        ThreadLocalInfo(short value) {
            this.tid = value;
        }

        private final short getTID() {
            return this.tid;
        }

        private final int incThreadCounter() {
            return this.threadCounter++;
        }

        private final int getThreadCounter() {
            return this.threadCounter;
        }
    }
}

