/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;

public class TraceFormatter
extends Formatter {
    static String version = "$Id: //sapmarkets/Logging/630_REL/src/_Logging/java/com/sap/tc/logging/TraceFormatter.java#6 $";
    private String pattern;
    private int[] type;
    private int[] width;
    private int[] align;
    private String[] text;
    private static final String STANDARD_PATTERN = "%24d %-40l [%t] %s: %m";
    private static final char ALIGN_CHAR = '|';
    private static final int ALIGN_CHAR_PERIOD = 3;
    private static final String OPEN_GROUP_STRING = "-->";
    private static final String CLOSE_GROUP_STRING = "<--";
    private static final DateFormat timeFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final int GUID = 0;
    private static final int STAMP = 1;
    private static final int DATE = 2;
    private static final int SOURCE = 3;
    private static final int APPLICATION = 4;
    private static final int LOC = 5;
    private static final int USER = 6;
    private static final int SESSION = 7;
    private static final int TRANSACTION = 8;
    private static final int DSR_COMPONENT = 9;
    private static final int DSR_USER = 10;
    private static final int DSR_TRANSACTION = 11;
    private static final int THREAD = 12;
    private static final int INDENT = 13;
    private static final int SEVERITY = 14;
    private static final int MESSAGE = 15;
    private static final int TEXT = 16;
    protected static final int MIN = 0;
    protected static final int LEFT = 1;
    protected static final int RIGHT = 2;
    protected static final int CENTER = 3;
    protected static final int SUPPRESS = 4;
    private static final int INITIAL_CAPACITY = 512;
    protected static final String INVALID_MSG_PATTERN = "Invalid message pattern: {0}";
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$TraceFormatter == null ? (class$com$sap$tc$logging$TraceFormatter = TraceFormatter.class$("com.sap.tc.logging.TraceFormatter")) : class$com$sap$tc$logging$TraceFormatter);
    static /* synthetic */ Class class$com$sap$tc$logging$TraceFormatter;

    public TraceFormatter() {
        this.setPattern(STANDARD_PATTERN);
    }

    public TraceFormatter(String pattern) {
        super(FormatterType.TRACEFORMAT);
        this.setPattern(pattern);
    }

    public boolean isCompleteMessage(String msg) {
        return true;
    }

    public boolean isParsable() {
        return true;
    }

    public boolean isStartMessage(String msg) {
        return true;
    }

    public LogRecord parseMsg(String completeMsgData) throws ParseException {
        return new LogRecord((LogController)new Location("UNKNOWN"), null, 0, null, 0, completeMsgData, null);
    }

    public LogRecord parseMsg(byte[] msgChunk) throws ParseException {
        String completeMsgData = "";
        if (msgChunk != null && msgChunk.length > 0) {
            completeMsgData = new String(msgChunk);
        }
        return new LogRecord((LogController)new Location("UNKNOWN"), null, 0, null, 0, completeMsgData, null);
    }

    public String getPattern() {
        return this.pattern;
    }

    public synchronized void setPattern(String pattern) {
        int len = pattern.length();
        int i = 0;
        int cnt = 0;
        int initCnt = (len / 3 + 1) * 2;
        int[] type = new int[initCnt];
        int[] width = new int[initCnt];
        int[] align = new int[initCnt];
        String[] text = new String[initCnt];
        StringBuffer buf = new StringBuffer(len);
        this.pattern = pattern;
        while (i < len) {
            if (pattern.charAt(i) == '%') {
                int begin = i;
                int widthBegin = i++;
                boolean processed = false;
                boolean widthFound = false;
                boolean widthProcessed = true;
                boolean alignmentFound = false;
                boolean alignmentMarkFound = false;
                align[cnt] = 0;
                while (!processed && i < len) {
                    if (!Character.isDigit(pattern.charAt(i))) {
                        if (!widthProcessed) {
                            width[cnt] = Integer.parseInt(pattern.substring(widthBegin, i));
                            widthProcessed = true;
                        }
                        if (pattern.charAt(i) == '-') {
                            if (!widthFound) {
                                if (alignmentMarkFound) break;
                                align[cnt] = 2;
                            } else {
                                if (alignmentMarkFound) break;
                                align[cnt] = alignmentFound ? 3 : 1;
                            }
                            alignmentMarkFound = true;
                            alignmentFound = true;
                        } else if (pattern.charAt(i) == 'i' || pattern.charAt(i) == 'p' || pattern.charAt(i) == 'd' || pattern.charAt(i) == 'c' || pattern.charAt(i) == 'a' || pattern.charAt(i) == 'l' || pattern.charAt(i) == 'u' || pattern.charAt(i) == 'S' || pattern.charAt(i) == 'T' || pattern.charAt(i) == 't' || pattern.charAt(i) == 'g' || pattern.charAt(i) == 's' || pattern.charAt(i) == 'm') {
                            if (alignmentFound && !widthFound) break;
                            switch (pattern.charAt(i)) {
                                case 'i': {
                                    type[cnt] = 0;
                                    break;
                                }
                                case 'p': {
                                    type[cnt] = 1;
                                    break;
                                }
                                case 'd': {
                                    type[cnt] = 2;
                                    break;
                                }
                                case 'c': {
                                    type[cnt] = 3;
                                    break;
                                }
                                case 'a': {
                                    type[cnt] = 4;
                                    break;
                                }
                                case 'l': {
                                    type[cnt] = 5;
                                    break;
                                }
                                case 'u': {
                                    type[cnt] = 6;
                                    break;
                                }
                                case 'S': {
                                    type[cnt] = 7;
                                    break;
                                }
                                case 'T': {
                                    type[cnt] = 8;
                                    break;
                                }
                                case 'o': {
                                    type[cnt] = 9;
                                    break;
                                }
                                case 'e': {
                                    type[cnt] = 10;
                                    break;
                                }
                                case 'r': {
                                    type[cnt] = 11;
                                    break;
                                }
                                case 't': {
                                    type[cnt] = 12;
                                    break;
                                }
                                case 'g': {
                                    type[cnt] = 13;
                                    if (!widthFound) {
                                        width[cnt] = 1;
                                    }
                                    align[cnt] = 0;
                                    break;
                                }
                                case 's': {
                                    type[cnt] = 14;
                                    break;
                                }
                                case 'm': {
                                    type[cnt] = 15;
                                }
                            }
                            processed = true;
                        } else {
                            if (alignmentFound || widthFound || pattern.charAt(i) != '%') break;
                            type[cnt] = 16;
                            buf.append('%');
                            processed = true;
                        }
                    } else if (!widthFound) {
                        widthFound = true;
                        if (!alignmentFound) {
                            align[cnt] = 1;
                        }
                        widthProcessed = false;
                        widthBegin = i;
                        alignmentMarkFound = false;
                    }
                    if (++i >= len) break;
                }
                if (processed) {
                    if (type[cnt] == 16) continue;
                    if (buf.length() > 0) {
                        type[cnt + 1] = type[cnt];
                        width[cnt + 1] = width[cnt];
                        align[cnt + 1] = align[cnt];
                        type[cnt] = 16;
                        text[cnt] = buf.toString();
                        align[cnt] = 0;
                        buf.setLength(0);
                        cnt += 2;
                        continue;
                    }
                    ++cnt;
                    continue;
                }
                buf.append(pattern.substring(begin, i));
                continue;
            }
            buf.append(pattern.charAt(i));
            ++i;
        }
        if (buf.length() > 0) {
            type[cnt] = 16;
            text[cnt] = buf.toString();
            align[cnt] = 0;
            ++cnt;
        }
        this.type = new int[cnt];
        i = 0;
        while (i < cnt) {
            this.type[i] = type[i];
            ++i;
        }
        this.text = new String[cnt];
        i = 0;
        while (i < cnt) {
            this.text[i] = text[i];
            ++i;
        }
        this.width = new int[cnt];
        i = 0;
        while (i < cnt) {
            this.width[i] = width[i];
            ++i;
        }
        this.align = new int[cnt];
        i = 0;
        while (i < cnt) {
            this.align[i] = align[i];
            ++i;
        }
    }

    public synchronized String format(LogRecord rec) {
        int i = 0;
        while (i < this.type.length) {
            switch (this.type[i]) {
                case 0: {
                    this.text[i] = rec.getId().toString();
                    break;
                }
                case 1: {
                    this.text[i] = Long.toString(rec.getTime().getTime());
                    break;
                }
                case 2: {
                    this.text[i] = rec.getTimeString();
                    break;
                }
                case 3: {
                    this.text[i] = rec.getSourceName();
                    break;
                }
                case 4: {
                    this.text[i] = rec.getApplication();
                    break;
                }
                case 5: {
                    this.text[i] = rec.getLocationName();
                    break;
                }
                case 6: {
                    this.text[i] = rec.getUser();
                    break;
                }
                case 7: {
                    this.text[i] = rec.getSession();
                    break;
                }
                case 8: {
                    this.text[i] = rec.getTransaction();
                    break;
                }
                case 9: {
                    this.text[i] = rec.getDsrComponent();
                    break;
                }
                case 10: {
                    this.text[i] = rec.getDsrUser();
                    break;
                }
                case 11: {
                    this.text[i] = rec.getDsrTransaction();
                    break;
                }
                case 12: {
                    this.text[i] = rec.getThreadName();
                    break;
                }
                case 13: {
                    if (rec.getGroupLevel() > 0) {
                        int align;
                        int j;
                        StringBuffer buf = new StringBuffer();
                        int indentLevel = rec.getGroupLevel() - Math.abs(rec.getGroupIndent());
                        if (indentLevel > 0) {
                            StringBuffer indentStep = new StringBuffer();
                            j = 0;
                            while (j < this.width[i] - 1) {
                                indentStep.append(' ');
                                ++j;
                            }
                            int j2 = 0;
                            while (j2 < indentLevel) {
                                buf.append(j2 % 3 == 0 ? (char)'|' : ' ');
                                if (this.width[i] > 1) {
                                    buf.append((Object)indentStep);
                                }
                                ++j2;
                            }
                        }
                        if (rec.getGroupIndent() == 0) {
                            align = Math.max(OPEN_GROUP_STRING.length() + 1 - this.width[i], 0);
                            j = 0;
                            while (j < align) {
                                buf.append(' ');
                                ++j;
                            }
                        } else {
                            if (rec.getGroupIndent() > 0) {
                                buf.append(OPEN_GROUP_STRING);
                                buf.append(' ');
                            } else {
                                buf.append(CLOSE_GROUP_STRING);
                                buf.append(' ');
                            }
                            align = Math.max(this.width[i] - (OPEN_GROUP_STRING.length() + 1), 0);
                            j = 0;
                            while (j < align) {
                                buf.append(' ');
                                ++j;
                            }
                        }
                        this.text[i] = buf.toString();
                        break;
                    }
                    this.text[i] = "";
                    break;
                }
                case 14: {
                    this.text[i] = Severity.toString(rec.getSeverity());
                    break;
                }
                case 15: {
                    switch (rec.getMsgType()) {
                        case 0: {
                            this.text[i] = rec.getMsgClear();
                            break;
                        }
                        case 1: {
                            try {
                                this.text[i] = MessageFormat.format(rec.getMsgClear(), rec.getArgsInt());
                                break;
                            }
                            catch (IllegalArgumentException e) {
                                this.text[i] = rec.getMsgClear();
                                Category.SYS_LOGGING.errorT(classLoc, "format(LogRecord)", INVALID_MSG_PATTERN, new Object[]{rec.getMsgClear()});
                            }
                        }
                    }
                    break;
                }
                case 16: {
                    break;
                }
            }
            ++i;
        }
        return this.align(this.text, this.width, this.align);
    }

    /*
     * Unable to fully structure code
     */
    protected String align(String[] text, int[] width, int[] align) {
        if (text.length != width.length || width.length != align.length) {
            throw new IllegalArgumentException();
        }
        res = new StringBuffer(512);
        i = 0;
        while (i < text.length) {
            block15: {
                block16: {
                    if (align[i] == 4) break block15;
                    if (align[i] == 0) break block16;
                    fill = width[i] - text[i].length() >= 0 ? width[i] - text[i].length() : 0;
                    switch (align[i]) {
                        case 1: {
                            if (fill <= 0) ** GOTO lbl21
                            res.append(text[i]);
                            j = 0;
                            while (j < fill) {
                                res.append(' ');
                                ++j;
                            }
                            break block15;
lbl21:
                            // 1 sources

                            if (width[i] > 3) {
                                res.append(text[i].substring(0, width[i] - 3));
                                res.append("...");
                                break;
                            }
                            res.append(text[i].substring(0, width[i]));
                            break;
                        }
                        case 3: {
                            if (fill <= 0) ** GOTO lbl47
                            j = 0;
                            while (j < fill / 2) {
                                res.append(' ');
                                ++j;
                            }
                            res.append(text[i]);
                            j = 0;
                            while (j < fill / 2 + fill % 2) {
                                res.append(' ');
                                ++j;
                            }
                            break block15;
lbl47:
                            // 1 sources

                            if (width[i] > 3) {
                                res.append(text[i].substring(0, width[i] - 3));
                                res.append("...");
                                break;
                            }
                            res.append(text[i].substring(0, width[i]));
                            break;
                        }
                        case 2: {
                            if (fill > 0) {
                                j = 0;
                                while (j < fill) {
                                    res.append(' ');
                                    ++j;
                                }
                                res.append(text[i]);
                                break;
                            }
                            if (width[i] > 3) {
                                res.append("...");
                                res.append(text[i].substring(text[i].length() - (width[i] - 3)));
                                break;
                            }
                            res.append(text[i].substring(text[i].length() - width[i]));
                        }
                    }
                    break block15;
                }
                res.append(text[i]);
            }
            ++i;
        }
        res.append(Formatter.EOL);
        return res.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

