/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogInfoData;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.Version;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class FileLogInfoData
extends LogInfoData {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$FileLogInfoData == null ? (class$com$sap$tc$logging$FileLogInfoData = FileLogInfoData.class$("com.sap.tc.logging.FileLogInfoData")) : class$com$sap$tc$logging$FileLogInfoData);
    private static final String HEAD_LINE_START = "<!--";
    private static final String HEAD_LINE_END = "/-->";
    private static final String HEAD_DEL_LEFT = "[";
    private static final String HEAD_DEL_RIGHT = "]";
    private static HashMap headerElements = new HashMap();
    private static final int MIN = 0;
    public static final int LOG_HEAD = 1;
    private static final String STR_LOG_HEAD = "LOGHEADER";
    public static final int LOG_HEAD_HELP = 2;
    private static final String STR_LOG_HEAD_HELP = "HELP";
    public static final int LOGGING_VERSION = 3;
    private static final String STR_LOGGING_VERSION = "LOGGINGVERSION";
    public static final int LOG_NAME = 4;
    private static final String STR_LOG_NAME = "NAME";
    public static final int LOG_DESCRIPT = 5;
    private static final String STR_LOG_DESCRIPT = "DESCRIPTION";
    public static final int LOG_F_NAME_PATTERN = 6;
    private static final String STR_LOG_F_NAME_PATTERN = "PATTERN";
    public static final int LOG_OWNER = 7;
    private static final String STR_LOG_OWNER = "OWNER";
    public static final int LOG_FORMATTER = 8;
    private static final String STR_LOG_FORMATTER = "FORMATTER";
    public static final int LOG_ENCODING = 9;
    private static final String STR_LOG_ENCODING = "ENCODING";
    public static final int LOG_FILESET = 10;
    private static final String STR_LOG_FILESET = "FILESET";
    public static final int LOG_PREV_FILE = 11;
    private static final String STR_LOG_PREV_FILE = "PREVIOUSFILE";
    public static final int LOG_NEXT_FILE = 12;
    private static final String STR_LOG_NEXT_FILE = "NEXTFILE";
    private static final int MAX = 13;
    public static final int MAX_NUMBER_OF_HEADER_LINES = 12;
    private static final int SETTING_LEVEL_DEFAULT = 0;
    private static final int SETTING_LEVEL_CUSTOM = 1;
    private String logPattern;
    private String logFileName;
    private String logEncoding;
    private String logOwners;
    private String logFileSet;
    private int logFileSetIndex;
    private int logFileSetSize;
    private int logFileSetLimit;
    private int logFileHeaderSize;
    private int logFileFooterSize;
    private String logFileNext;
    private String logFilePrev;
    private String logFormatterPattern;
    static /* synthetic */ Class class$com$sap$tc$logging$FileLogInfoData;

    public FileLogInfoData(FileLog fileLog) {
        String fileName = fileLog.expandPattern(true);
        this.init(fileName);
    }

    public FileLogInfoData(String fileName) {
        this.init(fileName);
    }

    public static String buildHeader(FileLog fileLog) {
        return FileLogInfoData.format(fileLog);
    }

    public String getPattern() {
        if (this.logPattern != null) {
            return this.logPattern;
        }
        return "";
    }

    public String getEncoding() {
        if (this.logEncoding != null) {
            return this.logEncoding;
        }
        return "";
    }

    public String getOwners() {
        if (this.logOwners != null) {
            return this.logOwners;
        }
        return "";
    }

    public String getFileSet() {
        if (this.logFileSetSize > 0) {
            this.logFileSet = "" + this.logFileSetIndex + ", " + this.logFileSetSize + ", " + this.logFileSetLimit;
        }
        if (this.logFileSet != null) {
            return this.logFileSet;
        }
        return "";
    }

    public int getFileSetIndex() {
        return this.logFileSetIndex;
    }

    public int getFileSetSize() {
        return this.logFileSetSize;
    }

    public int getFileSetLimit() {
        return this.logFileSetLimit;
    }

    public int getFileHeaderSize() {
        return this.logFileHeaderSize;
    }

    public String getFileName() {
        if (this.logFileName != null) {
            return this.logFileName;
        }
        return "";
    }

    public String getFormatterPattern() {
        if (this.logFormatterPattern != null) {
            return this.logFormatterPattern;
        }
        return "";
    }

    public String getFileNext() {
        return this.logFileNext;
    }

    public String getFilePrev() {
        return this.logFilePrev;
    }

    protected void setPattern(String value) {
        this.logPattern = value;
        this.headerIsChanged();
    }

    protected void setFileName(String value) {
        this.logFileName = value;
        this.headerIsChanged();
    }

    protected void setEncoding(String value) {
        this.logEncoding = value;
        this.headerIsChanged();
    }

    protected void setOwners(List value) {
        this.headerIsChanged();
    }

    protected void setFileSetIndex(int value) {
        this.logFileSetIndex = value;
        this.headerIsChanged();
    }

    protected void setFileSet(int size, int limit) {
        this.logFileSetSize = size;
        this.logFileSetLimit = limit;
        this.headerIsChanged();
    }

    protected void setFileNext(String value) {
        this.logFileNext = value;
    }

    protected void setFilePrev(String value) {
        this.logFilePrev = value;
    }

    private void init(String fileName) {
        this.setFileName(fileName);
        this.loadFileLogHeader(fileName);
        this.resetIsChanged();
    }

    private String buildHeaderInt() {
        if (this.isChanged()) {
            this.setHeader(this.format());
            this.resetIsChanged();
        }
        return this.getHeader();
    }

    private static String formatFormatter(Formatter formatter) {
        String formatterName = formatter.getClass().getName();
        if (formatter instanceof TraceFormatter) {
            formatterName = formatterName + "(" + ((TraceFormatter)formatter).getPattern() + ")";
        }
        return formatterName;
    }

    private void parseFormatter(String value) {
        String strFormatter = null;
        this.logFormatterPattern = null;
        int startPos = value.indexOf("(");
        if (startPos > 0) {
            strFormatter = value.substring(0, startPos);
            this.logFormatterPattern = value.substring(startPos + 1, value.length() - 1);
        } else {
            strFormatter = value;
        }
        this.setFormatter(FileLogInfoData.createFormatter(strFormatter));
        if (this.logFormatterPattern != null && this.logFormatterPattern.length() > 0) {
            ((TraceFormatter)this.getFormatter()).setPattern(this.logFormatterPattern);
        }
    }

    private void setFileSet(String value) {
        String[] strFromPat = FileLogInfoData.getRotatingSetValues(value);
        if (strFromPat.length == 3) {
            this.setFileSet(new Integer(strFromPat[1].trim()), new Integer(strFromPat[2].trim()));
            this.setFileSetIndex(new Integer(strFromPat[0].trim()));
        }
        this.headerIsChanged();
    }

    private void loadFileLogHeader(String fileName) {
        String[] headLines = this.getFileHeaderLines(fileName);
        if (headLines != null) {
            if (this.parse(this.parseHeader(headLines))) {
                this.buildHeaderInt();
            } else {
                this.setHeader(null);
            }
        }
    }

    private String[] getFileHeaderLines(String fileName) {
        return this.getFileHeaderLines(fileName, 12);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private String[] getFileHeaderLines(String fileName, int cntHeadLines) {
        int headerLineCount;
        String[] headerLines;
        block14: {
            BufferedReader file;
            block13: {
                String lineValue;
                headerLines = new String[cntHeadLines];
                headerLineCount = 0;
                int lenghtBOL = 0;
                file = null;
                lenghtBOL = this.getEOLLength(fileName);
                file = new BufferedReader(new FileReader(fileName));
                int linesRead = 0;
                int lenLeftLineMark = HEAD_LINE_START.length();
                int lenRightLineMark = HEAD_LINE_START.length();
                while ((lineValue = file.readLine()) != null && headerLineCount < cntHeadLines && linesRead++ < 12) {
                    void var10_13;
                    if (var10_13.length() < lenLeftLineMark || !var10_13.substring(0, lenLeftLineMark).equals(HEAD_LINE_START)) continue;
                    headerLines[headerLineCount] = var10_13.substring(lenLeftLineMark, var10_13.length() - lenRightLineMark);
                    this.logFileHeaderSize += var10_13.length();
                    ++headerLineCount;
                }
                if (headerLineCount <= 0) break block13;
                this.logFileHeaderSize += headerLineCount * lenghtBOL;
            }
            Object var12_14 = null;
            if (file == null) break block14;
            try {
                file.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            file = null;
            {
                break block14;
                catch (FileNotFoundException ex) {
                    Object var12_15 = null;
                    if (file == null) break block14;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                    break block14;
                }
                catch (Exception ex) {
                    APILogger.logIntByAPI(400, classLoc, "[getFileHeader(String fileName, int cntHeadLines)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"FileHeader parsing"});
                    APILogger.catchingIntByAPI(ex);
                    Object var12_16 = null;
                    if (file == null) break block14;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                }
                throw throwable;
            }
        }
        if (headerLineCount > 0) {
            String[] finalHeaderLines = new String[headerLineCount];
            System.arraycopy(headerLines, 0, finalHeaderLines, 0, headerLineCount);
            return finalHeaderLines;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private int getEOLLength(String fileName) throws Exception {
        int length;
        block11: {
            BufferedReader file = null;
            int pos = 0;
            length = 0;
            file = new BufferedReader(new FileReader(fileName));
            char[] lineByte = new char[8000];
            file.read(lineByte);
            while (pos < 8000) {
                if (lineByte[pos] == '\n') {
                    if (pos > 0 && lineByte[pos - 1] == '\r') {
                        length = 2;
                        break;
                    }
                    length = 1;
                    break;
                }
                ++pos;
            }
            Object var7_7 = null;
            if (file == null) break block11;
            try {
                file.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            file = null;
            {
                break block11;
                catch (Exception ex) {
                    throw new Exception(ex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                }
                throw throwable;
            }
        }
        return length;
    }

    private Map parseHeader(String[] headerLines) {
        String lineKeyName = null;
        String lineValue = null;
        HashMap<String, String> headLines = new HashMap<String, String>();
        int i = 0;
        while (i < headerLines.length) {
            lineKeyName = FileLogInfoData.getKey(headerLines[i]);
            lineValue = FileLogInfoData.getValue(headerLines[i]);
            if (lineKeyName != null && lineValue != null && lineKeyName.length() > 0) {
                headLines.put(lineKeyName, lineValue);
            }
            ++i;
        }
        return headLines;
    }

    private static String getKey(String value) {
        String lineKey = null;
        int pos = 0;
        if (value == null) {
            return "";
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0) {
            lineKey = value.substring(0, pos);
        }
        return lineKey;
    }

    private static String getValue(String value) {
        String lineValue = null;
        int pos = 0;
        if (value == null) {
            return "";
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0 && pos + 1 < value.length()) {
            lineValue = value.substring(pos + 1, value.length() - 1);
        }
        return lineValue;
    }

    private boolean parse(Map headerLines) {
        int conKey = 0;
        String conValue = null;
        Map.Entry entry = null;
        Iterator iter = headerLines.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            conKey = FileLogInfoData.parseKeyByName((String)entry.getKey());
            conValue = (String)entry.getValue();
            switch (conKey) {
                case 3: {
                    this.setVerInUse(conValue);
                    break;
                }
                case 7: {
                    break;
                }
                case 4: {
                    this.setName(conValue);
                    break;
                }
                case 5: {
                    this.setDescription(conValue);
                    break;
                }
                case 6: {
                    this.setPattern(conValue);
                    break;
                }
                case 8: {
                    this.parseFormatter(conValue);
                    break;
                }
                case 9: {
                    this.setEncoding(conValue);
                    break;
                }
                case 10: {
                    this.setFileSet(conValue);
                    break;
                }
                case 11: {
                    this.setFilePrev(conValue);
                    break;
                }
                case 12: {
                    this.setFileNext(conValue);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    APILogger.logIntByAPI(400, classLoc, "[parse()]", MSGCollection.LOGGING_MSG_ID_HEADER_ERROR, MSGCollection.LOGGING_MSG_STR_HEADER_ERROR, new String[]{this.getPattern()});
                    return false;
                }
            }
        }
        return true;
    }

    private static int parseKeyByName(String keyName) {
        if (keyName != null && headerElements.containsKey(keyName.toUpperCase())) {
            return (Integer)headerElements.get(keyName.toUpperCase());
        }
        return -1;
    }

    private static String format(FileLog fileLog) {
        String pattern = "";
        String[] headerFields = new String[14];
        headerFields[0] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "START");
        headerFields[2] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD_HELP, "Manual modification of the header may cause parsing problem!");
        headerFields[3] = FileLogInfoData.formatHeaderLine(STR_LOGGING_VERSION, Version.getFullVersion());
        if (fileLog.getName() != null) {
            headerFields[4] = FileLogInfoData.formatHeaderLine(STR_LOG_NAME, fileLog.getName());
        }
        if (fileLog.getDescription() != null) {
            headerFields[5] = FileLogInfoData.formatHeaderLine(STR_LOG_DESCRIPT, fileLog.getDescription());
        }
        pattern = fileLog.getFileNamePattern();
        headerFields[6] = FileLogInfoData.formatHeaderLine(STR_LOG_F_NAME_PATTERN, pattern);
        headerFields[8] = FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, FileLogInfoData.formatFormatter(fileLog.getFormatter()));
        headerFields[9] = FileLogInfoData.formatHeaderLine(STR_LOG_ENCODING, fileLog.getEncoding());
        if (fileLog.getCnt() > 0) {
            headerFields[10] = FileLogInfoData.formatHeaderLine(STR_LOG_FILESET, "" + fileLog.getIndex() + ", " + fileLog.getCnt() + ", " + fileLog.getLimit());
            headerFields[11] = FileLogInfoData.formatHeaderLine(STR_LOG_PREV_FILE, "" + new FileLog().expandPattern(pattern, fileLog.getIndex() - 1 < 0 ? fileLog.getCnt() - 1 : fileLog.getIndex() - 1, true, true));
            headerFields[12] = FileLogInfoData.formatHeaderLine(STR_LOG_NEXT_FILE, "" + new FileLog().expandPattern(pattern, fileLog.getIndex() + 1 > fileLog.getCnt() - 1 ? 0 : fileLog.getIndex() + 1, true, true));
        }
        headerFields[13] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "END");
        return FileLogInfoData.formatHeader(headerFields);
    }

    private String format() {
        String pattern = "";
        String[] headerFields = new String[14];
        headerFields[0] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "START");
        headerFields[2] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD_HELP, "Manual modification of the header may cause parsing problem!");
        headerFields[3] = FileLogInfoData.formatHeaderLine(STR_LOGGING_VERSION, this.getVerInUse());
        if (this.getName() != null) {
            headerFields[4] = FileLogInfoData.formatHeaderLine(STR_LOG_NAME, this.getName());
        }
        if (this.getDescription() != null) {
            headerFields[5] = FileLogInfoData.formatHeaderLine(STR_LOG_DESCRIPT, this.getDescription());
        }
        pattern = this.getPattern();
        headerFields[6] = FileLogInfoData.formatHeaderLine(STR_LOG_F_NAME_PATTERN, pattern);
        headerFields[8] = this.getFormatterPattern().length() > 0 ? FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, FileLogInfoData.formatFormatter(this.getFormatter())) : FileLogInfoData.formatHeaderLine(STR_LOG_FORMATTER, this.getFormatter().getClass().getName());
        if (this.getEncoding() != null && this.getEncoding().length() > 0) {
            headerFields[9] = FileLogInfoData.formatHeaderLine(STR_LOG_ENCODING, this.getEncoding());
        }
        if (this.getFileSet().length() > 0) {
            headerFields[10] = FileLogInfoData.formatHeaderLine(STR_LOG_FILESET, this.getFileSet());
            headerFields[11] = FileLogInfoData.formatHeaderLine(STR_LOG_PREV_FILE, "" + this.getFilePrev());
            headerFields[12] = FileLogInfoData.formatHeaderLine(STR_LOG_NEXT_FILE, "" + this.getFileNext());
        }
        headerFields[13] = FileLogInfoData.formatHeaderLine(STR_LOG_HEAD, "END");
        return FileLogInfoData.formatHeader(headerFields);
    }

    private static String formatHeaderLine(String headerKey, String headerValue) {
        StringBuffer header = new StringBuffer();
        if (headerKey != null && headerValue != null) {
            header.append(headerKey);
            header.append(HEAD_DEL_LEFT);
            header.append(headerValue);
            header.append(HEAD_DEL_RIGHT);
        }
        return header.toString();
    }

    private static String formatHeader(String[] headerLines) {
        StringBuffer header = new StringBuffer();
        if (headerLines != null && headerLines.length > 0) {
            int i = 0;
            while (i < headerLines.length) {
                if (headerLines[i] != null) {
                    header.append(HEAD_LINE_START);
                    header.append(headerLines[i]);
                    header.append(HEAD_LINE_END + Formatter.EOL);
                }
                ++i;
            }
        }
        return header.toString();
    }

    private static Formatter createFormatter(String fType) {
        if (fType == null) {
            return null;
        }
        try {
            return (Formatter)Class.forName(fType).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] getRotatingSetValues(String value) {
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        StringTokenizer tmpTokens = new StringTokenizer(value, ",", false);
        String[] tmpValue = new String[3];
        if (tmpTokens.countTokens() != 3) {
            return new String[0];
        }
        int i = 0;
        while (i < 3) {
            tmpValue[i] = tmpTokens.nextToken().trim();
            ++i;
        }
        return tmpValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        headerElements.put(STR_LOG_HEAD, new Integer(1));
        headerElements.put(STR_LOG_HEAD_HELP, new Integer(2));
        headerElements.put(STR_LOGGING_VERSION, new Integer(3));
        headerElements.put(STR_LOG_NAME, new Integer(4));
        headerElements.put(STR_LOG_DESCRIPT, new Integer(5));
        headerElements.put(STR_LOG_F_NAME_PATTERN, new Integer(6));
        headerElements.put(STR_LOG_OWNER, new Integer(7));
        headerElements.put(STR_LOG_FORMATTER, new Integer(8));
        headerElements.put(STR_LOG_ENCODING, new Integer(9));
        headerElements.put(STR_LOG_FILESET, new Integer(10));
        headerElements.put(STR_LOG_PREV_FILE, new Integer(11));
        headerElements.put(STR_LOG_NEXT_FILE, new Integer(12));
    }
}

