/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FileLogInfoData;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.GUId;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.StreamLog;
import com.sap.tc.logging.interfaces.IFileLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FileLog
extends StreamLog
implements IFileLog {
    private static String subLoc = "FileLog";
    public static final int DEF_LIMIT = Integer.MAX_VALUE;
    public static final int NO_LIMIT = 0;
    public static final int NO_CNT = 0;
    public static final int MODE_MIN = 0;
    public static final int MODE_SINGLE_FILE = 1;
    public static final int MODE_FILE_SET = 2;
    public static final int MODE_MAX = 3;
    private static final String EOL = System.getProperty("line.separator");
    private static final String NO_PATTERN_EMSG = "No pattern!";
    private static final int NO_PERMISSION_REPEAT = 1000;
    private String logPattern;
    private String logFileNamePattern;
    private String logFilePathPattern;
    private String parent;
    private File parentFile;
    private boolean append = true;
    private int limit = Integer.MAX_VALUE;
    private int cnt;
    private int number;
    private int mode = 1;
    private int fileNotFoundCnt = 0;
    private int noPermissionCnt = 0;
    private static final byte FIND_FILE_FLAG = 1;
    private byte flags = 0;

    public FileLog(String pattern) {
        this(pattern, new ListFormatter(), true);
    }

    public FileLog(String pattern, boolean append) {
        this(pattern, new ListFormatter(), append);
    }

    public FileLog(String pattern, Formatter formatter) {
        this(pattern, formatter, true);
    }

    public FileLog(String pattern, Formatter formatter, boolean append) {
        super(formatter);
        this.init(pattern, Integer.MAX_VALUE, 0);
        this.append = append;
    }

    public FileLog(String pattern, String enc) throws UnsupportedEncodingException {
        this(pattern, enc, new ListFormatter(), true);
    }

    public FileLog(String pattern, String enc, boolean append) throws UnsupportedEncodingException {
        this(pattern, enc, new ListFormatter(), append);
    }

    public FileLog(String pattern, String enc, Formatter formatter) throws UnsupportedEncodingException {
        this(pattern, enc, formatter, true);
    }

    public FileLog(String pattern, String enc, Formatter formatter, boolean append) throws UnsupportedEncodingException {
        super(formatter);
        this.setEncoding(enc);
        this.init(pattern, Integer.MAX_VALUE, 0);
        this.append = append;
    }

    public FileLog(String pattern, int limit, int cnt) {
        this(pattern, limit, cnt, new ListFormatter());
    }

    public FileLog(String pattern, int limit, int cnt, Formatter formatter) {
        super(formatter);
        if (cnt <= 0 && limit > 0) {
            throw new IllegalArgumentException(MSGCollection.getMessage(MSGCollection.LOGGING_MSG_STR_ILLEGAL_ARG, new Object[]{"cnt", "" + cnt, "> 0"}));
        }
        if (limit <= 0 && cnt > 0) {
            throw new IllegalArgumentException(MSGCollection.getMessage(MSGCollection.LOGGING_MSG_STR_ILLEGAL_ARG, new Object[]{"limit", "" + limit, "> 0"}));
        }
        this.init(pattern, limit, cnt);
    }

    public FileLog(String pattern, String enc, int limit, int cnt) throws UnsupportedEncodingException {
        this(pattern, enc, limit, cnt, new ListFormatter());
    }

    public FileLog(String pattern, String enc, int limit, int cnt, Formatter formatter) throws UnsupportedEncodingException {
        super(formatter);
        if (cnt <= 0 && limit > 0) {
            throw new IllegalArgumentException(MSGCollection.getMessage(MSGCollection.LOGGING_MSG_STR_ILLEGAL_ARG, new Object[]{"cnt", "" + cnt, "> 0"}));
        }
        if (limit <= 0 && cnt > 0) {
            throw new IllegalArgumentException(MSGCollection.getMessage(MSGCollection.LOGGING_MSG_STR_ILLEGAL_ARG, new Object[]{"limit", "" + limit, "> 0"}));
        }
        this.setEncoding(enc);
        this.init(pattern, limit, cnt);
    }

    protected FileLog() {
    }

    private void init(String pattern, int limit, int cnt) {
        if (pattern == null) {
            throw new IllegalArgumentException(MSGCollection.getMessage(MSGCollection.LOGGING_MSG_STR_ILLEGAL_ARG, new Object[]{"pattern", "null", "<> null"}));
        }
        this.setPattern(pattern);
        this.setName(pattern);
        this.setIndex(0);
        this.setRotation(limit, cnt);
        try {
            this.setHeader(new FileLogInfoData(this).getHeader());
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, subLoc + "[FileLog(...)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public synchronized int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        int oldValue = -1;
        int newValue = mode;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldValue = this.getMode();
            this.mode = mode > 0 && mode < 3 ? mode : 1;
            newValue = this.mode;
        }
        if (oldValue != newValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setMode(int mode)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"working mode", "FileLog", this.getName(), "" + oldValue, "" + newValue});
        }
    }

    public void setFormatter(Formatter formatter) {
        String oldValue;
        String string = oldValue = this.getFormatter() != null ? this.getFormatter().getClass().getName() : null;
        if (this.size() > 0L || this.getIndex() > 0) {
            APILogger.logIntByAPI(400, subLoc + "[setFormatter()]", MSGCollection.LOGGING_MSG_ID_FORMATTER_ERROR, MSGCollection.LOGGING_MSG_STR_FORMATTER_ERROR, new String[]{this.getName()});
        } else {
            this.setFormatterInt(formatter);
        }
        if (oldValue != null) {
            APILogger.instrumentIntByAPI(subLoc + "[setFormatter()]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"formatter", "FileLog", this.getName(), oldValue, this.getFormatter().getClass().getName()});
        }
    }

    public List calculateFileNames() {
        LinkedList<String> fileNames = new LinkedList<String>();
        int i = 0;
        while (i < this.cnt) {
            fileNames.add(this.expandPattern(this.getPattern(), i, this.mode == 2, true));
            ++i;
        }
        return fileNames;
    }

    public static Collection calculateFileNames(String filePattern, int fileCount) {
        LinkedList<String> fileNames = new LinkedList<String>();
        int i = 0;
        do {
            fileNames.add(new FileLog().expandPattern(filePattern, i, fileCount > 0, true));
        } while (++i < fileCount);
        return fileNames;
    }

    public long getFileLength() {
        long result = 0L;
        if (this.getCnt() == 0) {
            File file = new File(this.expandPattern(false));
            if (file.exists()) {
                result += file.length();
            }
        } else {
            int i = 0;
            while (i < this.getCnt()) {
                File file = new File(this.expandPattern(i, false));
                if (file.exists()) {
                    result += file.length();
                }
                ++i;
            }
        }
        return result > 0L ? result : -1L;
    }

    public String getPath() {
        return this.expandPattern(false);
    }

    public String getParent() {
        String path = this.expandPattern(false);
        int index = path.lastIndexOf(File.separatorChar);
        if (index > 0) {
            return path.substring(0, index);
        }
        return null;
    }

    public String getPattern() {
        if (this.getFilePathPattern().length() > 0) {
            return this.getFilePathPattern() + File.separator + this.getFileNamePattern();
        }
        return this.getFileNamePattern();
    }

    public String getFilePathPattern() {
        if (this.logFilePathPattern != null) {
            return this.logFilePathPattern;
        }
        return "";
    }

    public String getFileNamePattern() {
        if (this.logFileNamePattern != null) {
            return this.logFileNamePattern;
        }
        return "";
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCnt() {
        return this.cnt;
    }

    public synchronized int getIndex() {
        return this.number;
    }

    public void setRotation(int limit, int cnt) {
        int oldCntValue = -1;
        int newCntValue = cnt;
        int oldLimitValue = -1;
        int newLimitValue = limit;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            oldCntValue = this.getCnt();
            oldLimitValue = this.getLimit();
            if (cnt < 1) {
                cnt = 0;
            }
            if (limit < 1) {
                limit = 0;
            }
            if (cnt == 0 || limit == 0) {
                limit = Integer.MAX_VALUE;
                cnt = 0;
                this.setIndex(0);
            }
            this.cnt = cnt;
            this.limit = limit;
            if (cnt > 0) {
                this.mode = 2;
            }
            this.close();
            newCntValue = this.cnt;
            newLimitValue = this.limit;
        }
        if (oldCntValue != newCntValue || oldLimitValue != newLimitValue) {
            APILogger.instrumentIntByAPI(subLoc + "[setRotation(int limit, int cnt)]", MSGCollection.CONFIGURATION_IS_CHANGED(), new Object[]{"rotation", "FileLog", this.getName(), " cnt:" + oldCntValue + ", limit:" + oldLimitValue, " cnt:" + newCntValue + ", limit:" + newLimitValue});
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean equals(Object object) {
        if (object instanceof FileLog) {
            FileLog fileLog = (FileLog)object;
            return this.getPattern().equals(fileLog.getPattern());
        }
        return false;
    }

    public String findBeginningOfFileSet() {
        String tmpPattern = this.expandPattern(false);
        if (this.getCnt() != 0) {
            int oldestIndex = 0;
            long oldestDate = Long.MAX_VALUE;
            File file = null;
            int i = this.getCnt() - 1;
            while (i >= 0) {
                file = new File(this.expandPattern(i, true));
                if (file.exists()) {
                    if (file.lastModified() >= oldestDate) break;
                    oldestDate = file.lastModified();
                    oldestIndex = i;
                }
                --i;
            }
            tmpPattern = this.expandPattern(oldestIndex, false);
        }
        return tmpPattern;
    }

    public String findEndOfFileSet() {
        String tmpPattern = this.expandPattern(false);
        if (this.getCnt() != 0) {
            int latestIndex = 0;
            long latestDate = 0L;
            File file = null;
            int i = 0;
            while (i < this.getCnt()) {
                file = new File(this.expandPattern(i, true));
                if (file.exists()) {
                    if (file.lastModified() <= latestDate) break;
                    latestDate = file.lastModified();
                    latestIndex = i;
                }
                ++i;
            }
            tmpPattern = this.expandPattern(latestIndex, false);
        }
        return tmpPattern;
    }

    protected synchronized void setFormatterInt(Formatter formatter) {
        super.setFormatter(formatter);
    }

    protected synchronized void resetInt() {
        this.close();
        if (this.cnt != 0) {
            int i = 0;
            while (i < this.cnt) {
                this.number = i;
                String filePattern = this.expandPattern(true);
                File file = new File(filePattern);
                if (file.exists()) {
                    LoggingManager.getLoggingManager().notifyReleaseLogfile(this);
                    LoggingManager.getLoggingManager().notifyOverwriteLogfile(this);
                }
                ++i;
            }
            this.number = 0;
        } else {
            String filePattern = this.expandPattern(true);
            File file = new File(filePattern);
            if (file.exists()) {
                LoggingManager.getLoggingManager().notifyReleaseLogfile(this);
                LoggingManager.getLoggingManager().notifyOverwriteLogfile(this);
            }
        }
        this.setSize(0L);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected synchronized void writeLogHeader() {
        if (!this.isHeaderWritten() && !this.isSuppressing()) {
            try {
                this.writeInt(this.getHeader());
                this.setHeaderWritten(true);
                this.flush();
            }
            catch (Exception ex) {
                APILogger.logIntByAPI(400, subLoc + "[writeLogHeader()]", MSGCollection.LOGGING_MSG_ID_WRITE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_WRITE_EXCEPTION, new String[]{this.getName()});
                APILogger.catchingIntByAPI(ex);
                this.handleException(ex, 3);
            }
        }
    }

    protected synchronized void writeLogFooter() {
        if (this.isHeaderWritten()) {
            if (!this.isSuppressing()) {
                try {
                    long tmpCurrFileLen = this.size();
                    this.setSize(1L);
                    this.writeInt(this.getFooter());
                    this.setSize(tmpCurrFileLen);
                }
                catch (Exception ex) {
                    APILogger.logIntByAPI(400, subLoc + "[writeLogFooter()]", MSGCollection.LOGGING_MSG_ID_WRITE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_WRITE_EXCEPTION, new String[]{this.getName()});
                    APILogger.catchingIntByAPI(ex);
                    this.handleException(ex, 3);
                }
            }
            this.setHeaderWritten(false);
        }
    }

    protected synchronized void writeInt(String s) throws Exception {
        this.checkFile();
        super.writeInt(s);
        this.setSize(this.size() + (long)s.length());
    }

    protected boolean equalsPattern(String pattern, boolean onlyNewFormat) {
        String currPatern = new File(this.expandPattern(this.getPattern(), this.number, this.mode == 2, onlyNewFormat)).getName();
        String checkPattern = new File(this.expandPattern(pattern, this.number, this.mode == 2, onlyNewFormat)).getName();
        return currPatern.equalsIgnoreCase(checkPattern);
    }

    protected String expandPattern(boolean onlyNewFormat) {
        return this.expandPattern(this.getPattern(), this.number, this.mode == 2, onlyNewFormat);
    }

    protected String expandPattern(int fileIndex, boolean onlyNewFormat) {
        return this.expandPattern(this.getPattern(), fileIndex, this.mode == 2, onlyNewFormat);
    }

    protected synchronized void setIndex(int value) {
        this.number = value < 1 || value > this.cnt ? 0 : value;
    }

    protected synchronized void setCnt(int value) {
        this.cnt = value < 1 ? 0 : value;
    }

    protected synchronized void setLimit(int value) {
        this.limit = value < 1 ? 0 : value;
    }

    protected void setPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(NO_PATTERN_EMSG);
        }
        this.buildPattern(pattern);
        this.logPattern = pattern;
    }

    protected void setAppend(boolean append) {
        if (this.cnt == 0) {
            this.append = append;
        }
    }

    private String createFileName(String filePattern, String append, boolean onlyNewFormat) {
        String tmpFileName;
        int pos;
        StringBuffer newPattern = new StringBuffer();
        StringBuffer tmpPattern = new StringBuffer();
        File file = new File(filePattern);
        String fileFolder = file.getParent();
        String fileName = file.getName();
        if (fileFolder != null) {
            newPattern.append(fileFolder);
            newPattern.append(File.separator);
        }
        if ((pos = fileName.indexOf(".")) > 0) {
            tmpPattern.append(fileName.substring(0, pos));
            tmpPattern.append(append);
            tmpPattern.append(fileName.substring(pos));
        } else {
            tmpPattern.append(fileName);
            tmpPattern.append(append);
            tmpPattern.append(".log");
        }
        if (!onlyNewFormat && !new File(tmpFileName = newPattern.toString() + tmpPattern.toString()).exists()) {
            tmpPattern = new StringBuffer();
            if (pos > 0) {
                tmpPattern.append(fileName);
                tmpPattern.append(append);
            } else {
                tmpPattern.append(fileName);
                tmpPattern.append(".log");
                tmpPattern.append(append);
            }
        }
        newPattern.append(tmpPattern.toString());
        return newPattern.toString();
    }

    protected String expandPattern(String filePattern, int fileCount, boolean isRotate, boolean onlyNewFormat) {
        StringBuffer buf = new StringBuffer(filePattern);
        int patternLen = filePattern.length();
        boolean numberInserted = false;
        int i = 0;
        while (i < patternLen) {
            switch (buf.charAt(i)) {
                case '%': {
                    String replacement;
                    switch (buf.charAt(i + 1)) {
                        case 'g': {
                            replacement = Integer.toString(fileCount);
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            numberInserted = true;
                            break;
                        }
                        case 'h': {
                            replacement = System.getProperty("user.home");
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 't': {
                            try {
                                replacement = System.getProperty("java.io.tmpdir");
                            }
                            catch (SecurityException sE) {
                                try {
                                    File file = File.createTempFile("tmp", null);
                                    replacement = file.getPath();
                                    file.delete();
                                    replacement = replacement.substring(0, replacement.lastIndexOf(File.separator));
                                }
                                catch (IOException ioE) {
                                    replacement = "";
                                }
                            }
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 'u': {
                            replacement = new GUId().toString().replace(':', '_');
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case '%': {
                            buf.replace(i, i + 2, "%");
                            --patternLen;
                        }
                    }
                    break;
                }
                case '/': {
                    String replacement = File.separator;
                    buf.replace(i, i + 1, replacement);
                    i += replacement.length() - 1;
                    patternLen += replacement.length() - 1;
                }
            }
            ++i;
        }
        if (!isRotate || numberInserted) {
            return buf.toString();
        }
        return this.createFileName(buf.toString(), "." + fileCount, onlyNewFormat);
    }

    private synchronized void checkFile() throws Exception {
        if ((this.flags & 1) == 1) {
            return;
        }
        this.flags = (byte)(this.flags | 1);
        if (this.size() < (long)this.limit && this.size() > 0L) {
            this.flags = (byte)(this.flags ^ 1);
            return;
        }
        File file = null;
        this.number = this.findNextIndex();
        this.closeInt();
        file = new File(this.expandPattern(true));
        this.setSize(file.length());
        if (this.size() >= (long)this.limit) {
            LoggingManager.getLoggingManager().notifyReleaseLogfile(this);
            LoggingManager.getLoggingManager().notifyOverwriteLogfile(this);
            this.setSize(0L);
        } else if (this.size() == 0L) {
            this.parentFile = file.getParentFile();
            if (this.parentFile != null) {
                this.mkDirsPrivileged();
            }
            this.parentFile = null;
        }
        this.openFilePrivileged(file);
        if (this.size() == 0L) {
            this.setHeader(FileLogInfoData.buildHeader(this));
            this.setHeaderWritten(false);
            this.writeLogHeader();
        }
        this.flags = (byte)(this.flags ^ 1);
    }

    private int findNextIndex() {
        if (this.getCnt() != 0) {
            if (this.getOutputStream() != null) {
                return (this.number + 1) % this.cnt;
            }
            File file = null;
            int i = 0;
            while (i < this.getCnt()) {
                file = new File(this.expandPattern(i, true));
                if (file.length() < (long)this.getLimit()) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private void mkDirsPrivileged() throws Exception {
        if (System.getSecurityManager() != null) {
            class MkdirsAction
            implements PrivilegedExceptionAction {
                private final /* synthetic */ FileLog this$0;

                MkdirsAction(FileLog this$0) {
                    this.this$0 = this$0;
                }

                public Object run() throws Exception {
                    FileLog.access$000(this.this$0);
                    return null;
                }
            }
            AccessController.doPrivileged(new MkdirsAction(this));
        } else {
            this.mkDirs();
        }
    }

    private void mkDirs() throws Exception {
        this.parentFile.mkdirs();
    }

    private void openFilePrivileged(File file) throws Exception {
        if (System.getSecurityManager() != null) {
            class FileOpenAction
            implements PrivilegedExceptionAction {
                File file;
                private final /* synthetic */ FileLog this$0;

                FileOpenAction(FileLog this$0, File file) {
                    this.this$0 = this$0;
                    this.file = file;
                }

                public Object run() throws Exception {
                    FileLog.access$100(this.this$0, this.file);
                    return null;
                }
            }
            AccessController.doPrivileged(new FileOpenAction(this, file));
        } else {
            this.openFileInt(file);
        }
    }

    private void openFileInt(File file) throws Exception {
        block4: {
            try {
                this.setOutputStream(new FileOutputStream(file.getPath(), this.size() > 0L && this.append));
                this.openInt();
                this.setHeaderWritten(this.size() > 0L && this.append);
                this.fileNotFoundCnt = 0;
                this.noPermissionCnt = 0;
                LoggingManager.getLoggingManager().notifyCreateLogfile(file.getAbsolutePath(), this.limit, this.cnt);
            }
            catch (IOException ex) {
                this.fileNotFoundCnt = (this.fileNotFoundCnt + 1) % 1000;
                if (this.fileNotFoundCnt == 1) {
                    throw ex;
                }
            }
            catch (SecurityException ex) {
                this.noPermissionCnt = (this.noPermissionCnt + 1) % 1000;
                if (this.noPermissionCnt != 1) break block4;
                throw ex;
            }
        }
    }

    private void buildPattern(String value) {
        File file = new File(value);
        this.logFileNamePattern = file.getName();
        this.logFilePathPattern = file.getParent();
    }

    public String getFileName() {
        return this.getPath();
    }

    public String getFileCurrentlyBeingWritten() {
        return this.getFileName();
    }

    public File getParentFile() {
        if (this.parentFile != null) {
            return this.parentFile;
        }
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        this.parentFile = new File(p);
        return this.parentFile;
    }

    public String getLogId() {
        return this.getPattern();
    }

    static /* synthetic */ void access$000(FileLog x0) throws Exception {
        x0.mkDirs();
    }

    static /* synthetic */ void access$100(FileLog x0, File x1) throws Exception {
        x0.openFileInt(x1);
    }
}

