/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg.tools.java.client.grmg;

import com.sap.util.monitor.grmg.tools.xml.DocumentNavigator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GrmgDocumentAnalyzer {
    static InputStream resourceStream;
    public static Document m_document;
    static HashMap nodesNames;
    static String errorMessage;

    public static void getInputStream(InputStream is) {
        resourceStream = is;
    }

    public static void setDocument(InputStream is) {
        if (is == null) {
            m_document = null;
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            m_document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (SAXException e) {
            errorMessage = e.getMessage();
        }
    }

    public static NodeList getScenarios() {
        if (m_document == null) {
            return null;
        }
        NodeList nlist = DocumentNavigator.getNodeListFromTag(m_document, "scenario");
        return nlist;
    }

    public static String getScenarioUrl(Node scenarioNode) {
        String tempName = "";
        NodeList templist = scenarioNode.getChildNodes();
        int i = 0;
        while (i < templist.getLength()) {
            if (templist.item(i).getNodeName().equals("scenstarturl")) {
                tempName = templist.item(i).getFirstChild().getNodeValue();
                return tempName;
            }
            ++i;
        }
        return null;
    }

    public static String getScenarioUrlFromName(String scenarioName) {
        Node scenarioNode = GrmgDocumentAnalyzer.getScenario(scenarioName);
        return GrmgDocumentAnalyzer.getScenarioUrl(scenarioNode);
    }

    public static Node getScenario(String scenname) {
        return (Node)GrmgDocumentAnalyzer.getScenarioMap().get(scenname);
    }

    public static Document getScenarioAsDocument(String scenname) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document scenDoc = builder.newDocument();
            scenDoc.appendChild(scenDoc.importNode(GrmgDocumentAnalyzer.getScenario(scenname), true));
            return scenDoc;
        }
        catch (ParserConfigurationException e) {
            GrmgDocumentAnalyzer.debug(e.getMessage());
            return null;
        }
    }

    public static HashMap getScenarioMap(NodeList scenNodeList) {
        String tempName = "";
        HashMap<String, Node> nodeNames = new HashMap<String, Node>();
        if (scenNodeList != null) {
            int j = 0;
            while (j < scenNodeList.getLength()) {
                NodeList templist = scenNodeList.item(j).getChildNodes();
                int i = 0;
                while (i < templist.getLength()) {
                    if (templist.item(i).getNodeName().equals("scenname")) {
                        tempName = templist.item(i).getFirstChild().getNodeValue();
                        break;
                    }
                    ++i;
                }
                nodeNames.put(tempName, scenNodeList.item(j));
                ++j;
            }
        }
        nodesNames = nodeNames;
        return nodeNames;
    }

    public static HashMap getScenarioMap() {
        return GrmgDocumentAnalyzer.getScenarioMap(GrmgDocumentAnalyzer.getScenarios());
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        try {
            FileInputStream fis = new FileInputStream(file);
            GrmgDocumentAnalyzer.setDocument(fis);
            NodeList nlist = GrmgDocumentAnalyzer.getScenarios();
            int j = 0;
            while (j < nlist.getLength()) {
                System.out.println(nlist.item(j));
                ++j;
            }
        }
        catch (Exception e) {
            GrmgDocumentAnalyzer.debug(e.getMessage());
        }
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static void setErrorMessage(String string) {
        errorMessage = string;
    }

    private static void debug(String s) {
        System.out.println(s);
    }

    private static void log(String s) {
    }

    private static void log(String s, Exception e) {
    }

    static {
        errorMessage = "";
    }
}

