/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg.tools.java.client;

class BASE64Encoder {
    static final String encodingChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    BASE64Encoder() {
    }

    public String encode(String source) {
        char[] sourceBytes = this.getPaddedBytes(source);
        int numGroups = (sourceBytes.length + 2) / 3;
        char[] targetBytes = new char[4];
        char[] target = new char[4 * numGroups];
        int group = 0;
        while (group < numGroups) {
            this.convert3To4(sourceBytes, group * 3, targetBytes);
            int i = 0;
            while (i < targetBytes.length) {
                target[i + 4 * group] = encodingChar.charAt(targetBytes[i]);
                ++i;
            }
            ++group;
        }
        int numPadBytes = sourceBytes.length - source.length();
        int i = target.length - numPadBytes;
        while (i < target.length) {
            target[i] = 61;
            ++i;
        }
        return new String(target);
    }

    private char[] getPaddedBytes(String source) {
        char[] converted = source.toCharArray();
        int requiredLength = 3 * ((converted.length + 2) / 3);
        char[] result = new char[requiredLength];
        System.arraycopy(converted, 0, result, 0, converted.length);
        return result;
    }

    private void convert3To4(char[] source, int sourceIndex, char[] target) {
        target[0] = (char)(source[sourceIndex] >>> 2);
        target[1] = (char)((source[sourceIndex] & 3) << 4 | source[sourceIndex + 1] >>> 4);
        target[2] = (char)((source[sourceIndex + 1] & 0xF) << 2 | source[sourceIndex + 2] >>> 6);
        target[3] = (char)(source[sourceIndex + 2] & 0x3F);
    }
}

