/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GRMFactory;
import com.sap.util.monitor.grmg.GrmgComponent;
import com.sap.util.monitor.grmg.GrmgMessage;
import com.sap.util.monitor.grmg.GrmgProperty;
import com.sap.util.monitor.grmg.GrmgRequest;
import com.sap.util.monitor.grmg.GrmgRequestException;
import com.sap.util.monitor.grmg.GrmgScenario;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class ScenarioDevice {
    private GrmgRequest gRequest;
    private GrmgScenario gScenario;
    private Vector gComponents = new Vector();
    private Vector gComponentNames = new Vector();
    private HttpSession httpses;
    private HttpServletRequest httpreq = null;
    private HttpServletResponse httpres = null;
    private Object requestObject = null;
    private Object responseObject = null;

    public abstract void runScenario();

    public GrmgRequest getRequest() {
        return this.gRequest;
    }

    protected HttpServletRequest getHttpRequest() {
        return this.httpreq;
    }

    protected HttpServletResponse getHttpResponse() {
        return this.httpres;
    }

    protected Object getRequestObject() {
        return this.requestObject;
    }

    protected Object getResponseObject() {
        return this.responseObject;
    }

    protected void setRequestObject(Object iniRequest) {
        if (this.requestObject == null) {
            this.requestObject = iniRequest;
        }
    }

    protected void setResponseObject(Object iniResponse) {
        if (this.responseObject == null) {
            this.responseObject = iniResponse;
        }
    }

    public void setRequest(GrmgRequest req) {
        this.gRequest = req;
    }

    public void setRequest(HttpServletRequest hreq) {
        try {
            this.gRequest = GRMFactory.createRequestFromHttpRequest(hreq);
        }
        catch (IOException ie) {
            this.debug(ie.getMessage());
        }
        catch (GrmgRequestException ge) {
            this.debug(ge.getMessage());
        }
        catch (ServletException se) {
            this.debug(se.getMessage());
        }
    }

    public void setRequest(File file) {
        try {
            this.gRequest = GRMFactory.createRequestFromFile(file);
        }
        catch (IOException ie) {
            this.debug(ie.getMessage());
        }
        catch (GrmgRequestException ge) {
            this.debug(ge.getMessage());
        }
        catch (ServletException se) {
            this.debug(se.getMessage());
        }
    }

    public void setRequest(String filename) {
        try {
            this.gRequest = GRMFactory.createRequestFromFile(filename);
        }
        catch (IOException ie) {
            this.debug(ie.getMessage());
        }
        catch (GrmgRequestException ge) {
            this.debug(ge.getMessage());
        }
        catch (ServletException se) {
            this.debug(se.getMessage());
        }
    }

    public void setRequest(InputStream bis) {
        try {
            this.gRequest = GRMFactory.createRequestFromInputStream(bis);
        }
        catch (IOException ie) {
            this.debug(ie.getMessage());
        }
        catch (GrmgRequestException ge) {
            this.debug(ge.getMessage());
        }
        catch (ServletException se) {
            this.debug(se.getMessage());
        }
    }

    public void setRequest(HttpSession hs) {
        this.gRequest = GRMFactory.getRequestFromSession(hs);
    }

    public GrmgScenario getScenario() {
        return this.gScenario;
    }

    public GrmgScenario getScenarioFromRequest(GrmgRequest grmreq) {
        return grmreq.getScenario();
    }

    public void setScenario(GrmgScenario sc) {
        this.gScenario = sc;
    }

    public void setScenarioByRequest(GrmgRequest rq) {
        this.gScenario = rq.getScenario();
    }

    public GrmgComponent getCurrentComponent(GrmgScenario grsc) {
        return grsc.getCurrentComponent();
    }

    public GrmgComponent getComponent(GrmgScenario grsc, int j) {
        return grsc.getComponent(j);
    }

    public GrmgComponent getComponent(GrmgScenario grsc, String name) {
        return grsc.getComponentByName(name);
    }

    public GrmgComponent getComponent(GrmgRequest greq, String name) {
        return greq.getScenario().getComponentByName(name);
    }

    public GrmgComponent getComponent(String name) {
        GrmgComponent gcomp = this.gScenario.getComponentByName(name);
        return gcomp;
    }

    public GrmgComponent[] getFilteredDeviceComponents() {
        ArrayList scenComponents = this.gScenario.getComponents();
        Vector filteredDevComps = new Vector();
        int j = 0;
        while (j < scenComponents.size()) {
            if (this.gComponentNames.contains(((GrmgComponent)scenComponents.get(j)).getName())) {
                filteredDevComps.add(scenComponents.get(j));
            }
            ++j;
        }
        GrmgComponent[] result = new GrmgComponent[filteredDevComps.size()];
        filteredDevComps.toArray(result);
        return result;
    }

    public void addDeviceComponent(String compName) {
        if (!this.gComponentNames.contains(compName)) {
            this.gComponentNames.add(compName);
        }
    }

    public void addDeviceComponents(String[] compNameList) {
        int j = 0;
        while (j < compNameList.length) {
            this.addDeviceComponent(compNameList[j]);
            ++j;
        }
    }

    public String[] getDeviceComponents() {
        String[] result = new String[this.gComponentNames.size()];
        this.gComponentNames.toArray(result);
        return result;
    }

    public void addMessage(GrmgComponent comp, String[] param) {
        String[] parameters = new String[]{"", "", "", "", "", "", "", "", ""};
        if (param != null) {
            int j = 0;
            while (j < Math.min(param.length, 9)) {
                parameters[j] = param[j];
                ++j;
            }
            comp.getCurrentMessage().setMessageParameters(parameters);
        }
    }

    public void addMessage(GrmgComponent comp, String msgalert, String msgseverity, String msgarea, String msgnumber, String msgparam1, String msgparam2, String msgparam3, String msgparam4, String msgtext) {
        comp.getCurrentMessage().setMessageParameters(msgalert, msgseverity, msgarea, msgnumber, msgparam1, msgparam2, msgparam3, msgparam4, msgtext);
    }

    public void addMessageTag(GrmgComponent comp, String msgalert, String msgseverity, String msgarea, String msgnumber, String msgparam1, String msgparam2, String msgparam3, String msgparam4, String msgtext) {
        if (msgtext == null || msgtext.length() <= 0) {
            msgtext = " - - - no message text set - - - ";
        }
        if (comp.getCurrentMessage().getMessageText().equals("initial")) {
            this.addMessage(comp, msgalert, msgseverity, msgarea, msgnumber, msgparam1, msgparam2, msgparam3, msgparam4, msgtext);
        } else {
            GrmgMessage newMessage = new GrmgMessage();
            newMessage.setMessageParameters(msgalert, msgseverity, msgarea, msgnumber, msgparam1, msgparam2, msgparam3, msgparam4, msgtext);
            comp.addMessage(newMessage);
        }
    }

    public void setInitialComponentData(GrmgComponent comp, String compinst) {
        comp.setHost(this.httpreq.getScheme() + "://" + this.httpreq.getServerName() + ":" + this.httpreq.getServerPort() + this.httpreq.getContextPath());
        if (compinst == null) {
            compinst = "001";
        }
        comp.setInst(compinst);
    }

    public void setComponentData(GrmgComponent comp, String[] param, String compinst) {
        if (comp.getHost().equals("") | comp.getInst().equals("") | comp.getHost() == null | comp.getInst() == null) {
            this.setInitialComponentData(comp, compinst);
        }
        this.addMessage(comp, param);
    }

    public void setComponentData(GrmgComponent comp, String[] param) {
        this.setComponentData(comp, param, null);
    }

    public void setComponentData(GrmgComponent comp, String msgalert, String msgseverity, String msgarea, String msgnumber, String msgparam1, String msgparam2, String msgparam3, String msgparam4, String msgtext, String compinst) {
        if (comp.getHost().equals("") | comp.getInst().equals("") | comp.getHost() == null | comp.getInst() == null) {
            this.setInitialComponentData(comp, compinst);
        }
        this.addMessageTag(comp, msgalert, msgseverity, msgarea, msgnumber, msgparam1, msgparam2, msgparam3, msgparam4, msgtext);
    }

    public void setComponentData(GrmgComponent comp, String msgalert, String msgseverity, String msgarea, String msgnumber, String msgparam1, String msgparam2, String msgparam3, String msgparam4, String msgtext) {
        this.setComponentData(comp, msgalert, msgseverity, msgarea, msgnumber, msgparam1, msgparam2, msgparam3, msgparam4, msgtext, null);
    }

    public void setHttpData(HttpServletRequest req, HttpServletResponse res) {
        this.httpreq = req;
        this.httpres = res;
    }

    public void setDeviceData(HttpServletRequest req, HttpServletResponse res) {
        this.setHttpData(req, res);
        this.setRequest(req);
        this.setScenarioByRequest(this.getRequest());
    }

    public void setSessionData(String compName, String propName, String sessAttName) {
        GrmgComponent gcomp = this.gScenario.getComponentByName(compName);
        GrmgProperty prop = gcomp.getPropertyByName(propName);
        if (prop != null) {
            this.httpses.setAttribute(sessAttName, (Object)prop.getValue());
        }
    }

    public void setRequestData(String compName, String propName, String reqAttName) {
        GrmgComponent gcomp = this.gScenario.getComponentByName(compName);
        GrmgProperty prop = gcomp.getPropertyByName(propName);
        if (prop != null) {
            this.httpreq.setAttribute(reqAttName, (Object)prop.getValue());
        }
    }

    public void addProperty(GrmgComponent comp, String name, String value) {
        comp.addProperty().setName(name);
        comp.addProperty().setValue(value);
    }

    private void debug(String s) {
        System.out.println(s);
    }

    private void log(String s) {
    }

    private void log(String s, Exception e) {
    }
}

