/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgCustomizing;
import com.sap.util.monitor.grmg.GrmgCustomizingXmlGenerator;
import com.sap.util.monitor.grmg.GrmgScenario;
import com.sap.util.monitor.grmg.GrmgText;
import com.sap.util.monitor.grmg.GrmgXMLFile;
import com.sap.util.monitor.grmg.ScenarioDataContainer;
import com.sap.util.monitor.grmg.ScenarioDevice;
import com.sap.util.monitor.grmg.ScenarioPanel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ScenarioDataLoader {
    private ScenarioDevice m_device = null;
    ScenarioPanel m_panel = new ScenarioPanel();
    Document m_doc = null;
    private InputStream m_XMLresStream = null;
    private Properties m_XMLProperties = new Properties();
    private Class deviceClass = null;
    private ScenarioDataContainer scData = new ScenarioDataContainer();
    static /* synthetic */ Class class$com$sap$util$monitor$grmg$ScenarioDataLoader;
    static /* synthetic */ Class class$com$sap$util$monitor$grmg$ScenarioDevice;
    static /* synthetic */ Class class$com$sap$util$monitor$grmg$ScenarioPanel;

    ScenarioDataLoader() {
    }

    public ScenarioDataLoader(String deviceName) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException {
        this(deviceName, (class$com$sap$util$monitor$grmg$ScenarioDataLoader == null ? (class$com$sap$util$monitor$grmg$ScenarioDataLoader = ScenarioDataLoader.class$("com.sap.util.monitor.grmg.ScenarioDataLoader")) : class$com$sap$util$monitor$grmg$ScenarioDataLoader).getClassLoader());
    }

    public ScenarioDataLoader(String deviceName, ClassLoader classLoader) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException {
        GrmgXMLFile gxml;
        this.deviceClass = Class.forName(deviceName, true, classLoader);
        this.m_XMLresStream = this.deviceClass.getResourceAsStream(deviceName.substring(deviceName.lastIndexOf(46) + 1) + ".xml");
        if ((class$com$sap$util$monitor$grmg$ScenarioDevice == null ? (class$com$sap$util$monitor$grmg$ScenarioDevice = ScenarioDataLoader.class$("com.sap.util.monitor.grmg.ScenarioDevice")) : class$com$sap$util$monitor$grmg$ScenarioDevice).isAssignableFrom(this.deviceClass)) {
            this.setDefaultProperties();
            this.m_XMLProperties.load(this.deviceClass.getResourceAsStream(deviceName.substring(deviceName.lastIndexOf(46) + 1) + ".properties"));
            gxml = new GrmgXMLFile(this.getDefaultCustomizingFile());
            gxml.addComponents(this.m_XMLresStream);
            this.m_doc = gxml.getDocument();
            this.m_device = (ScenarioDevice)this.deviceClass.newInstance();
            this.m_panel.addScenarioDevice(this.m_device);
        }
        if ((class$com$sap$util$monitor$grmg$ScenarioPanel == null ? (class$com$sap$util$monitor$grmg$ScenarioPanel = ScenarioDataLoader.class$("com.sap.util.monitor.grmg.ScenarioPanel")) : class$com$sap$util$monitor$grmg$ScenarioPanel).isAssignableFrom(this.deviceClass)) {
            this.m_XMLProperties.load(this.deviceClass.getResourceAsStream(deviceName.substring(deviceName.lastIndexOf(46) + 1) + ".properties"));
            gxml = new GrmgXMLFile(this.m_XMLresStream);
            this.m_doc = gxml.getDocument();
            this.m_panel = (ScenarioPanel)this.deviceClass.newInstance();
            StringTokenizer devices = new StringTokenizer(this.m_XMLProperties.getProperty("ScenarioDeviceList"), "!!");
            while (devices.hasMoreTokens()) {
                ScenarioDevice auxDevice = (ScenarioDevice)Class.forName(devices.nextToken()).newInstance();
                this.m_panel.addScenarioDevice(auxDevice);
            }
        }
        this.scData.setScenarioPanel(this.m_panel);
        this.scData.setGrmgXmlDocument(this.m_doc);
        this.scData.setGrmgXMLFile(new GrmgXMLFile(this.m_doc));
        this.scData.setDeviceClass(this.deviceClass);
        this.scData.setGrmgProperties(this.m_XMLProperties);
    }

    public ScenarioDataContainer getDataContainer() {
        return this.scData;
    }

    public ScenarioPanel getScenarioPanel() {
        return this.m_panel;
    }

    public Document getGrmgXmlDocument() {
        return this.m_doc;
    }

    public Properties getGrmgProperties() {
        return this.m_XMLProperties;
    }

    public Class getDeviceClass() {
        return this.deviceClass;
    }

    private Document getDefaultCustomizingFile() throws ParserConfigurationException {
        GrmgCustomizing defaultCust = new GrmgCustomizing();
        GrmgScenario defaultScen = new GrmgScenario();
        GrmgText text = new GrmgText();
        defaultCust.setGrmgRunsFlag(this.m_XMLProperties.getProperty("grmgruns").equalsIgnoreCase("X"));
        defaultScen.setName(this.m_XMLProperties.getProperty("scenname"));
        defaultScen.setVersion(this.m_XMLProperties.getProperty("scenversion"));
        defaultScen.setInstance(this.m_XMLProperties.getProperty("sceninst"));
        defaultScen.setStartUrl(this.m_XMLProperties.getProperty("scenstarturl"));
        text.setLanguage(this.m_XMLProperties.getProperty("scenlangu"));
        text.setDescription(this.m_XMLProperties.getProperty("scendesc"));
        defaultScen.setText(text);
        defaultCust.addScenario(defaultScen);
        return GrmgCustomizingXmlGenerator.buildDocument(defaultCust);
    }

    private void setDefaultProperties() {
        this.m_XMLProperties.setProperty("grmgruns", "X");
        this.m_XMLProperties.setProperty("scenname", "default");
        this.m_XMLProperties.setProperty("scenversion", "001");
        this.m_XMLProperties.setProperty("sceninst", "100");
        this.m_XMLProperties.setProperty("scentype", "URL");
        this.m_XMLProperties.setProperty("scenstarturl", "http://localhost");
        this.m_XMLProperties.setProperty("scenstartmod", "Unknown");
        this.m_XMLProperties.setProperty("scenlangu", "EN");
        this.m_XMLProperties.setProperty("scendesc", "default GRMG Scenario");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

