/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.grmg;

import com.sap.util.monitor.grmg.GrmgRequestException;
import com.sap.util.monitor.grmg.GrmgScenario;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GrmgRequest {
    private Document document;
    private GrmgScenario gs = new GrmgScenario();

    public GrmgScenario getScenario() {
        return this.gs;
    }

    GrmgRequest() {
    }

    public GrmgRequest(InputStream is) throws GrmgRequestException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(is);
            this.prepare();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            throw new GrmgRequestException("Document Builder Factory Configuration Error");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new GrmgRequestException("Parser Configuration Exception");
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new GrmgRequestException("SAX Parser Exception");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GrmgRequestException("Input Stream Error");
        }
    }

    public GrmgRequest(String filename) throws GrmgRequestException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(new File(filename));
            this.prepare();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            throw new GrmgRequestException("Document Builder Factory Configuration Error");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new GrmgRequestException("Parser Configuration Exception");
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new GrmgRequestException("SAX Parser Exception");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GrmgRequestException("Input Stream Error");
        }
    }

    void prepare() {
        this.parseDOM(this.document);
    }

    int parseDOM(Node nl) {
        short type = nl.getNodeType();
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (nl.getNodeName().toLowerCase().trim().equals("property")) {
                    this.gs.getCurrentComponent().addProperty();
                    break;
                }
                if (!nl.getNodeName().toLowerCase().trim().equals("component")) break;
                this.gs.addComponent();
                break;
            }
            case 3: {
                try {
                    if (nl.getNodeValue().trim().equals("")) break;
                    if (nl.getParentNode().getNodeName().toLowerCase().equals("scenversion")) {
                        this.gs.setVersion(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("scenname")) {
                        this.gs.setName(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("sceninst")) {
                        this.gs.setInstance(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("scenclientsid")) {
                        this.gs.setClientSID(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("scenclientsrv")) {
                        this.gs.setClientServer(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("compname")) {
                        this.gs.getCurrentComponent().setName(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("compversion")) {
                        this.gs.getCurrentComponent().setVersion(nl.getNodeValue());
                        break;
                    }
                    if (nl.getParentNode().getNodeName().toLowerCase().trim().equals("propname")) {
                        this.gs.getCurrentComponent().getCurrentProperty().setName(nl.getNodeValue());
                        break;
                    }
                    if (!nl.getParentNode().getNodeName().toLowerCase().trim().equals("propvalue")) break;
                    this.gs.getCurrentComponent().getCurrentProperty().setValue(nl.getNodeValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (nl.getFirstChild() != null) {
            Node child = nl.getFirstChild();
            while (child != null) {
                int j = this.parseDOM(child);
                if (j == -1) {
                    return -1;
                }
                child = child.getNextSibling();
            }
        }
        return 1;
    }

    void printLS() {
    }
}

