/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.time;

import com.sap.bc.krn.perf.PerfTimes;

public class SystemTime {
    private static boolean _initialized = false;
    private static Throwable _initializationFailure;
    private static PerfTimes _perfTimes;

    public static long currentTimeMicros() {
        SystemTime.initialize();
        if (_initializationFailure != null) {
            return System.currentTimeMillis() * 1000L;
        }
        return _perfTimes.elapsed();
    }

    public static long currentTimeStamp() {
        SystemTime.initialize();
        if (_initializationFailure != null) {
            return System.currentTimeMillis() * 1000L;
        }
        return _perfTimes.getStampUs();
    }

    public static long calculateTimeStampDeltaInMicros(long start, long end) {
        SystemTime.initialize();
        if (_initializationFailure != null) {
            return end - start;
        }
        return _perfTimes.getDelta2Us(start, end);
    }

    public static Throwable getInitializationFailure() {
        SystemTime.initialize();
        return _initializationFailure;
    }

    private static void initialize() {
        if (_initialized) {
            return;
        }
        _initialized = true;
        try {
            _perfTimes = new PerfTimes();
        }
        catch (UnsatisfiedLinkError e) {
            _initializationFailure = e;
        }
        catch (Exception e) {
            _initializationFailure = e;
        }
        SystemTime.currentTimeMicros();
        long start = SystemTime.currentTimeStamp();
        long end = SystemTime.currentTimeStamp();
        SystemTime.calculateTimeStampDeltaInMicros(start, end);
    }

    public static void main(String[] args) {
        int number = 1000000;
        if (SystemTime.getInitializationFailure() != null) {
            System.out.println("Initialization failed:");
            System.out.println(SystemTime.getInitializationFailure());
            System.out.println("Fallback activated.");
        }
        long start = SystemTime.currentTimeMicros();
        int i = 0;
        while (i < number) {
            SystemTime.currentTimeStamp();
            ++i;
        }
        long end = SystemTime.currentTimeMicros();
        double overheadTimeStamp = (double)(end - start) / (double)number;
        start = SystemTime.currentTimeMicros();
        int i2 = 0;
        while (i2 < number) {
            SystemTime.currentTimeMicros();
            ++i2;
        }
        end = SystemTime.currentTimeMicros();
        double overheadMicros = (double)(end - start) / (double)number;
        start = SystemTime.currentTimeMicros();
        int i3 = 0;
        while (i3 < number) {
            System.currentTimeMillis();
            ++i3;
        }
        end = SystemTime.currentTimeMicros();
        double overheadMillis = (double)(end - start) / (double)number;
        System.out.println("Overhead currentTimeStamp():  " + overheadTimeStamp);
        System.out.println("Overhead currentTimeMicros(): " + overheadMicros);
        System.out.println("Overhead currentTimeMillis(): " + overheadMillis);
    }
}

