/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.text;

import com.sap.engine.lib.lang.Convert;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class FastDateFormat {
    private byte[] result;
    private SimpleDateFormat sdf;
    private long time;
    private String format;
    private boolean unicodeFlag;
    private long mValue;
    private long sValue;
    private long msValue;
    private int mOff;
    private int sOff;
    private int msOff;
    private byte msState;
    private TimeZone zone = null;
    private Locale locale = null;
    private int formatLength = -1;

    public FastDateFormat(String format, TimeZone zone, Locale locale, boolean unicodeFlag) {
        this.zone = zone;
        this.locale = locale;
        this.format = format;
        this.unicodeFlag = unicodeFlag;
        this.initialize(format);
        this.initTime(unicodeFlag, System.currentTimeMillis());
    }

    public FastDateFormat(String format, boolean unicodeFlag) {
        this(format, null, null, unicodeFlag);
    }

    public void getDate(byte[] inByteArr, int off) {
        long milliseconds = System.currentTimeMillis();
        this.getDate(inByteArr, off, milliseconds);
    }

    public void getDate(byte[] inByteArr, int off, long milliseconds) {
        long diff = milliseconds - this.time;
        if (diff != 0L) {
            if (diff < 0L) {
                this.initTime(this.unicodeFlag, milliseconds);
            } else if (diff < 1000L - this.msValue) {
                if (this.msOff != -1) {
                    this.msValue += diff;
                    this.time = milliseconds;
                    this.modifyMS();
                }
            } else {
                diff = (diff + this.msValue) / 1000L;
                this.msValue = milliseconds % 1000L;
                if (diff < 60L - this.sValue) {
                    this.sValue += diff;
                    this.time = milliseconds;
                    this.modifyS();
                } else {
                    long tmpValue = this.sValue + diff;
                    this.sValue = tmpValue % 60L;
                    diff = tmpValue / 60L;
                    if (diff < 60L - this.mValue) {
                        this.mValue += diff;
                        this.time = milliseconds;
                        this.modifyM();
                    } else {
                        this.initTime(this.unicodeFlag, milliseconds);
                    }
                }
            }
        }
        System.arraycopy(this.result, 0, inByteArr, off, this.result.length);
    }

    public int getLength() {
        return this.result.length;
    }

    private void initialize(String format) {
        int offset = format.indexOf(39);
        this.formatLength = format.length();
        while (offset != -1) {
            --this.formatLength;
            int newOffset = format.indexOf(39, offset + 1);
            if (newOffset == offset + 1) {
                newOffset = format.indexOf(39, newOffset + 1);
            }
            offset = newOffset;
        }
        this.sdf = this.locale != null ? new SimpleDateFormat(format, this.locale) : new SimpleDateFormat(format);
        if (this.zone != null) {
            this.sdf.setTimeZone(this.zone);
        }
        this.findMinute(format);
        this.findSecond(format);
        this.findMillisecond(format);
    }

    private void initTime(boolean unicodeFlag, long milliseconds) {
        Date date = new Date(milliseconds);
        String formatResult = this.sdf.format(date);
        if (formatResult.length() != this.formatLength) {
            // empty if block
        }
        if (unicodeFlag) {
            this.result = new byte[2 * formatResult.length()];
            Convert.writeUStringToByteArr(this.result, 0, formatResult);
        } else {
            this.result = formatResult.getBytes();
        }
        this.msValue = milliseconds % 1000L;
        this.sValue = milliseconds / 1000L % 60L;
        this.mValue = milliseconds / 60000L % 60L;
        this.time = milliseconds;
    }

    private void findMinute(String format) {
        this.mOff = this.findSubstring(format, "mm");
    }

    private void findSecond(String format) {
        this.sOff = this.findSubstring(format, "ss");
    }

    private void findMillisecond(String format) {
        String[] temp = new String[]{"SSS", "SS", "S"};
        this.msState = (byte)-1;
        int i = 0;
        while (i < 3) {
            this.msOff = this.findSubstring(format, temp[i]);
            if (this.msOff != -1) {
                this.msState = (byte)i;
                break;
            }
            i = (byte)(i + 1);
        }
    }

    private int findSubstring(String a, String b) {
        int off = -1;
        while ((off = a.indexOf(b, off + 1)) != -1) {
            int count = 0;
            int i = 0;
            while (i < off) {
                if (a.charAt(i) == '\'') {
                    ++count;
                }
                ++i;
            }
            if (count % 2 != 0) continue;
            break;
        }
        return off;
    }

    private void modifyMS() {
        switch (this.msState) {
            case 0: {
                this.modifyNumber(this.msOff + 2, (byte)(this.msValue % 10L));
            }
            case 1: {
                this.modifyNumber(this.msOff + 1, (byte)(this.msValue / 10L % 10L));
            }
            case 2: {
                this.modifyNumber(this.msOff, (byte)(this.msValue / 100L));
            }
        }
    }

    private void modifyS() {
        if (this.sOff > -1) {
            this.modifyNumber(this.sOff, (byte)(this.sValue / 10L));
            this.modifyNumber(this.sOff + 1, (byte)(this.sValue % 10L));
        }
        this.modifyMS();
    }

    private void modifyM() {
        if (this.mOff > -1) {
            this.modifyNumber(this.mOff, (byte)(this.mValue / 10L));
            this.modifyNumber(this.mOff + 1, (byte)(this.mValue % 10L));
        }
        this.modifyS();
    }

    private void modifyNumber(int off, byte number) {
        if (this.unicodeFlag) {
            this.result[off] = 0;
            this.result[off + 1] = (byte)(48 + number);
        } else {
            this.result[off] = (byte)(48 + number);
        }
    }
}

