/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.http;

import com.sap.engine.lib.security.CookiePrincipal;
import com.sap.engine.lib.security.http.Credentials;
import com.sap.engine.lib.security.http.DigestUtil;
import java.security.MessageDigest;
import java.util.StringTokenizer;

public class DigestCredentials
implements Credentials {
    private String username = null;
    private String realm = null;
    private String nonce = null;
    private String uri = null;
    private String response = null;
    private String algorithm = null;
    private String cnonce = null;
    private String opaque = null;
    private String qop = null;
    private String nc = null;
    private String authorization = null;
    private String method = null;
    private CookiePrincipal cookie = null;
    private static MessageDigest mDigest = DigestUtil.messageDigest();

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setDirectivesValues(String authorization) {
        if (authorization != null && authorization.startsWith("Digest ")) {
            authorization = authorization.substring(7).trim();
            StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
            while (commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                int equalSign = currentToken.indexOf(61);
                if (equalSign < 0) {
                    return;
                }
                String currentTokenName = currentToken.substring(0, equalSign).trim();
                String currentTokenValue = currentToken.substring(equalSign + 1).trim();
                if ("username".equals(currentTokenName)) {
                    this.username = this.removeQuotes(currentTokenValue);
                }
                if ("realm".equals(currentTokenName)) {
                    this.realm = this.removeQuotes(currentTokenValue);
                }
                if ("nonce".equals(currentTokenName)) {
                    this.nonce = this.removeQuotes(currentTokenValue);
                }
                if ("nc".equals(currentTokenName)) {
                    this.nc = currentTokenValue;
                }
                if ("cnonce".equals(currentTokenName)) {
                    this.cnonce = this.removeQuotes(currentTokenValue);
                }
                if ("qop".equals(currentTokenName)) {
                    this.qop = this.removeQuotes(currentTokenValue);
                }
                if ("uri".equals(currentTokenName)) {
                    this.uri = this.removeQuotes(currentTokenValue);
                }
                if (!"response".equals(currentTokenName)) continue;
                this.response = this.removeQuotes(currentTokenValue);
            }
        }
    }

    private String removeQuotes(String str) {
        int len = str.length();
        if (len > 2) {
            return str.substring(1, len - 1);
        }
        return str;
    }

    public void setCNonce(String cnonce) {
        this.cnonce = cnonce;
    }

    public String getCNonce() {
        return this.cnonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonceCount(String nc) {
        this.nc = nc;
    }

    public String getNonceCount() {
        return this.nc;
    }

    public void setDigest(String alg) {
        this.algorithm = alg;
        mDigest = DigestUtil.messageDigest(this.algorithm);
    }

    public String getDigest() {
        return this.algorithm;
    }

    public void setMessageQOP(String qop) {
        this.qop = qop;
    }

    public String getMessageQOP() {
        return this.qop;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setCookiePrincipal(CookiePrincipal cookie) {
        this.cookie = cookie;
    }

    public CookiePrincipal getCookiePrincipal() {
        return this.cookie;
    }
}

