/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.domain;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.lang.SWMRG;
import com.sap.engine.lib.security.PermissionStorageConnector;
import com.sap.engine.lib.security.ProtectedPermissionCollection;
import com.sap.engine.lib.security.domain.InternalSecurityManager;
import com.sap.engine.lib.security.domain.LockPermissionCollectionAction;
import com.sap.engine.lib.security.domain.ProtectedProtectionDomain;
import com.sap.engine.lib.security.domain.StringComparator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyPermission;
import java.util.Vector;

public class ProtectionDomainFactory {
    private static final SWMRG synch_lock = new SWMRG();
    private static final Hashtable canonicalCodesourceToDomain = new Hashtable(201);
    private static final Hashtable codesurceToCanonicalCodesource = new Hashtable(201);
    private static final Hashtable domainNameToCanonicalCodesource = new Hashtable(201);
    private static Policy policy = null;
    private static ProtectionDomainFactory factory = null;
    private static PermissionStorageConnector storageConnector = null;
    private static String rootDirFile = null;
    private static String appsDirFile = null;
    public static final String SDA_SECURITY_SERVICE_NAME = "services/security/security.jar";
    public static final String FS_SECURITY_SERVICE_NAME = "services/security.jar";
    private static final Permission LOAD_LIBRARY = new RuntimePermission("loadLibrary", null);
    private static final Permission QUEUE_PRINT_JOB = new RuntimePermission("queuePrintJob", null);
    private static final Permission SOCKET_CONNECT = new SocketPermission("*", "connect");
    private static final Permission ACCESS_CURRENT_DIR = new FilePermission("*", "read,write");
    private static final Permission READ_ALL_PROPERTIES = new PropertyPermission("*", "read");
    private static final StringComparator stringComparator = new StringComparator();
    static PrintWriter printer = null;
    private static final boolean IN_DEBUG_MODE = false;

    private static final void dump(String message) {
    }

    private static final void dump(Throwable message) {
    }

    public static void setAppsDir(String rootAppsDir) throws IOException {
        appsDirFile = new File(rootAppsDir).getCanonicalPath();
        if (storageConnector != null) {
            storageConnector.setApplicationsDir(appsDirFile);
        }
    }

    public static String getAppsDir() {
        return appsDirFile;
    }

    public static void setPermissionCollectionOperator(PermissionStorageConnector operator) throws Exception {
        storageConnector = operator;
        if (appsDirFile != null) {
            storageConnector.setApplicationsDir(appsDirFile);
        }
    }

    private ProtectionDomainFactory() {
        block2: {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    policy = Policy.getPolicy();
                    return null;
                }
            });
            try {
                rootDirFile = new File(SystemProperties.getProperty((String)"user.dir") + File.separator + "bin").getCanonicalPath();
            }
            catch (IOException e) {
                if (storageConnector == null) break block2;
                storageConnector.logNotice("[protection domain factory] unable to get root directory:\n" + ProtectionDomainFactory.getStackTrace(e));
            }
        }
    }

    public static synchronized ProtectionDomainFactory getFactory() {
        if (factory == null) {
            factory = new ProtectionDomainFactory();
        }
        return factory;
    }

    public static final String encodeDomainName(String domain) {
        String result;
        block8: {
            result = domain;
            try {
                if (appsDirFile != null) {
                    if (domain.startsWith(appsDirFile)) {
                        result = domain.substring(appsDirFile.length() + 1);
                    } else if (domain.startsWith(rootDirFile)) {
                        result = domain.substring(rootDirFile.length() + 1);
                    }
                } else if (domain.startsWith(rootDirFile)) {
                    result = domain.substring(rootDirFile.length() + 1);
                }
            }
            catch (Exception ioe) {
                if (storageConnector == null) break block8;
                storageConnector.logNotice("encodeDomainName[" + domain + "]:\n" + ProtectionDomainFactory.getStackTrace(ioe));
            }
        }
        return result.replace('\\', '/');
    }

    public static ProtectionDomain getProtectionDomain(CodeSource code) {
        synch_lock.startRead();
        try {
            code = ProtectionDomainFactory.getCanonical(code);
            ProtectionDomain protectionDomain = (ProtectionDomain)((WeakReference)canonicalCodesourceToDomain.get(code)).get();
            Object var3_2 = null;
            synch_lock.endRead();
            return protectionDomain;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            synch_lock.endRead();
            throw throwable;
        }
    }

    public ProtectionDomain getProtectionDomain(String name) {
        synch_lock.startRead();
        try {
            ProtectionDomain protectionDomain = this.getProtectionDomainUnsynchronized(name);
            Object var4_3 = null;
            synch_lock.endRead();
            return protectionDomain;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            synch_lock.endRead();
            throw throwable;
        }
    }

    private ProtectionDomain getProtectionDomainUnsynchronized(String name) {
        CodeSource code = (CodeSource)domainNameToCanonicalCodesource.get(name = ProtectionDomainFactory.encodeDomainName(name));
        if (code == null) {
            return null;
        }
        return (ProtectionDomain)((WeakReference)canonicalCodesourceToDomain.get(code)).get();
    }

    public ProtectionDomain registerApplicationProtectionDomain(String name, CodeSource codeSource) throws SecurityException {
        if (name == null) {
            try {
                name = new File(codeSource.getLocation().getFile()).getCanonicalPath();
            }
            catch (IOException e) {
                throw new SecurityException(e.toString());
            }
        }
        return this.registerProtectionDomain(name, codeSource, true);
    }

    public ProtectionDomain registerProtectionDomain(String name, CodeSource codeSource) throws SecurityException {
        if (name == null) {
            try {
                name = new File(codeSource.getLocation().getFile()).getCanonicalPath();
            }
            catch (IOException e) {
                throw new SecurityException(e.toString());
            }
        }
        return this.registerProtectionDomain(name, codeSource, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProtectionDomain registerProtectionDomain(String name, CodeSource codeSource, boolean isApplicationDomain) throws SecurityException {
        Object result;
        ProtectionDomainFactory.dump("registerDomain {");
        synch_lock.startWrite();
        ProtectionDomainFactory.dump("   name  : " + name);
        ProtectionDomainFactory.dump("   cs    : " + codeSource);
        ProtectionDomainFactory.dump("   is_app: " + isApplicationDomain);
        try {
            Object domain = this.getProtectionDomainUnsynchronized(name);
            if (domain != null) {
                ProtectionDomainFactory.dump("registerDomain } OK - cashed");
                ProtectionDomain protectionDomain = domain;
                Object var8_8 = null;
                synch_lock.endWrite();
                return protectionDomain;
            }
            try {
                name = ProtectionDomainFactory.encodeDomainName(name);
                ProtectionDomainFactory.dump("  enc_name: " + name);
                codeSource = ProtectionDomainFactory.getCanonical(codeSource);
                ProtectionDomainFactory.dump("  cn_cs: " + codeSource);
                PermissionCollection permissions = null;
                if (storageConnector != null) {
                    permissions = storageConnector.getPermissionCollection(name, codeSource);
                    if (permissions == null) {
                        permissions = policy.getPermissions(codeSource);
                    }
                } else {
                    permissions = policy.getPermissions(codeSource);
                }
                if (isApplicationDomain) {
                    permissions.add(LOAD_LIBRARY);
                    permissions.add(QUEUE_PRINT_JOB);
                    permissions.add(SOCKET_CONNECT);
                    permissions.add(ACCESS_CURRENT_DIR);
                    permissions.add(READ_ALL_PROPERTIES);
                }
                domain = new ProtectedProtectionDomain(this, name, codeSource, permissions, isApplicationDomain);
                domainNameToCanonicalCodesource.put(name, codeSource);
                ProtectionDomainFactory.dump("  mapped [" + name + "  -> " + codeSource + "]");
                canonicalCodesourceToDomain.put(codeSource, new WeakReference<ProtectionDomain>((ProtectionDomain)domain));
                ProtectionDomainFactory.dump("  mapped [Cs -> WR(domain)]");
                if (storageConnector != null && (result = (Exception)AccessController.doPrivileged(new LockPermissionCollectionAction((ProtectedPermissionCollection)((ProtectionDomain)domain).getPermissions()))) != null) {
                    ProtectionDomainFactory.dump("registerDomain } EXC - lock permissions");
                    throw result;
                }
                ProtectionDomainFactory.dump("registerDomain } OK - new");
                result = domain;
            }
            catch (SecurityException e) {
                ProtectionDomainFactory.dump("registerDomain } EXC - 1");
                ProtectionDomainFactory.dump(e);
                throw e;
            }
            catch (Exception e) {
                ProtectionDomainFactory.dump("registerDomain } EXC - 2");
                ProtectionDomainFactory.dump(e);
                throw new SecurityException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            synch_lock.endWrite();
            throw throwable;
        }
        Object var8_9 = null;
        synch_lock.endWrite();
        return result;
    }

    public synchronized ProtectionDomain[] getProtectionDomains() {
        ProtectionDomainFactory.dump("\r\n\r\n\r\n-------------------------\r\n\r\ngetDomains {");
        synch_lock.startWrite();
        try {
            ProtectionDomain[] result = null;
            ArrayList<ProtectionDomain> res = new ArrayList<ProtectionDomain>(domainNameToCanonicalCodesource.size());
            String domainName = null;
            ProtectionDomain domain = null;
            CodeSource cs = null;
            Enumeration values = domainNameToCanonicalCodesource.keys();
            while (values.hasMoreElements()) {
                domainName = (String)values.nextElement();
                cs = (CodeSource)domainNameToCanonicalCodesource.get(domainName);
                domain = (ProtectionDomain)((WeakReference)canonicalCodesourceToDomain.get(cs)).get();
                if (domain == null) {
                    domainNameToCanonicalCodesource.remove(domainName);
                    canonicalCodesourceToDomain.remove(cs);
                    ProtectionDomainFactory.dump("  ~~~~~~~~~~>> cleared dead reference: [" + domainName + " -> " + cs + "]");
                    continue;
                }
                res.add(domain);
                ProtectionDomainFactory.dump("  - " + domainName);
            }
            result = new ProtectionDomain[res.size()];
            res.toArray(result);
            ProtectionDomainFactory.dump("getDomains } OK: " + result);
            ProtectionDomain[] protectionDomainArray = result;
            Object var9_8 = null;
            synch_lock.endWrite();
            return protectionDomainArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            synch_lock.endWrite();
            throw throwable;
        }
    }

    public String[] getProtectionDomainsNames() {
        ProtectionDomainFactory.dump("getDomainNames {");
        synch_lock.startWrite();
        try {
            String[] result = null;
            ArrayList<String> res = new ArrayList<String>(domainNameToCanonicalCodesource.size());
            Enumeration values = domainNameToCanonicalCodesource.keys();
            String domainName = null;
            ProtectionDomain domain = null;
            CodeSource cs = null;
            while (values.hasMoreElements()) {
                domainName = (String)values.nextElement();
                cs = (CodeSource)domainNameToCanonicalCodesource.get(domainName);
                domain = (ProtectionDomain)((WeakReference)canonicalCodesourceToDomain.get(cs)).get();
                if (domain == null) {
                    domainNameToCanonicalCodesource.remove(domainName);
                    canonicalCodesourceToDomain.remove(cs);
                    ProtectionDomainFactory.dump("  cleared dead reference: [" + domainName + " -> " + cs + "]");
                    continue;
                }
                res.add(domainName);
                ProtectionDomainFactory.dump("   - " + domainName);
            }
            result = new String[res.size()];
            res.toArray(result);
            ProtectionDomainFactory.dump("getDomainNames } OK: " + result);
            Arrays.sort(result, stringComparator);
            String[] stringArray = result;
            Object var9_8 = null;
            synch_lock.endWrite();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            synch_lock.endWrite();
            throw throwable;
        }
    }

    public CodeSource[] getProtectionDomainsCodeSources() {
        ProtectionDomainFactory.dump("getCodeSources {");
        synch_lock.startRead();
        try {
            CodeSource[] result = new CodeSource[canonicalCodesourceToDomain.size()];
            Enumeration values = canonicalCodesourceToDomain.keys();
            int counter = 0;
            while (values.hasMoreElements()) {
                result[counter++] = (CodeSource)values.nextElement();
            }
            ProtectionDomainFactory.dump("getCodeSources } OK: " + result);
            CodeSource[] codeSourceArray = result;
            Object var6_5 = null;
            synch_lock.endRead();
            return codeSourceArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            synch_lock.endRead();
            throw throwable;
        }
    }

    public ProtectionDomain[] getProtectionDomainStack() {
        return ProtectionDomainFactory.getProtectionDomainStack2();
    }

    private static ProtectionDomain[] getNativeProtectionDomainStack2() {
        ProtectionDomainFactory.dump("getNativeProtectionDomainStack2() {");
        Class[] classes = InternalSecurityManager.getInternalSecurityManager().getClassContext();
        ProtectionDomain[] result = new ProtectionDomain[classes.length];
        int i = 0;
        while (i < classes.length) {
            result[i] = classes[i].getProtectionDomain();
            if (result[i] == null) {
                ProtectionDomainFactory.dump(" ??? NULL domain for [" + i + " of " + classes.length + "]: " + classes[i]);
            } else {
                if (result[i].getPermissions() == null) {
                    ProtectionDomainFactory.dump(" ??? NULL permissions for [" + i + " of " + classes.length + "]: " + classes[i]);
                }
                if (result[i].getCodeSource() == null) {
                    ProtectionDomainFactory.dump(" ??? NULL codesource for [" + i + " of " + classes.length + "]: " + classes[i]);
                } else if (result[i].getCodeSource().getLocation() == null) {
                    ProtectionDomainFactory.dump(" ??? NULL location for [" + i + " of " + classes.length + "]: " + classes[i]);
                }
            }
            ++i;
        }
        ProtectionDomainFactory.dump("getNativeProtectionDomainStack2() } OK");
        return result;
    }

    public static ProtectionDomain[] getProtectionDomainStack2() {
        ProtectionDomain[] nativeStack = ProtectionDomainFactory.getNativeProtectionDomainStack2();
        return ProtectionDomainFactory.filterDomainStack(nativeStack);
    }

    private static final ProtectionDomain[] filterDomainStack(ProtectionDomain[] nativeStack) {
        Vector<ProtectedProtectionDomain> temp = new Vector<ProtectedProtectionDomain>(nativeStack.length);
        String path = null;
        CodeSource codeSource = null;
        URL location = null;
        ProtectedProtectionDomain singleDomain = null;
        ProtectionDomainFactory.dump("filterDomainStack {");
        int i = 0;
        while (i < nativeStack.length) {
            if (nativeStack[i] == null) {
                ProtectionDomainFactory.dump("           [" + i + " of " + nativeStack.length + "]  skipped, NULL DOMAIN");
            } else if (!temp.isEmpty() && temp.lastElement().equals(nativeStack[i])) {
                ProtectionDomainFactory.dump("           [" + i + " of " + nativeStack.length + "] " + path + "  skipped, double");
            } else {
                codeSource = nativeStack[i].getCodeSource();
                if (codeSource == null) {
                    ProtectionDomainFactory.dump("           [" + i + " of " + nativeStack.length + "]  skipped, NULL CODESOURCE");
                } else {
                    location = codeSource.getLocation();
                    if (location == null) {
                        ProtectionDomainFactory.dump("           [" + i + " of " + nativeStack.length + "]  skipped, NULL CODESOURCE.LOCATION");
                    } else {
                        path = location.toString();
                        if (nativeStack[i] instanceof ProtectedProtectionDomain || nativeStack[i].getPermissions() instanceof ProtectedPermissionCollection) {
                            singleDomain = (ProtectedProtectionDomain)((Object)ProtectionDomainFactory.getProtectionDomain(codeSource));
                            if (singleDomain == null) {
                                ProtectionDomainFactory.dump("  !!!!! [" + i + " of " + nativeStack.length + "] - " + path + " [domain not registered]");
                            } else {
                                temp.add(singleDomain);
                                ProtectionDomainFactory.dump("  [" + i + " of " + nativeStack.length + "] - " + path + " [INCLUDED]");
                            }
                        } else {
                            ProtectionDomainFactory.dump("  [" + i + " of " + nativeStack.length + "] - " + path + " [skipped ALIEN]");
                        }
                    }
                }
            }
            ++i;
        }
        Object[] result = new ProtectionDomain[temp.size()];
        temp.copyInto(result);
        ProtectionDomainFactory.dump("filterDomainStack } OK");
        return result;
    }

    public void removeStoredProtectionDomain(String domainName) {
        boolean isRemoved = this.removeProtectionDomain(domainName);
        if (storageConnector != null) {
            if (isRemoved) {
                storageConnector.logNotice("removed stored domain[" + domainName + "]");
                storageConnector.unregisterProtectionDomain(ProtectionDomainFactory.encodeDomainName(domainName));
            } else {
                String msg = "domain[" + domainName + "] not removed, because is not registered";
                storageConnector.logError(msg, new Exception(msg));
            }
        }
    }

    public boolean removeProtectionDomain(String nameDomain) {
        boolean bl;
        ProtectionDomainFactory.dump("removeDomain {");
        ProtectionDomainFactory.dump("  name: " + nameDomain);
        synch_lock.startWrite();
        try {
            nameDomain = ProtectionDomainFactory.encodeDomainName(nameDomain);
            ProtectionDomainFactory.dump("  enc_name: " + nameDomain);
            CodeSource code = (CodeSource)domainNameToCanonicalCodesource.remove(nameDomain);
            ProtectionDomainFactory.dump("  code: " + code);
            if (code == null) {
                if (storageConnector != null) {
                    storageConnector.logNotice("domain not removed[" + nameDomain + "] - missing mapping !!!!!!!!!");
                }
                ProtectionDomainFactory.dump("removeDomain } NOT mapped");
                boolean bl2 = false;
                Object var5_5 = null;
                synch_lock.endWrite();
                return bl2;
            }
            canonicalCodesourceToDomain.remove(code);
            ProtectionDomainFactory.dump("removeDomain } OK");
            bl = true;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            synch_lock.endWrite();
            throw throwable;
        }
        Object var5_6 = null;
        synch_lock.endWrite();
        return bl;
    }

    private static final synchronized CodeSource getCanonical(CodeSource code) {
        ProtectionDomainFactory.dump("getCanonicalCS {");
        ProtectionDomainFactory.dump("  code: " + code);
        CodeSource result = (CodeSource)codesurceToCanonicalCodesource.get(code);
        if (result != null) {
            ProtectionDomainFactory.dump("getCanonicalCS } OK from cache");
            return result;
        }
        result = ProtectionDomainFactory.normalizeCodesource(code);
        ProtectionDomainFactory.dump(" normal code: " + code);
        codesurceToCanonicalCodesource.put(code, result);
        ProtectionDomainFactory.dump("getCanonicalCS } OK mapped");
        return result;
    }

    private static final CodeSource normalizeCodesource(CodeSource code) {
        try {
            URL url = code.getLocation();
            String file = url.getFile();
            file = new File(file).isAbsolute() ? new File(file).getCanonicalPath() : new File(".", file).getCanonicalPath();
            URL canonical = new URL("file:" + file);
            return new CodeSource(canonical, code.getCertificates());
        }
        catch (Exception e) {
            if (storageConnector != null) {
                storageConnector.logError("[protection domain factory] normalizeCodesource(" + code + "): ", e);
            }
            return code;
        }
    }

    private static final String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }
}

