/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.domain;

import com.sap.engine.lib.security.ProtectedPermissionCollection;
import com.sap.engine.lib.security.domain.PermissionsFactory;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public class DenyPermissionAction
implements PrivilegedExceptionAction {
    private String domain = null;
    private String permission = null;
    private String name = null;
    private String[] actions = null;
    private ClassLoader loader = null;

    public DenyPermissionAction(String domain, String permission, String name, String[] actions) {
        this.domain = domain;
        this.permission = permission;
        this.name = name;
        this.actions = actions;
    }

    public DenyPermissionAction(String domain, String permission, String name, String[] actions, ClassLoader loader) {
        this(domain, permission, name, actions);
        this.loader = loader;
    }

    public Object run() throws Exception {
        Permission permissionInstance = null;
        ProtectedPermissionCollection collection = null;
        ProtectionDomain protectionDomain = ProtectionDomainFactory.getFactory().getProtectionDomain(this.domain);
        if (protectionDomain != null) {
            collection = (ProtectedPermissionCollection)protectionDomain.getPermissions();
            try {
                permissionInstance = PermissionsFactory.createPermission(this.permission, this.name, this.actions, this.loader);
            }
            catch (Throwable t) {
                ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(ostr));
                return new SecurityException(t.toString());
            }
        } else {
            return new SecurityException("Domain with name '" + this.domain + "' not found.");
        }
        collection.remove(permissionInstance);
        return null;
    }
}

