/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.CSI;

import com.sap.engine.lib.security.CSI.CSICallback;
import com.sap.engine.lib.security.CSI.CSICertificateChain;
import com.sap.engine.lib.security.CSI.CSICredential;
import com.sap.engine.lib.security.CSI.CSIDistinguishedName;
import com.sap.engine.lib.security.CSI.CSIPrincipalName;
import com.sap.engine.lib.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class CSILoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private CSICredential credential = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map1) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
    }

    public boolean login() throws LoginException {
        try {
            CSICallback callback = new CSICallback();
            this.callbackHandler.handle(new Callback[]{callback});
            this.credential = callback.getCSICredential();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean commit() throws LoginException {
        if (this.credential instanceof CSICertificateChain) {
            X509Certificate[] chain = ((CSICertificateChain)this.credential).getCertificateChain();
            String caller = chain[0].getSubjectDN().getName();
            this.subject.getPrincipals().add(new Principal(caller));
            this.subject.getPublicCredentials().add(chain);
        } else if (this.credential instanceof CSIPrincipalName) {
            this.subject.getPrincipals().add((java.security.Principal)((Object)this.credential));
        } else if (this.credential instanceof CSIDistinguishedName) {
            try {
                String caller = ((CSIDistinguishedName)this.credential).getCommonName();
                this.subject.getPrincipals().add(new Principal(caller));
                this.subject.getPublicCredentials().add(this.credential);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

