/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public final class SapLoggingPrintStream
extends PrintStream {
    public static final int DEFAULT_MESSAGE_SEVERITY = 200;
    private final boolean autoFlush;
    private final int messageSeverity;
    private StringBuffer messageHolder;
    private Location location;
    private boolean flushing;

    public SapLoggingPrintStream(Location streamLocation) {
        this(streamLocation, 200, false);
    }

    public SapLoggingPrintStream(Location streamLocation, int messageSeverity) {
        this(streamLocation, messageSeverity, false);
    }

    public SapLoggingPrintStream(Location streamLocation, int messageSeverity, boolean autoFlush) {
        super(new ByteArrayOutputStream(0), autoFlush);
        super.close();
        if (streamLocation == null) {
            throw new NullPointerException("Stream Location argument is null!");
        }
        this.messageHolder = new StringBuffer(64);
        this.messageSeverity = Severity.msgCorrect((int)messageSeverity);
        this.location = streamLocation;
        this.autoFlush = autoFlush;
        this.flushing = false;
    }

    public boolean checkError() {
        this.flush();
        return super.checkError();
    }

    public synchronized void flush() {
        if (this.flushing) {
            return;
        }
        try {
            block5: {
                try {
                    if (this.messageHolder.length() == 0) break block5;
                    this.flushing = true;
                    this.location.logT(this.messageSeverity, this.messageHolder.toString());
                    this.messageHolder.setLength(0);
                }
                catch (Exception e) {
                    this.setError();
                    Object var3_2 = null;
                    this.flushing = false;
                }
            }
            Object var3_1 = null;
            this.flushing = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.flushing = false;
            throw throwable;
        }
    }

    public synchronized void close() {
        this.flush();
        this.location = null;
        this.messageHolder = null;
    }

    public void write(int b) {
        this.print((char)b);
    }

    public void write(byte[] b) {
        this.print(new String(b));
    }

    public void write(byte[] buf, int off, int len) {
        this.print(new String(buf, off, len));
    }

    public synchronized void print(boolean b) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(b);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(char c) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(c);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(int i) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(i);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(long l) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(l);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(float f) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(f);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(double d) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(d);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(char[] s) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(s);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(String s) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(s);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public synchronized void print(Object obj) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(obj);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void println() {
        this.flush();
    }

    public synchronized void println(boolean x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(char x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(int x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(long x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(float x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(double x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(char[] x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(String x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }

    public synchronized void println(Object x) {
        if (this.messageHolder == null) {
            this.setError();
            return;
        }
        this.messageHolder.append(x);
        this.flush();
    }
}

