/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import java.util.StringTokenizer;
import java.util.Vector;

public class StringMatcher {
    private String[] patterns = null;

    public StringMatcher(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ";,");
        Vector<String> pattrns = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            pattrns.add(tokenizer.nextToken());
        }
        this.patterns = pattrns.toArray(new String[0]);
    }

    public boolean matches(String checkString) {
        int i = 0;
        while (i < this.patterns.length) {
            if (this.isMatch(checkString, this.patterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isMatch(String checkString, String pattern) {
        int patternPos = 0;
        int i = 0;
        while (i < checkString.length()) {
            if (patternPos >= pattern.length()) {
                return false;
            }
            char patternChar = pattern.charAt(patternPos);
            char thisChar = checkString.charAt(i);
            switch (patternChar) {
                case '*': {
                    if (patternPos >= pattern.length() - 1) {
                        return true;
                    }
                    int j = i;
                    while (j < checkString.length()) {
                        if (this.isMatch(checkString.substring(j), pattern.substring(patternPos + 1))) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                case '?': {
                    break;
                }
                default: {
                    if (thisChar == patternChar) break;
                    return false;
                }
            }
            ++patternPos;
            ++i;
        }
        int j = patternPos;
        while (j < pattern.length()) {
            if (pattern.charAt(j) != '*') break;
            ++j;
        }
        patternPos = j;
        return patternPos == pattern.length();
    }
}

