/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public class ObjectPool {
    private Object[] pool;
    private int current;
    private int minSize;
    private int maxSize;
    private int decreaseCapacity;
    private int lastCurrent;
    private Class objectClass;

    public ObjectPool(int minSize, int maxSize, int decreaseCapacity, Class objectClass, int decreaseTimeout) throws IllegalArgumentException {
        if (maxSize <= 0 || minSize < 0 || decreaseCapacity <= 0 || maxSize < minSize) {
            throw new IllegalArgumentException("Incorect pool properties.");
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.decreaseCapacity = decreaseCapacity;
        this.objectClass = objectClass;
        this.pool = new Object[maxSize];
        try {
            this.current = 0;
            while (this.current < minSize) {
                this.pool[this.current] = objectClass.newInstance();
                ++this.current;
            }
        }
        catch (IllegalAccessException iaex) {
            iaex.printStackTrace();
        }
        catch (InstantiationException insex) {
            insex.printStackTrace();
        }
        this.lastCurrent = this.current;
    }

    public ObjectPool(int minSize, int maxSize, int decreaseCapacity, Class objectClass) throws IllegalArgumentException {
        this(minSize, maxSize, decreaseCapacity, objectClass, 600000);
    }

    public Object getObject() {
        Object rezult = this.getObjectFromPool();
        if (rezult == null) {
            try {
                rezult = this.objectClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return rezult;
    }

    public synchronized boolean returnInPool(Object cc) {
        if (this.current < this.maxSize) {
            this.pool[this.current++] = cc;
            return true;
        }
        return false;
    }

    public synchronized void setMaxSize(int newMaxSize) {
        if (this.maxSize <= 0 || this.maxSize < this.minSize) {
            throw new IllegalArgumentException("Incorect max size properties : " + newMaxSize);
        }
        if (this.pool.length <= this.maxSize) {
            this.maxSize = newMaxSize;
        } else {
            Object[] newPool = new Object[newMaxSize];
            System.arraycopy(this.pool, 0, newPool, 0, newPool.length);
            this.pool = newPool;
            newPool = null;
            if (this.current > newMaxSize) {
                this.current = newMaxSize;
            }
        }
    }

    private synchronized Object getObjectFromPool() {
        if (this.current <= 0) {
            return null;
        }
        Object cc = this.pool[--this.current];
        this.pool[this.current] = null;
        return cc;
    }

    public synchronized void timeout() {
        if (this.lastCurrent <= this.current) {
            int decreaseNumber = this.minSize > this.current - this.decreaseCapacity ? this.current - this.minSize : this.decreaseCapacity;
            while (decreaseNumber-- > 0) {
                this.pool[this.current--] = null;
            }
        }
        this.lastCurrent = this.current;
    }

    public int getActiveCount() {
        return this.current;
    }
}

