/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.Monitor;
import com.sap.engine.lib.lang.MonitorPool;
import java.util.Hashtable;

public final class ObjectLockManager {
    private Hashtable lockingTable = new Hashtable();
    private MonitorPool monitorPool = new MonitorPool();

    private synchronized Monitor getMonitor(Object id) {
        Monitor monitor = null;
        monitor = (Monitor)this.lockingTable.get(id);
        if (monitor != null) {
            ++monitor.used;
        } else {
            monitor = this.monitorPool.getMonitor();
            this.lockingTable.put(id, monitor);
        }
        return monitor;
    }

    private synchronized void releaseMonitor(Object id, Monitor monitor) {
        if (monitor.used == 0) {
            this.lockingTable.remove(id);
            this.monitorPool.releaseMonitor(monitor);
        } else {
            --monitor.used;
        }
    }

    public void readLock(Object id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToAccess();
    }

    public void writeLock(Object id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToChange();
    }

    public void releaseReadLock(Object id) {
        Monitor monitor = (Monitor)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endAccess();
        this.releaseMonitor(id, monitor);
    }

    public void releaseWriteLock(Object id) {
        Monitor monitor = (Monitor)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endChange();
        this.releaseMonitor(id, monitor);
    }
}

