/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.Monitor;

public final class MonitorPool {
    private int initialSize = 20;
    private int resizeStep = 20;
    private int pos = 0;
    private Monitor[] arrayOfMonitors;

    public MonitorPool(int initialSize, int resizeStep) {
        if (resizeStep < 1 || initialSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initialSize;
        this.resizeStep = resizeStep;
        this.arrayOfMonitors = new Monitor[initialSize];
        int i = 0;
        while (i < initialSize) {
            this.arrayOfMonitors[i] = new Monitor();
            ++i;
        }
        this.pos = initialSize - 1;
    }

    public MonitorPool() {
        this(20, 20);
    }

    public synchronized Monitor getMonitor() {
        if (this.pos < 0) {
            this.incrementArray();
        }
        return this.arrayOfMonitors[this.pos--];
    }

    public synchronized void releaseMonitor(Monitor mon) {
        if (this.pos < this.arrayOfMonitors.length - 1) {
            ++this.pos;
            this.arrayOfMonitors[this.pos] = mon;
        }
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void resize() {
        int usedElements = this.arrayOfMonitors.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfMonitors = new Monitor[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfMonitors.length != this.initialSize) {
            Monitor[] tempArr = new Monitor[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfMonitors, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfMonitors, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new Monitor();
                    ++i;
                }
            }
            this.arrayOfMonitors = tempArr;
            this.pos = newPos;
        }
    }

    private void incrementArray() {
        Monitor[] tempArr = new Monitor[this.arrayOfMonitors.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new Monitor();
            ++i;
        }
        this.arrayOfMonitors = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

