/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.HashLongMonitor;
import com.sap.engine.lib.lang.Monitor;
import com.sap.engine.lib.lang.MonitorPool;
import com.sap.engine.lib.util.LongHashHolder;
import com.sap.engine.lib.util.LongHashHolderImpl;

public final class LongLockManager {
    private HashLongMonitor lockingTable = new HashLongMonitor(11, 0.75, 10, 2, 2, (LongHashHolder)new LongHashHolderImpl());
    private MonitorPool monitorPool = new MonitorPool();

    private synchronized Monitor getMonitor(long id) {
        Monitor monitor = null;
        monitor = this.lockingTable.get(id);
        if (monitor != null) {
            ++monitor.used;
        } else {
            monitor = this.monitorPool.getMonitor();
            this.lockingTable.put(id, monitor);
        }
        return monitor;
    }

    private synchronized void releaseMonitor(long id, Monitor monitor) {
        if (monitor.used == 0) {
            this.lockingTable.remove(id);
            this.monitorPool.releaseMonitor(monitor);
        } else {
            --monitor.used;
        }
    }

    public void readLock(long id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToAccess();
    }

    public void writeLock(long id) {
        Monitor monitor = this.getMonitor(id);
        monitor.tryToChange();
    }

    public void releaseReadLock(long id) {
        Monitor monitor = this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endAccess();
        this.releaseMonitor(id, monitor);
    }

    public void releaseWriteLock(long id) {
        Monitor monitor = this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endChange();
        this.releaseMonitor(id, monitor);
    }
}

