/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public class LongAllocator {
    private long[] IDs = null;
    private int activeIDs;
    private int freeIDs;

    public LongAllocator(int initialSize) {
        this.IDs = new long[initialSize];
        this.activeIDs = initialSize;
        this.freeIDs = initialSize;
        int i = 0;
        while (i < initialSize) {
            this.IDs[i] = initialSize - i - 1;
            ++i;
        }
    }

    public synchronized long getID() {
        if (this.freeIDs != 0) {
            return this.IDs[--this.freeIDs];
        }
        this.IDs = new long[++this.activeIDs];
        return this.activeIDs;
    }

    public synchronized void releaseID(long id) {
        this.IDs[this.freeIDs++] = id;
    }
}

