/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.MonitorWithInterrupts;
import com.sap.engine.lib.lang.MonitorWithInterruptsPool;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;

public final class IntLockManagerWithInterrupts {
    private ConcurrentHashMapIntObject lockingTable = new ConcurrentHashMapIntObject();
    private MonitorWithInterruptsPool monitorPool = new MonitorWithInterruptsPool();

    private synchronized MonitorWithInterrupts getMonitor(int id) {
        MonitorWithInterrupts monitor = null;
        monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor != null) {
            ++monitor.used;
        } else {
            monitor = this.monitorPool.getMonitorWithInterrupts();
            this.lockingTable.put(id, (Object)monitor);
        }
        return monitor;
    }

    private synchronized void releaseMonitor(int id, MonitorWithInterrupts monitor) {
        if (monitor.used == 0) {
            this.lockingTable.remove(id);
            this.monitorPool.releaseMonitorWithInterrupts(monitor);
        } else {
            --monitor.used;
        }
    }

    public void readLock(int id) throws InterruptedException {
        MonitorWithInterrupts monitor = this.getMonitor(id);
        try {
            monitor.tryToAccess();
        }
        catch (InterruptedException iExc) {
            this.releaseMonitor(id, monitor);
            throw iExc;
        }
    }

    public void writeLock(int id) throws InterruptedException {
        MonitorWithInterrupts monitor = this.getMonitor(id);
        try {
            monitor.tryToChange();
        }
        catch (InterruptedException iExc) {
            this.releaseMonitor(id, monitor);
            throw iExc;
        }
    }

    public void releaseReadLock(int id) {
        MonitorWithInterrupts monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endAccess();
        this.releaseMonitor(id, monitor);
    }

    public void releaseWriteLock(int id) {
        MonitorWithInterrupts monitor = (MonitorWithInterrupts)this.lockingTable.get(id);
        if (monitor == null) {
            return;
        }
        monitor.endChange();
        this.releaseMonitor(id, monitor);
    }
}

