/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.Monitor;
import com.sap.engine.lib.util.IntHashHolder;

public final class HashIntMonitor {
    static final double LOAD_FACTOR = 0.75;
    static final int EMPTY = -2;
    static final int LAST = -1;
    private int count = 0;
    private int entryCount = 0;
    private int entryStep = 2;
    private int[] entryKeys = null;
    public Monitor[] entryValues = null;
    private int[] entryNext = null;
    private int overflowStep = 2;
    private int[] overflowKeys = null;
    public Monitor[] overflowValues = null;
    private int[] overflowNext = null;
    private int ptNextFree = 0;
    private int limit = 1;
    private double loadFactor = 0.75;
    IntHashHolder hasher = null;

    public HashIntMonitor(int entryCapacity, double lf, int overflowCapacity, int entryGrowStep, int overflowGrowStep, IntHashHolder hasher) {
        if (entryCapacity < 1) {
            throw new IllegalArgumentException("Invalid hashtable capacity: " + entryCapacity + ".");
        }
        if (lf < 0.0) {
            throw new IllegalArgumentException("Invalid load factor: " + lf + ".");
        }
        if (overflowCapacity < 1) {
            throw new IllegalArgumentException("Invalid hashtable capacity: " + overflowCapacity + ".");
        }
        if (lf > 1.0) {
            lf = 1.0;
        }
        this.hasher = hasher;
        this.entryStep = entryGrowStep;
        this.overflowStep = overflowGrowStep;
        this.loadFactor = lf;
        this.limit = (int)((double)entryCapacity * lf);
        this.count = 0;
        this.entryCount = 0;
        this.initArrays(entryCapacity, overflowCapacity);
    }

    public synchronized void put(int key, Monitor value) {
        int theEntry;
        if (this.entryCount >= this.limit) {
            this.rehash();
        }
        if (this.ptNextFree == -2) {
            int[] oldOverflowKeys = this.overflowKeys;
            Monitor[] oldOverflowValues = this.overflowValues;
            int[] oldOverflowNext = this.overflowNext;
            this.overflowKeys = new int[oldOverflowKeys.length * this.overflowStep + 1];
            this.overflowValues = new Monitor[oldOverflowKeys.length * this.overflowStep + 1];
            this.overflowNext = new int[oldOverflowKeys.length * this.overflowStep + 1];
            System.arraycopy(oldOverflowKeys, 0, this.overflowKeys, 0, oldOverflowKeys.length);
            System.arraycopy(oldOverflowValues, 0, this.overflowValues, 0, oldOverflowValues.length);
            System.arraycopy(oldOverflowNext, 0, this.overflowNext, 0, oldOverflowNext.length);
            this.ptNextFree = oldOverflowNext.length;
            int i = oldOverflowKeys.length;
            while (i < this.overflowKeys.length - 1) {
                this.overflowNext[i] = i + 1;
                ++i;
            }
            this.overflowNext[this.overflowKeys.length - 1] = -2;
        }
        if (this.entryNext[theEntry = this.hasher.hash(key) % this.entryKeys.length] == -2) {
            this.entryKeys[theEntry] = key;
            this.entryValues[theEntry] = value;
            this.entryNext[theEntry] = -1;
            ++this.entryCount;
            ++this.count;
        } else if (this.entryKeys[theEntry] == key) {
            this.entryValues[theEntry] = value;
        } else if (this.entryNext[theEntry] == -1) {
            int pos = this.ptNextFree;
            this.ptNextFree = this.overflowNext[pos];
            this.entryNext[theEntry] = pos;
            this.overflowKeys[pos] = key;
            this.overflowValues[pos] = value;
            this.overflowNext[pos] = -1;
            ++this.count;
        } else {
            int pos = this.entryNext[theEntry];
            while (this.overflowNext[pos] != -1 && this.overflowKeys[pos] != key) {
                pos = this.overflowNext[pos];
            }
            if (this.overflowKeys[pos] == key) {
                this.overflowValues[pos] = value;
            } else {
                int temppos = this.ptNextFree;
                this.ptNextFree = this.overflowNext[this.ptNextFree];
                this.overflowNext[pos] = temppos;
                this.overflowKeys[temppos] = key;
                this.overflowValues[temppos] = value;
                this.overflowNext[temppos] = -1;
                ++this.count;
            }
        }
    }

    public synchronized Monitor get(int key) {
        int theEntry = this.hasher.hash(key) % this.entryKeys.length;
        if (this.entryNext[theEntry] == -2) {
            return null;
        }
        if (this.entryNext[theEntry] == -1) {
            if (this.entryKeys[theEntry] != key) {
                return null;
            }
            return this.entryValues[theEntry];
        }
        if (this.entryKeys[theEntry] == key) {
            return this.entryValues[theEntry];
        }
        int pos = this.entryNext[theEntry];
        while (pos != -1 && this.overflowKeys[pos] != key) {
            pos = this.overflowNext[pos];
        }
        if (pos == -1) {
            return null;
        }
        return this.overflowValues[pos];
    }

    public synchronized void remove(int key) {
        int theEntry = this.hasher.hash(key) % this.entryKeys.length;
        if (this.entryNext[theEntry] == -2) {
            return;
        }
        if (this.entryNext[theEntry] == -1) {
            if (this.entryKeys[theEntry] != key) {
                return;
            }
            this.entryNext[theEntry] = -2;
            this.entryValues[theEntry] = null;
            --this.entryCount;
            --this.count;
        } else if (this.entryKeys[theEntry] == key) {
            int pos = this.entryNext[theEntry];
            this.entryKeys[theEntry] = this.overflowKeys[pos];
            this.entryValues[theEntry] = this.overflowValues[pos];
            this.entryNext[theEntry] = this.overflowNext[pos];
            this.overflowNext[pos] = this.ptNextFree;
            this.overflowValues[pos] = null;
            this.ptNextFree = pos;
            --this.count;
        } else {
            int pos = this.entryNext[theEntry];
            int prepos = -2;
            while (pos != -1 && this.overflowKeys[pos] != key) {
                prepos = pos;
                pos = this.overflowNext[pos];
            }
            if (pos == -1) {
                return;
            }
            if (prepos == -2) {
                this.entryNext[theEntry] = this.overflowNext[pos];
            } else {
                this.overflowNext[prepos] = this.overflowNext[pos];
            }
            this.overflowNext[pos] = this.ptNextFree;
            this.overflowValues[pos] = null;
            this.ptNextFree = pos;
            --this.count;
        }
    }

    public synchronized void rehash() {
        int[] oldEntryKeys = this.entryKeys;
        Monitor[] oldEntryValues = this.entryValues;
        int[] oldEntryNext = this.entryNext;
        int[] oldOverflowKeys = this.overflowKeys;
        Monitor[] oldOverflowValues = this.overflowValues;
        int[] oldOverflowNext = this.overflowNext;
        this.initArrays(oldEntryKeys.length * this.entryStep + 1, oldOverflowKeys.length);
        this.limit = (int)((double)this.entryKeys.length * this.loadFactor);
        this.count = 0;
        this.entryCount = 0;
        int i = 0;
        while (i < oldEntryNext.length) {
            if (oldEntryNext[i] != -2) {
                this.put(oldEntryKeys[i], oldEntryValues[i]);
                int pos = oldEntryNext[i];
                while (pos != -1) {
                    this.put(oldOverflowKeys[pos], oldOverflowValues[pos]);
                    pos = oldOverflowNext[pos];
                }
            }
            ++i;
        }
    }

    public synchronized int getCount() {
        return this.count;
    }

    private final void initArrays(int entryCapacity, int overflowCapacity) {
        this.entryKeys = new int[entryCapacity];
        this.entryValues = new Monitor[entryCapacity];
        this.entryNext = new int[entryCapacity];
        int i = 0;
        while (i < this.entryNext.length) {
            this.entryNext[i] = -2;
            ++i;
        }
        this.ptNextFree = 0;
        this.overflowKeys = new int[overflowCapacity];
        this.overflowValues = new Monitor[overflowCapacity];
        this.overflowNext = new int[overflowCapacity];
        int i2 = 0;
        while (i2 < overflowCapacity - 1) {
            this.overflowNext[i2] = i2 + 1;
            ++i2;
        }
        this.overflowNext[overflowCapacity - 1] = -2;
    }
}

