/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DynamicClassLoader
extends ClassLoader {
    private String classPath;
    private ClassLoader parent;

    public DynamicClassLoader(String classPath) {
        this(classPath, null);
    }

    public DynamicClassLoader(String classPath, ClassLoader parent) {
        this.classPath = classPath;
        this.parent = parent;
        if (this.parent == null) {
            this.parent = this.getClass().getClassLoader();
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            byte[] arr = this.readFileFromClassPath(name, false);
            return new ByteArrayInputStream(arr);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> res = null;
        res = this.findLoadedClass(name);
        if (res == null) {
            try {
                res = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                byte[] classData = null;
                try {
                    classData = this.readFileFromClassPath(name, true);
                }
                catch (Exception ioEx) {
                    throw new ClassNotFoundException(name);
                }
                if (classData != null) {
                    res = this.defineClass(name, classData, 0, classData.length);
                }
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(res);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readFileFromClassPath(String name, boolean isClass) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        StringTokenizer token = new StringTokenizer(this.classPath, File.pathSeparator);
        while (token.hasMoreTokens()) {
            File f = new File(token.nextToken());
            if (!f.exists()) continue;
            if (!f.isDirectory()) {
                Object var12_11;
                ZipFile zip;
                block10: {
                    byte[] byArray;
                    zip = null;
                    try {
                        zip = new ZipFile(f);
                        ZipEntry zipEntry = null;
                        zipEntry = isClass ? zip.getEntry(name.replace('.', '/') + ".class") : zip.getEntry(name);
                        if (zipEntry == null) break block10;
                        BufferedInputStream is = new BufferedInputStream(zip.getInputStream(zipEntry));
                        try {
                            int c;
                            while ((c = ((InputStream)is).read()) != -1) {
                                void var9_13;
                                buff.write((int)var9_13);
                            }
                        }
                        catch (EOFException e) {
                            // empty catch block
                        }
                        buff.close();
                        ((InputStream)is).close();
                        byArray = buff.toByteArray();
                        var12_11 = null;
                        if (zip == null) return byArray;
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        if (zip == null) throw throwable;
                        zip.close();
                        throw throwable;
                    }
                    zip.close();
                    return byArray;
                }
                var12_11 = null;
                if (zip == null) continue;
                zip.close();
                {
                    continue;
                }
            }
            try {
                int c;
                BufferedInputStream is = null;
                is = isClass ? new BufferedInputStream(new FileInputStream(new File(f, name.replace('.', File.separatorChar) + ".class"))) : new BufferedInputStream(new FileInputStream(new File(name)));
                while ((c = ((InputStream)is).read()) != -1) {
                    void zipEntry;
                    buff.write((int)zipEntry);
                }
                buff.close();
                ((InputStream)is).close();
                return buff.toByteArray();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public void setClasspath(String classpath) {
        this.classPath = classpath;
    }

    public String getClasspath() {
        return this.classPath;
    }

    public void addClasspath(String classpath) {
        if (classpath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        String token = null;
        if (!this.classPath.endsWith(File.pathSeparator)) {
            this.classPath = this.classPath + File.pathSeparator;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (this.classPath.indexOf(token) != -1) continue;
            this.classPath = this.classPath + token + File.pathSeparator;
        }
    }
}

