/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public final class Convert {
    static final short SHORTFLAG = 255;
    static final int INTFLAG = 255;
    static final long LONGFLAG = 255L;
    public static final String codeTable = "8859_1";

    public static final String getEncoding() {
        String encode = "error";
        try {
            OutputStreamWriter output = new OutputStreamWriter(new ByteArrayOutputStream());
            encode = output.getEncoding();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encode;
    }

    public static final byte[] nativeToAscii(String s) {
        byte[] res = null;
        try {
            res = s.getBytes(codeTable);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return res;
    }

    public static final String asciiToNative(byte[] b) {
        String s = null;
        try {
            s = new String(b, codeTable);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return s;
    }

    public static final String asciiToNative(byte[] b, int off, int i) {
        String s = null;
        try {
            s = new String(b, off, i, codeTable);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return s;
    }

    public static final byte charToAscii(char c) {
        String temp = String.valueOf(c);
        byte[] arr = Convert.nativeToAscii(temp);
        return arr[0];
    }

    public static final char asciiToChar(byte b) {
        byte[] arr = new byte[]{b};
        String temp = Convert.asciiToNative(arr);
        return temp.charAt(0);
    }

    public static final void writeIntToByteArr(byte[] b, int off, int i) {
        b[off] = (byte)i;
        b[off + 1] = (byte)(i >> 8);
        b[off + 2] = (byte)(i >> 16);
        b[off + 3] = (byte)(i >> 24);
    }

    public static final void writeLongToByteArr(byte[] b, int off, long i) {
        b[off] = (byte)i;
        b[off + 1] = (byte)(i >> 8);
        b[off + 2] = (byte)(i >> 16);
        b[off + 3] = (byte)(i >> 24);
        b[off + 4] = (byte)(i >> 32);
        b[off + 5] = (byte)(i >> 40);
        b[off + 6] = (byte)(i >> 48);
        b[off + 7] = (byte)(i >> 56);
    }

    public static final void writeFloatToByteArr(byte[] b, int off, float f) {
        int i = Float.floatToIntBits(f);
        Convert.writeIntToByteArr(b, off, i);
    }

    public static final void writeDoubleToByteArr(byte[] b, int off, double d) {
        long l = Double.doubleToLongBits(d);
        Convert.writeLongToByteArr(b, off, l);
    }

    public static final void writeBooleanToByteArr(byte[] b, int off, boolean bool) {
        b[off] = bool ? (byte)0 : 1;
    }

    public static final void writeCharToByteArr(byte[] b, int off, char c) {
        b[off + 1] = (byte)c;
        b[off] = (byte)(c >> 8);
    }

    public static final void writeShortToByteArr(byte[] b, int off, short s) {
        b[off] = (byte)s;
        b[off + 1] = (byte)(s >> 8);
    }

    public static final void writeUStringToByteArr(byte[] b, int off, String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            b[2 * i + 1 + off] = (byte)c;
            b[2 * i + off] = (byte)(c >> 8);
            ++i;
        }
    }

    public static final void writeUStringToByteArr(byte[] b, int off, String s, int pos, int length) {
        int i = pos;
        while (i < pos + length) {
            char c = s.charAt(i);
            b[2 * i + 1 + off] = (byte)c;
            b[2 * i + off] = (byte)(c >> 8);
            ++i;
        }
    }

    public static final void writeAStringToByteArr(byte[] b, int off, String s) {
        System.arraycopy(s.getBytes(), 0, b, off, s.length());
    }

    public static final void writeAStringToByteArr(byte[] b, int off, String s, int pos, int length) {
        String sub = s.substring(pos, pos + length);
        Convert.writeAStringToByteArr(b, off, sub);
    }

    public static final int byteArrToInt(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF) << 16 | b[off + 3] << 24;
    }

    public static final short byteArrToShort(byte[] b, int off) {
        return (short)(b[off] & 0xFF | b[off + 1] << 8);
    }

    public static final float byteArrToFloat(byte[] b, int off) {
        int i = Convert.byteArrToInt(b, off);
        return Float.intBitsToFloat(i);
    }

    public static final double byteArrToDouble(byte[] b, int off) {
        long l = Convert.byteArrToLong(b, off);
        return Double.longBitsToDouble(l);
    }

    public static final long byteArrToLong(byte[] b, int off) {
        int ri = b[off] & 0xFF | (b[off + 1] & 0xFF) << 8 | (b[off + 2] & 0xFF) << 16 | b[off + 3] << 24;
        int li = b[off + 4] & 0xFF | (b[off + 5] & 0xFF) << 8 | (b[off + 6] & 0xFF) << 16 | b[off + 7] << 24;
        return (long)li << 32 | (long)ri & 0xFFFFFFFFL;
    }

    public static final boolean byteArrToBoolean(byte[] b, int off) {
        return b[off] == 0;
    }

    public static final char byteArrToChar(byte[] b, int off) {
        char c = (char)(b[off] << 8 | b[off + 1] & 0xFF);
        return c;
    }

    public static final String byteArrToUString(byte[] b) {
        String s;
        if (b.length == 0) {
            s = new String();
        } else {
            char[] c = new char[b.length / 2];
            int i = 0;
            while (i < b.length / 2) {
                int j = b[2 * i] << 8 | b[2 * i + 1] & 0xFF;
                c[i] = (char)j;
                ++i;
            }
            s = new String(c);
        }
        return s;
    }

    public static final String byteArrToUString(byte[] b, int off, int strLen) {
        String s;
        if (strLen == 0) {
            s = new String();
        } else {
            char[] c = new char[strLen];
            int i = 0;
            while (i < strLen) {
                int j = b[2 * i + off] << 8 | b[2 * i + 1 + off] & 0xFF;
                c[i] = (char)j;
                ++i;
            }
            s = new String(c);
        }
        return s;
    }

    public static final String byteArrToAString(byte[] b) {
        return new String(b);
    }

    public static final String byteArrToAString(byte[] b, int off, int length) {
        if (length == 0) {
            return new String();
        }
        return new String(b, off, length);
    }

    public static String byteArrToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(bytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static String byteArrToHexString(byte[] bytes, int fromIndex, int toIndex) {
        StringBuffer sb = new StringBuffer();
        int i = fromIndex;
        while (i < toIndex) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(bytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static final byte[] stringUToByteArr(String s) {
        byte[] b = new byte[2 * s.length()];
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            b[2 * i + 1] = (byte)c;
            b[2 * i] = (byte)(c >> 8);
            ++i;
        }
        return b;
    }

    public static final byte[] stringAToByteArr(String s) {
        return s.getBytes();
    }

    public static final byte[] intArrToByteArr(int[] i) {
        return Convert.intArrToByteArr(i, 0, i.length);
    }

    public static final byte[] intArrToByteArr(int[] i, int off, int length) {
        byte[] y = new byte[4 * length];
        int j = off;
        while (j < off + length) {
            y[4 * (j - off)] = (byte)i[j];
            y[4 * (j - off) + 1] = (byte)(i[j] >> 8);
            y[4 * (j - off) + 2] = (byte)(i[j] >> 16);
            y[4 * (j - off) + 3] = (byte)(i[j] >> 24);
            ++j;
        }
        return y;
    }

    public static final void intArrToByteArr(byte[] b, int pos, int[] i, int off, int len) {
        int j = off;
        while (j < off + len) {
            b[4 * (j - off) + pos] = (byte)i[j];
            b[4 * (j - off) + 1 + pos] = (byte)(i[j] >> 8);
            b[4 * (j - off) + 2 + pos] = (byte)(i[j] >> 16);
            b[4 * (j - off) + 3 + pos] = (byte)(i[j] >> 24);
            ++j;
        }
    }

    public static final byte[] longArrToByteArr(long[] l) {
        return Convert.longArrToByteArr(l, 0, l.length);
    }

    public static final byte[] longArrToByteArr(long[] l, int off, int length) {
        byte[] b = new byte[8 * length];
        int j = off;
        while (j < off + length) {
            int i = 0;
            while (i < 8) {
                b[8 * (j - off) + i] = (byte)(l[j] >> 8 * i);
                ++i;
            }
            ++j;
        }
        return b;
    }

    public static final void longArrToByteArr(byte[] b, int pos, long[] l, int off, int length) {
        int j = off;
        while (j < off + length) {
            int i = 0;
            while (i < 8) {
                b[8 * (j - off) + i + pos] = (byte)(l[j] >> 8 * i);
                ++i;
            }
            ++j;
        }
    }

    public static final byte[] booleanArrToByteArr(boolean[] b) {
        return Convert.booleanArrToByteArr(b, 0, b.length);
    }

    public static final byte[] booleanArrToByteArr(boolean[] b, int off, int len) {
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            bytes[i] = b[i] ? (byte)0 : 1;
            ++i;
        }
        return bytes;
    }

    public static final void booleanArrToByteArr(byte[] bytes, int pos, boolean[] b, int off, int length) {
        int i = 0;
        while (i < length) {
            bytes[i + pos] = b[i] ? (byte)0 : 1;
            ++i;
        }
    }

    public static final byte[] charArrToByteArr(char[] c) {
        return Convert.charArrToByteArr(c, 0, c.length);
    }

    public static final byte[] charArrToByteArr(char[] c, int off, int len) {
        byte[] b = new byte[len * 2];
        int i = 0;
        while (i < len) {
            b[2 * i + 1] = (byte)c[off + i];
            b[2 * i] = (byte)(c[off + i] >> 8);
            ++i;
        }
        return b;
    }

    public static final void charArrToByteArr(byte[] b, int pos, char[] c, int off, int len) {
        int i = 0;
        while (i < len) {
            b[2 * i + 1 + pos] = (byte)c[off + i];
            b[2 * i + pos] = (byte)(c[off + i] >> 8);
            ++i;
        }
    }

    public static final byte[] floatArrToByteArr(float[] f) {
        return Convert.floatArrToByteArr(f, 0, f.length);
    }

    public static final byte[] floatArrToByteArr(float[] f, int off, int length) {
        byte[] y = new byte[4 * length];
        int j = off;
        while (j < off + length) {
            int i = Float.floatToIntBits(f[j]);
            y[4 * (j - off)] = (byte)i;
            y[4 * (j - off) + 1] = (byte)(i >> 8);
            y[4 * (j - off) + 2] = (byte)(i >> 16);
            y[4 * (j - off) + 3] = (byte)(i >> 24);
            ++j;
        }
        return y;
    }

    public static final void floatArrToByteArr(byte[] b, int pos, float[] f, int off, int len) {
        int j = off;
        while (j < off + len) {
            int i = Float.floatToIntBits(f[j]);
            b[4 * (j - off) + pos] = (byte)i;
            b[4 * (j - off) + 1 + pos] = (byte)(i >> 8);
            b[4 * (j - off) + 2 + pos] = (byte)(i >> 16);
            b[4 * (j - off) + 3 + pos] = (byte)(i >> 24);
            ++j;
        }
    }

    public static final byte[] doubleArrToByteArr(double[] d) {
        return Convert.doubleArrToByteArr(d, 0, d.length);
    }

    public static final byte[] doubleArrToByteArr(double[] d, int off, int length) {
        byte[] b = new byte[8 * length];
        int j = off;
        while (j < off + length) {
            long l = Double.doubleToLongBits(d[j]);
            int i = 0;
            while (i < 8) {
                b[8 * (j - off) + i] = (byte)(l >> 8 * i);
                ++i;
            }
            ++j;
        }
        return b;
    }

    public static final void doubleArrToByteArr(byte[] b, int pos, double[] d, int off, int length) {
        int j = off;
        while (j < off + length) {
            long l = Double.doubleToLongBits(d[j]);
            int i = 0;
            while (i < 8) {
                b[8 * (j - off) + i + pos] = (byte)(l >> 8 * i);
                ++i;
            }
            ++j;
        }
    }

    public static final byte[] shortArrToByteArr(short[] s) {
        return Convert.shortArrToByteArr(s, 0, s.length);
    }

    public static final byte[] shortArrToByteArr(short[] s, int off, int length) {
        byte[] y = new byte[2 * length];
        int j = off;
        while (j < off + length) {
            y[4 * (j - off)] = (byte)s[j];
            y[4 * (j - off) + 1] = (byte)(s[j] >> 8);
            ++j;
        }
        return y;
    }

    public static final void shortArrToByteArr(byte[] b, int pos, short[] s, int off, int len) {
        int j = off;
        while (j < off + len) {
            b[4 * (j - off) + pos] = (byte)s[j];
            b[4 * (j - off) + 1 + pos] = (byte)(s[j] >> 8);
            ++j;
        }
    }

    public static final byte[] uStringArrToByteArr(String[] s) {
        return Convert.uStringArrToByteArr(s, 0, s.length);
    }

    public static final byte[] uStringArrToByteArr(String[] s, int off, int length) {
        int byteOff = 0;
        int byteCount = 0;
        int i = off;
        while (i < off + length) {
            if (s[i] != null) {
                byteCount += 2 * s[i].length();
            }
            ++i;
        }
        byte[] b = new byte[byteCount + 4 * s.length];
        int i2 = off;
        while (i2 < off + length) {
            if (s[i2] != null) {
                Convert.writeIntToByteArr(b, byteOff, s[i2].length());
                Convert.writeUStringToByteArr(b, byteOff += 4, s[i2]);
                byteOff += 2 * s[i2].length();
            } else {
                Convert.writeIntToByteArr(b, byteOff, 0);
                byteOff += 4;
            }
            ++i2;
        }
        return b;
    }

    public static final void uStringArrToByteArr(byte[] b, int pos, String[] s, int off, int length) {
        int i = off;
        while (i < off + length) {
            if (s[i] != null) {
                Convert.writeIntToByteArr(b, pos, s[i].length());
                Convert.writeUStringToByteArr(b, pos += 4, s[i]);
                pos += 2 * s[i].length();
            } else {
                Convert.writeIntToByteArr(b, pos, 0);
                pos += 4;
            }
            ++i;
        }
    }

    public static final byte[] aStringArrToByteArr(String[] s) {
        return Convert.aStringArrToByteArr(s, 0, s.length);
    }

    public static final byte[] aStringArrToByteArr(String[] s, int off, int length) {
        int byteOff = 0;
        int byteCount = 0;
        int i = off;
        while (i < off + length) {
            if (s[i] != null) {
                byteCount += s[i].length();
            }
            ++i;
        }
        byte[] b = new byte[byteCount + 4 * s.length];
        int i2 = off;
        while (i2 < off + length) {
            if (s[i2] != null) {
                Convert.writeIntToByteArr(b, byteOff, s[i2].length());
                Convert.writeAStringToByteArr(b, byteOff += 4, s[i2]);
                byteOff += s[i2].length();
            } else {
                Convert.writeIntToByteArr(b, byteOff, 0);
                byteOff += 4;
            }
            ++i2;
        }
        return b;
    }

    public static final void aStringArrToByteArr(byte[] b, int pos, String[] s, int off, int length) {
        int i = off;
        while (i < off + length) {
            if (s[i] != null) {
                Convert.writeIntToByteArr(b, pos, s[i].length());
                Convert.writeAStringToByteArr(b, pos += 4, s[i]);
                pos += s[i].length();
            } else {
                Convert.writeIntToByteArr(b, pos, 0);
                pos += 4;
            }
            ++i;
        }
    }

    public static final int[] byteArrToIntArr(byte[] b) {
        return Convert.byteArrToIntArr(b, 0, b.length / 4);
    }

    public static final int[] byteArrToIntArr(byte[] b, int off, int length) {
        int[] z = new int[length];
        int i = 0;
        while (i < length) {
            z[i] = 0;
            int j = 3;
            while (j > 0) {
                z[i] = (z[i] | b[off + j + 4 * i] & 0xFF) << 8;
                --j;
            }
            z[i] = z[i] | b[off + 4 * i] & 0xFF;
            ++i;
        }
        return z;
    }

    public static final void byteArrToIntArr(byte[] b, int off, int[] i, int pos, int length) {
        int j = 0;
        while (j < length) {
            i[j + pos] = 0;
            int k = 3;
            while (k > 0) {
                i[j + pos] = (i[j + pos] | b[off + k + 4 * j] & 0xFF) << 8;
                --k;
            }
            i[j + pos] = i[j + pos] | b[off + 4 * j] & 0xFF;
            ++j;
        }
    }

    public static final long[] byteArrToLongArr(byte[] b) {
        return Convert.byteArrToLongArr(b, 0, b.length / 8);
    }

    public static final long[] byteArrToLongArr(byte[] b, int off, int length) {
        long[] l = new long[length];
        int i = 0;
        while (i < length) {
            l[i] = 0L;
            int j = 0;
            while (j < 8) {
                l[i] = l[i] | (long)((b[8 * i + j + off] & 0xFF) << 8 * j);
                ++j;
            }
            ++i;
        }
        return l;
    }

    public static final void byteArrToLongArr(byte[] b, int off, long[] l, int pos, int length) {
        int i = 0;
        while (i < length) {
            l[i + pos] = 0L;
            int j = 0;
            while (j < 8) {
                l[i + pos] = l[i + pos] | (long)((b[8 * i + j + off] & 0xFF) << 8 * j);
                ++j;
            }
            ++i;
        }
    }

    public static final boolean[] byteArrToBooleanArr(byte[] b) {
        return Convert.byteArrToBooleanArr(b, 0, b.length);
    }

    public static final boolean[] byteArrToBooleanArr(byte[] b, int off, int length) {
        boolean[] bool = new boolean[length];
        int i = 0;
        while (i < length) {
            bool[i] = b[i + off] == 0;
            ++i;
        }
        return bool;
    }

    public static final void byteArrToBooleanArr(byte[] b, int off, boolean[] bool, int pos, int length) {
        int i = 0;
        while (i < length) {
            bool[i + pos] = b[i + off] == 0;
            ++i;
        }
    }

    public static final char[] byteArrToCharArr(byte[] b) {
        return Convert.byteArrToCharArr(b, 0, b.length / 2);
    }

    public static final char[] byteArrToCharArr(byte[] b, int off, int length) {
        char[] c = new char[length];
        int i = 0;
        while (i < length) {
            c[i] = (char)(b[2 * i + off] << 8 | b[2 * i + 1 + off] & 0xFF);
            ++i;
        }
        return c;
    }

    public static final void byteArrToCharArr(byte[] b, int off, char[] c, int pos, int length) {
        int i = 0;
        while (i < length) {
            c[i + pos] = (char)(b[2 * i + off] << 8 | b[2 * i + 1 + off] & 0xFF);
            ++i;
        }
    }

    public static final short[] byteArrToShortArr(byte[] b) {
        return Convert.byteArrToShortArr(b, 0, b.length / 2);
    }

    public static final short[] byteArrToShortArr(byte[] b, int off, int length) {
        short[] z = new short[length];
        int i = 0;
        while (i < length) {
            z[i] = (short)((0 | b[off + 1 + 2 * i] & 0xFF) << 8 | b[off + 2 * i] & 0xFF);
            ++i;
        }
        return z;
    }

    public static final void byteArrToShortArr(byte[] b, int off, short[] s, int pos, int length) {
        int i = 0;
        while (i < length) {
            s[i + pos] = (short)((0 | b[off + 1 + 2 * i] & 0xFF) << 8 | b[off + 2 * i] & 0xFF);
            ++i;
        }
    }

    public static final float[] byteArrToFloatArr(byte[] b) {
        return Convert.byteArrToFloatArr(b, 0, b.length / 4);
    }

    public static final float[] byteArrToFloatArr(byte[] b, int off, int length) {
        float[] z = new float[length];
        int i = 0;
        while (i < length) {
            int k = 0;
            int j = 3;
            while (j > 0) {
                k = (k | b[off + j + 4 * i] & 0xFF) << 8;
                --j;
            }
            z[i] = Float.intBitsToFloat(k |= b[off + 4 * i] & 0xFF);
            ++i;
        }
        return z;
    }

    public static final void byteArrToFloatArr(byte[] b, int off, float[] f, int pos, int length) {
        int i = 0;
        while (i < length) {
            int k = 0;
            int j = 3;
            while (j > 0) {
                k = (k | b[off + j + 4 * i] & 0xFF) << 8;
                --j;
            }
            f[pos + i] = Float.intBitsToFloat(k |= b[off + 4 * i] & 0xFF);
            ++i;
        }
    }

    public static final double[] byteArrToDoubleArr(byte[] b) {
        return Convert.byteArrToDoubleArr(b, 0, b.length / 8);
    }

    public static final double[] byteArrToDoubleArr(byte[] b, int off, int length) {
        double[] d = new double[length];
        int i = 0;
        while (i < length) {
            long l = 0L;
            int j = 0;
            while (j < 8) {
                l |= (long)((b[8 * i + j + off] & 0xFF) << 8 * j);
                ++j;
            }
            d[i] = Double.longBitsToDouble(l);
            ++i;
        }
        return d;
    }

    public static final void byteArrToDoubleArr(byte[] b, int off, double[] d, int pos, int length) {
        int i = 0;
        while (i < length) {
            long l = 0L;
            int j = 0;
            while (j < 8) {
                l |= (long)((b[off + 8 * i + j] & 0xFF) << 8 * j);
                ++j;
            }
            d[pos + i] = Double.longBitsToDouble(l);
            ++i;
        }
    }

    public static final String[] byteArrToUStringArr(byte[] b) {
        return Convert.byteArrToUStringArr(b, 0, b.length);
    }

    public static final String[] byteArrToUStringArr(byte[] b, int off, int length) {
        int stringLen;
        int endPos = off + length;
        int arrayLen = 0;
        int i = off;
        while (i < endPos) {
            stringLen = Convert.byteArrToInt(b, i);
            i += 4 + stringLen * 2;
            ++arrayLen;
        }
        String[] s = new String[arrayLen];
        int i2 = 0;
        while (i2 < arrayLen) {
            stringLen = Convert.byteArrToInt(b, off);
            off += 4;
            if (stringLen != 0) {
                s[i2] = Convert.byteArrToUString(b, off, stringLen);
                off += 2 * s[i2].length();
            } else {
                s[i2] = new String("");
            }
            ++i2;
        }
        return s;
    }

    public static final void byteArrToUStringArr(byte[] b, int off, String[] s, int pos, int length) {
        int i = 0;
        while (i < length) {
            int stringLen = Convert.byteArrToInt(b, off);
            off += 4;
            if (stringLen != 0) {
                s[i + pos] = Convert.byteArrToUString(b, off, stringLen);
                off += 2 * s[i].length();
            } else {
                s[i] = new String("");
            }
            ++i;
        }
    }

    public static final String[] byteArrToAStringArr(byte[] b) {
        int off = 0;
        Vector<String> v = new Vector<String>();
        while (off < b.length) {
            int length = Convert.byteArrToInt(b, off);
            if (length != 0) {
                v.addElement(Convert.byteArrToAString(b, off + 4, length));
            } else {
                v.addElement(new String(""));
            }
            off = off + length + 4;
        }
        String[] s = new String[v.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)v.elementAt(i);
            ++i;
        }
        return s;
    }

    public static final String[] byteArrToAStringArr(byte[] b, int off, int length) {
        String[] s = new String[length];
        int i = 0;
        while (i < length) {
            int stringLen = Convert.byteArrToInt(b, off);
            off += 4;
            if (stringLen != 0) {
                s[i] = Convert.byteArrToAString(b, off, stringLen);
                off += s[i].length();
            } else {
                s[i] = new String("");
            }
            ++i;
        }
        return s;
    }

    public static final void byteArrToAStringArr(byte[] b, int off, String[] s, int pos, int length) {
        int i = 0;
        while (i < length) {
            int stringLen = Convert.byteArrToInt(b, off);
            off += 4;
            if (stringLen != 0) {
                s[i + pos] = Convert.byteArrToAString(b, off, stringLen);
                off += s[i].length();
            } else {
                s[i] = new String("");
            }
            ++i;
        }
    }

    public static final int compareInts(byte[] b1, int off1, byte[] b2, int off2) {
        int r = b1[off1 + 3] - b2[off2 + 3];
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 2] & 0xFF) - (b2[off2 + 2] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 1] & 0xFF) - (b2[off2 + 1] & 0xFF);
        if (r != 0) {
            return r;
        }
        return (b1[off1] & 0xFF) - (b2[off2] & 0xFF);
    }

    public static final int compareLongs(byte[] b1, int off1, byte[] b2, int off2) {
        int r = b1[off1 + 7] - b2[off2 + 7];
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 6] & 0xFF) - (b2[off2 + 6] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 5] & 0xFF) - (b2[off2 + 5] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 4] & 0xFF) - (b2[off2 + 4] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 3] & 0xFF) - (b2[off2 + 3] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 2] & 0xFF) - (b2[off2 + 2] & 0xFF);
        if (r != 0) {
            return r;
        }
        r = (b1[off1 + 1] & 0xFF) - (b2[off2 + 1] & 0xFF);
        if (r != 0) {
            return r;
        }
        return (b1[off1] & 0xFF) - (b2[off2] & 0xFF);
    }
}

