/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jar;

import java.io.Serializable;
import java.util.Vector;

public class RemoteObjectMapping
implements Serializable {
    static final long serialVersionUID = 2418438271765599642L;
    protected String name;
    protected Vector classNames;

    public RemoteObjectMapping() {
        this.name = null;
        this.classNames = new Vector();
    }

    public RemoteObjectMapping(String interfaceName) {
        this.name = interfaceName;
        this.classNames = new Vector();
    }

    public void setInterfaceName(String _name) {
        this.name = _name;
    }

    public String getInterfaceName() {
        return this.name;
    }

    public void setClassName(String name) {
        if (this.classNames == null) {
            this.classNames = new Vector();
        }
        this.classNames.add(name);
    }

    public String getClassName(int position) {
        return (String)this.classNames.elementAt(position);
    }

    public Vector getClassNames() {
        return this.classNames;
    }

    public void setClassNames(Vector vec) {
        this.classNames = vec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalClassNames(Vector names) {
        if (this.classNames != null) {
            if (names == null) return false;
            if (names.size() != this.classNames.size()) return false;
            int i = 0;
            while (i < this.classNames.size()) {
                if (!names.contains(this.classNames.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (names == null) return true;
            return false;
        }
    }

    public boolean equals(Object remObject) {
        if (remObject == null) {
            return false;
        }
        if (this == remObject) {
            return true;
        }
        if (remObject instanceof RemoteObjectMapping) {
            RemoteObjectMapping tempObject = (RemoteObjectMapping)remObject;
            if (this.name != null ? !this.name.equals(tempObject.name) : tempObject.name != null) {
                return false;
            }
            return this.equalClassNames(tempObject.classNames);
        }
        return false;
    }

    public Object clone() {
        RemoteObjectMapping remObject = new RemoteObjectMapping();
        remObject.name = this.name;
        remObject.classNames = this.classNames != null ? (Vector)this.classNames.clone() : null;
        return remObject;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

