/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jar;

import com.sap.engine.lib.jar.RemoteObjectMapping;
import com.sap.engine.lib.lang.DynamicClassLoader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RemoteObjectFinder {
    DynamicClassLoader loader = null;
    Vector remoteObjects = new Vector();
    JarFile jarFile = null;

    public RemoteObjectFinder() {
    }

    public RemoteObjectFinder(DynamicClassLoader _loader) {
        this.loader = this.loader;
        this.remoteObjects = new Vector();
    }

    public RemoteObjectFinder(JarFile _file) {
        if (this.loader == null) {
            try {
                this.loader = new DynamicClassLoader(_file.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.remoteObjects = new Vector();
        this.jarFile = _file;
    }

    public RemoteObjectFinder(String jarFileName) {
        if (this.loader == null) {
            try {
                this.loader = new DynamicClassLoader(jarFileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.remoteObjects = new Vector();
    }

    public void setLoader(ClassLoader _loader) {
        this.loader = this.loader;
    }

    public void findRemoteObjects(String jarName) {
        if (this.loader == null) {
            this.loader = new DynamicClassLoader(jarName);
        }
        try {
            this.jarFile = new JarFile(jarName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.findRemoteObjects();
    }

    public void findRemoteObjects() {
        Class remote = null;
        Vector classes = this.loadClassesFromJar();
        if (classes == null) {
            return;
        }
        try {
            remote = this.loader.loadClass("java.rmi.Remote");
        }
        catch (ClassNotFoundException exc) {
            // empty catch block
        }
        Class cl = null;
        RemoteObjectMapping remObject = null;
        int i = 0;
        while (i < classes.size()) {
            cl = (Class)classes.elementAt(i);
            if (cl.isInterface() && this.hasImplemention(cl, remote)) {
                remObject = new RemoteObjectMapping(cl.getName());
                this.remoteObjects.addElement(remObject);
            }
            ++i;
        }
        Class rem_intf = null;
        Object portable = null;
        Vector rem_intf_vec = null;
        int i2 = 0;
        while (i2 < this.remoteObjects.size()) {
            remObject = (RemoteObjectMapping)this.remoteObjects.elementAt(i2);
            try {
                rem_intf = this.loader.loadClass(remObject.getInterfaceName());
            }
            catch (ClassNotFoundException exc) {
                // empty catch block
            }
            rem_intf_vec = remObject.getClassNames();
            int j = 0;
            while (j < classes.size()) {
                cl = (Class)classes.elementAt(j);
                if (!cl.isInterface() && rem_intf.isAssignableFrom(cl)) {
                    rem_intf_vec.addElement(cl.getName());
                }
                ++j;
            }
            remObject.setClassNames(rem_intf_vec);
            ++i2;
        }
    }

    public RemoteObjectMapping[] getFoundedMapping() {
        Object[] mapping = null;
        if (this.remoteObjects.size() > 0) {
            mapping = new RemoteObjectMapping[this.remoteObjects.size()];
            this.remoteObjects.copyInto(mapping);
        }
        return mapping;
    }

    protected Vector loadClassesFromJar() {
        Vector<Class> classesVector = new Vector<Class>();
        if (this.jarFile != null) {
            Enumeration<JarEntry> jarEntries = this.jarFile.entries();
            Class cl = null;
            JarEntry jarEntry = null;
            String jarEntryName = null;
            String className = null;
            while (jarEntries.hasMoreElements()) {
                jarEntry = jarEntries.nextElement();
                jarEntryName = jarEntry.getName();
                className = null;
                if (!jarEntryName.endsWith("class")) continue;
                className = this.convertString(jarEntryName);
                try {
                    cl = this.loader == null ? Class.forName(className) : this.loader.loadClass(className);
                    classesVector.addElement(cl);
                }
                catch (ClassNotFoundException exc) {
                }
                catch (OutOfMemoryError o) {
                    Object var10_11;
                    try {
                        o.printStackTrace();
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        System.exit(666);
                        throw throwable;
                    }
                    System.exit(666);
                    {
                    }
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
        }
        return classesVector;
    }

    protected String convertString(String str) {
        String newString = str;
        newString = str.replace('/', '.');
        newString = str.replace('\\', '.');
        newString = newString.substring(0, newString.length() - 6);
        return newString;
    }

    protected boolean hasImplemention(Class cl, Class intf) {
        Class<?>[] classIntfs = cl.getInterfaces();
        if (classIntfs != null) {
            int i = 0;
            while (i < classIntfs.length) {
                if (classIntfs[i].getName().equals(intf.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

