/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jar;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jar.InfoObject;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarUtils {
    protected String jarFile = null;
    protected Vector infoObjects = new Vector();
    protected ClassLoader loader;
    protected String additionalPaths = null;

    public JarUtils() {
    }

    public JarUtils(String jarFile) {
        this.setJarFile(jarFile);
    }

    public JarUtils(String jarFile, Vector files) {
        this.setJarFile(jarFile);
        this.setInfoObjects(files);
    }

    public JarUtils(String jarFile, Vector files, ClassLoader loader) {
        this.setJarFile(jarFile);
        this.setInfoObjects(files);
        this.setLoader(loader);
    }

    public void setJarFile(String jarName) {
        this.jarFile = jarName;
    }

    public void setInfoObjects(Vector infos) {
        this.infoObjects = infos;
    }

    public void setLoader(ClassLoader cLoader) {
        this.loader = cLoader;
    }

    public void setAdditionalPaths(String paths) {
        this.additionalPaths = paths;
    }

    public String getAdditionalPaths() {
        return this.additionalPaths;
    }

    public void makeJarFromDir(String jarName, String dirName) throws IOException {
        this.makeJarFromDir(jarName, new String[]{dirName});
    }

    public void makeJarFromDir(String jarName, String[] dirNames) throws IOException {
        Vector vec = new Vector();
        int i = 0;
        while (i < dirNames.length) {
            this.listDir(dirNames[i], vec);
            ++i;
        }
        this.makeJarFromFiles(jarName, vec);
    }

    public void makeJarFromDir(String jarName, String[] dirNames, Vector filters) throws IOException {
        Vector vec = new Vector();
        int i = 0;
        while (i < dirNames.length) {
            this.listDir(dirNames[i], vec);
            ++i;
        }
        if (filters != null && !filters.isEmpty()) {
            InfoObject info = null;
            boolean found = false;
            int j = vec.size() - 1;
            while (j >= 0) {
                info = (InfoObject)vec.elementAt(j);
                found = false;
                int ind = 0;
                while (ind < filters.size()) {
                    if (info.getEntryName().endsWith((String)filters.elementAt(ind))) {
                        found = true;
                        break;
                    }
                    ++ind;
                }
                if (!found) {
                    vec.removeElementAt(j);
                }
                --j;
            }
        }
        this.makeJarFromFiles(jarName, vec);
    }

    public void makeJarFromFiles(String jarName, Vector files) throws IOException {
        this.writeJarFile(jarName, files);
    }

    public void makeJar() throws IOException {
        this.writeJarFile(this.jarFile, this.infoObjects);
    }

    /*
     * Loose catch block
     */
    private void writeJarFile(String jarName, Vector infos) throws IOException {
        block13: {
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            FilterOutputStream zip = null;
            fos = new FileOutputStream(jarName);
            bos = new BufferedOutputStream(fos);
            zip = new JarOutputStream(bos);
            ((ZipOutputStream)zip).setMethod(0);
            this.writeAdditionalEntries((JarOutputStream)zip);
            if (infos.size() > 0) {
                Enumeration fileObjects = infos.elements();
                InfoObject infoObj = null;
                while (fileObjects.hasMoreElements()) {
                    infoObj = (InfoObject)fileObjects.nextElement();
                    if (infoObj == null) continue;
                    this.copyJFile((JarOutputStream)zip, infoObj.getEntryName(), infoObj.getFilePath());
                }
            } else {
                byte[] empty = new byte[]{};
                ZipEntry manifest = new ZipEntry("META-INF/MANIFEST.MF");
                manifest.setSize(0L);
                CRC32 crc = new CRC32();
                crc.update(empty);
                manifest.setCrc(crc.getValue());
                try {
                    ((JarOutputStream)zip).putNextEntry(manifest);
                    ((ZipOutputStream)zip).write(empty, 0, 0);
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    ((ZipOutputStream)zip).closeEntry();
                    throw throwable;
                }
                ((ZipOutputStream)zip).closeEntry();
                {
                }
            }
            Object var12_15 = null;
            try {
                zip.flush();
                ((ZipOutputStream)zip).finish();
                ((ZipOutputStream)zip).close();
                bos.close();
                fos.close();
            }
            catch (Exception exx) {}
            break block13;
            {
                catch (ZipException ze) {
                    ze.printStackTrace();
                    Object var12_16 = null;
                    try {
                        zip.flush();
                        ((ZipOutputStream)zip).finish();
                        ((ZipOutputStream)zip).close();
                        bos.close();
                        fos.close();
                    }
                    catch (Exception exx) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                try {
                    zip.flush();
                    ((ZipOutputStream)zip).finish();
                    ((ZipOutputStream)zip).close();
                    bos.close();
                    fos.close();
                }
                catch (Exception exx) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void listDir(String dirName, Vector allFiles) {
        if (dirName == null || dirName == "") {
            return;
        }
        File directory = new File(dirName);
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            InfoObject info = null;
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    info = new InfoObject(this.getEntryName(files[i], ""), files[i].getAbsolutePath());
                    allFiles.addElement(info);
                } else {
                    this.recursivePack(files[i].getAbsolutePath(), "", allFiles);
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyJFile(JarOutputStream zip, String entryName, String filePath) throws IOException {
        ZipFile zFile = null;
        ZipEntry entry = null;
        if (filePath.endsWith(".jar") || filePath.endsWith(".ear") || filePath.endsWith(".war") || filePath.endsWith(".rar") || filePath.endsWith(".zip")) {
            if (!(entryName.endsWith(".jar") || entryName.endsWith(".ear") || entryName.endsWith(".war") || entryName.endsWith(".rar") || entryName.endsWith(".zip"))) {
                try {
                    block13: {
                        try {
                            zFile = new ZipFile(filePath);
                            entry = zFile.getEntry(entryName);
                            if (entry == null) break block13;
                            this.makeEntry(zip, entryName, zFile.getInputStream(new ZipEntry(entryName)), zFile.getInputStream(new ZipEntry(entryName)));
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    Object var8_6 = null;
                    if (zFile == null) return;
                    zFile.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (zFile == null) throw throwable;
                    zFile.close();
                    throw throwable;
                }
            }
            try {
                block14: {
                    try {
                        zFile = new ZipFile(filePath);
                        entry = zFile.getEntry(entryName);
                        if (entry != null) {
                            this.makeEntry(zip, entryName, zFile.getInputStream(new ZipEntry(entryName)), zFile.getInputStream(new ZipEntry(entryName)));
                            break block14;
                        }
                        this.makeEntry(zip, entryName, new FileInputStream(filePath), new FileInputStream(filePath));
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Object var10_12 = null;
                if (zFile == null) return;
                zFile.close();
                return;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (zFile == null) throw throwable;
                zFile.close();
                throw throwable;
            }
        }
        try {
            this.makeEntry(zip, entryName, new FileInputStream(filePath), new FileInputStream(filePath));
            return;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JarEntry makeEntry(ZipOutputStream zip, String entryName, InputStream in, InputStream check) throws IOException {
        if (in == null) {
            return null;
        }
        JarEntry entry = null;
        try {
            try {
                int count = 0;
                int size = 0;
                byte[] buff = new byte[16384];
                CRC32 crc = new CRC32();
                entry = new JarEntry(entryName.replace('\\', '/'));
                try {
                    while ((count = check.read(buff)) != -1) {
                        size += count;
                        crc.update(buff, 0, count);
                    }
                    entry.setMethod(0);
                    entry.setCrc(crc.getValue());
                    entry.setSize(size);
                    entry.setCompressedSize(size);
                    zip.putNextEntry(entry);
                    while ((count = in.read(buff)) != -1) {
                        zip.write(buff, 0, count);
                    }
                }
                catch (EOFException ex) {
                    throw new IOException(ex.getMessage());
                }
                Object var12_12 = null;
                in.close();
                zip.closeEntry();
                check.close();
                return entry;
            }
            catch (ZipException zipEx) {
                throw new IOException(zipEx.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            in.close();
            zip.closeEntry();
            check.close();
            throw throwable;
        }
    }

    private String getEntryName(File file, String packName) {
        String tempName = file.getName();
        tempName = (packName.trim().equals("") ? "" : packName + "\\") + tempName;
        return tempName;
    }

    private void recursivePack(String dirName, String packageName, Vector files) {
        InfoObject info = null;
        File f = new File(dirName);
        if (f.isDirectory()) {
            File[] dirFiles = f.listFiles();
            if (dirFiles != null) {
                int i = 0;
                while (i < dirFiles.length) {
                    if (dirFiles[i].isDirectory()) {
                        this.recursivePack(dirFiles[i].getAbsolutePath(), (packageName.equals("") ? "" : packageName + "\\") + f.getName(), files);
                    } else {
                        info = new InfoObject(this.getEntryName(dirFiles[i], (packageName.equals("") ? "" : packageName + "\\") + f.getName()), dirFiles[i].getAbsolutePath());
                        files.addElement(info);
                    }
                    ++i;
                }
            }
        } else {
            info = new InfoObject(packageName.equals("") ? f.getName() : packageName + "\\" + f.getName(), f.getAbsolutePath());
            files.addElement(info);
        }
    }

    protected void addDirEntries(JarOutputStream jos, String jarEntryName) throws IOException {
        int ind = jarEntryName.indexOf(47);
        String dir = "";
        JarEntry jentry = null;
        while (ind >= 0) {
            dir = dir + jarEntryName.substring(0, ind + 1);
            jarEntryName = jarEntryName.substring(ind + 1);
            ind = jarEntryName.indexOf(47);
            jentry = new JarEntry(dir);
            jentry.setSize(0L);
            try {
                jos.putNextEntry(jentry);
                jos.closeEntry();
            }
            catch (ZipException z) {
                jos.closeEntry();
            }
        }
    }

    public void writeAdditionalEntries(JarOutputStream zip) throws IOException {
    }

    public File findFile(String fname) throws IOException {
        if (fname == null) {
            return null;
        }
        boolean find = false;
        File file = null;
        File dirs = null;
        JarFile jar = null;
        ZipEntry entry = null;
        Vector dir = this.getClassPathDirs();
        StringBuffer sb = new StringBuffer(fname);
        if (sb.toString().endsWith(".xml")) {
            return null;
        }
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '.') {
                sb.setCharAt(i, File.separatorChar);
            }
            ++i;
        }
        sb.append(".class");
        i = 0;
        while (i < dir.size()) {
            dirs = new File((String)dir.elementAt(i));
            if (dirs.isDirectory()) {
                file = new File((String)dir.elementAt(i) + sb.toString());
                if (file.exists()) {
                    find = true;
                    break;
                }
            } else {
                find = false;
                if ((((String)dir.elementAt(i)).endsWith(".zip") || ((String)dir.elementAt(i)).endsWith(".jar")) && (entry = (jar = new JarFile((String)dir.elementAt(i))).getEntry(fname.replace('.', '/') + ".class")) != null) {
                    find = true;
                    file = new File((String)dir.elementAt(i));
                    jar.close();
                    break;
                }
            }
            ++i;
        }
        if (find) {
            return file;
        }
        throw new FileNotFoundException("Searched file " + fname + " is not found!");
    }

    public Vector getClassPathDirs() {
        Vector<String> dir = null;
        String classpath = SystemProperties.getProperty((String)"java.class.path");
        StringTokenizer tokenizer = null;
        String temp = null;
        dir = this.parsePath(this.additionalPaths);
        if (dir == null) {
            dir = new Vector<String>();
        }
        tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            temp = (String)tokenizer.nextElement();
            if (temp.equals("") || dir.contains(temp)) continue;
            dir.add(temp);
        }
        int i = 0;
        while (i < dir.size()) {
            temp = (String)dir.elementAt(i);
            if (temp.equals(".")) {
                dir.setElementAt(SystemProperties.getProperty((String)"user.dir"), i);
            }
            if (!(temp.endsWith(File.separator) || temp.endsWith(".jar") || temp.endsWith(".zip"))) {
                dir.setElementAt(temp + File.separator, i);
            }
            ++i;
        }
        return dir;
    }

    public Vector parsePath(String clPath) {
        Vector<String> values = new Vector<String>();
        if (clPath == null) {
            return values;
        }
        String tempPath = clPath;
        int index = -1;
        index = tempPath.indexOf(File.pathSeparator);
        String tempValue = "";
        while (index != -1) {
            tempValue = tempPath.substring(0, index);
            if (new File(tempValue).isDirectory()) {
                tempValue = tempValue + File.separator;
            }
            values.addElement(tempValue);
            tempPath = tempPath.substring(index + 1, tempPath.length());
            index = tempPath.indexOf(File.pathSeparator);
        }
        if (index == -1 && tempPath.length() > 0) {
            values.addElement(tempPath);
        }
        return values;
    }
}

