/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.InDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.hash.PathNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipInDepthIterator
implements InDepthIterator {
    ZipFile inFile = null;
    Enumeration enum = null;

    public ZipInDepthIterator(File file) throws IOException {
        this.inFile = new ZipFile(file);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File [" + file.getName() + "] does not exist.");
        }
        this.enum = this.inFile.entries();
    }

    public void addEntries(Index targetIndex) throws IOException {
        String path = null;
        String fileName = null;
        String fullName = null;
        while (this.enum.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)this.enum.nextElement();
            fullName = entry.getName().trim();
            if (!entry.isDirectory()) {
                int leftSlash;
                int lastIndex;
                int rightSlash = fullName.lastIndexOf(47);
                int n = lastIndex = rightSlash > (leftSlash = fullName.lastIndexOf(92)) ? rightSlash : leftSlash;
                if (lastIndex > -1) {
                    path = fullName.substring(0, lastIndex).trim();
                    fileName = fullName.substring(path.length() + 1).trim();
                } else {
                    path = "/";
                    fileName = fullName;
                }
                try {
                    targetIndex.addFileTo(path, fileName, this.inFile.getInputStream(entry), true, true);
                }
                catch (PathNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                targetIndex.ensurePath(fullName, true);
            }
            catch (PathNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.inFile.getName();
    }
}

