/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.FolderCompareResult;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.hash.MultipleHash;
import com.sap.engine.lib.lang.Convert;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Test {
    private static Index folderHash1 = null;
    private static Index folderHash2 = null;
    private static Index folderHash3 = null;

    public static void oper1(String filename1, String filename2) throws IOException {
        File work = new File(filename2);
        Index fh = HashUtils.getIndex(work);
        RandomAccessFile df = new RandomAccessFile(filename1, "rw");
        byte[] byteArr = fh.toByteArr();
        df.write(byteArr);
        df.close();
        System.out.println("Written " + byteArr.length + " bytes.");
        byteArr = fh.getHash();
        System.out.println("Generated hash for [" + filename2 + "] is [" + Convert.byteArrToHexString(byteArr) + "]...");
    }

    public static void oper2(String filename1, String filename2) throws IOException {
        File work1 = new File(filename1);
        File work2 = new File(filename2);
        Index fh1 = HashUtils.getIndex(work1);
        Index fh2 = HashUtils.getIndex(work2);
        FolderCompareResult rez = fh1.compare(fh2, true);
        System.out.println(rez);
    }

    public static void oper3(String filename1, String filename2) throws IOException {
        RandomAccessFile wrk = null;
        wrk = new RandomAccessFile(filename1, "r");
        byte[] buffer = new byte[(int)wrk.length()];
        wrk.readFully(buffer);
        MultipleHash fh1 = null;
        try {
            fh1 = new MultipleHash(buffer, 0);
        }
        catch (CorruptedHashException e) {
            e.printStackTrace();
        }
        wrk.close();
        wrk = new RandomAccessFile(filename2, "r");
        buffer = new byte[(int)wrk.length()];
        wrk.readFully(buffer);
        MultipleHash fh2 = null;
        try {
            fh2 = new MultipleHash(buffer, 0);
        }
        catch (CorruptedHashException e) {
            e.printStackTrace();
        }
        wrk.close();
        FolderCompareResult rez = fh1.compare(fh2, true);
        System.out.println(rez);
    }

    public static void main(String[] args) {
        System.out.println("args.length = " + args.length);
        if (args.length != 3) {
            System.out.println("HashManipulator v0.3104beta (c) SAP Labs Bulgaria");
            System.out.println("  USAGE: test -write datafilename folder_to_hash");
            System.out.println("         test -compare filder1 folder2");
            System.out.println("         test -comparefiles datafile1 datafile2");
            System.exit(5);
        }
        try {
            long strt = System.currentTimeMillis();
            if (args[0].equalsIgnoreCase("-write")) {
                Test.oper1(args[1], args[2]);
            } else if (args[0].equalsIgnoreCase("-compare")) {
                Test.oper2(args[1], args[2]);
            } else if (args[0].equalsIgnoreCase("-comparefiles")) {
                Test.oper3(args[1], args[2]);
            }
            long endt = System.currentTimeMillis();
            System.out.println("Time: " + (endt - strt) + " ms");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

