/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.HashInputStream;
import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.Entry;
import com.sap.engine.lib.io.hash.HashCompare;
import com.sap.engine.lib.io.hash.IndexUtils;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ArrayByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class SingleHashAdapter
implements Entry {
    static final long serialVersionUID = -1735394991390132744L;
    public static final int RECORD_SIZE_OFFSET = 0;
    public static final int RECORD_VERSION_OFFSET = 4;
    public static final int RECORD_HASH_OFFSET = 8;
    public static final int RECORD_NAME_LENGTH_OFFSET = 24;
    public static final int RECORD_NAME_DATA_OFFSET = 28;
    protected static IndexUtils utils = IndexUtils.getInstance();
    protected byte[] hash = null;
    protected String name = null;
    protected byte[] nameBytes = null;

    protected SingleHashAdapter() {
    }

    protected SingleHashAdapter(byte[] data, int offset) throws CorruptedHashException {
        this.decodeFromByteArray(data, offset);
    }

    protected SingleHashAdapter(String name, InputStream stream) throws IOException {
        HashInputStream his = new HashInputStream(stream);
        byte[] buffer = new byte[64000];
        while (his.read(buffer) != -1) {
        }
        this.init(name, his.hash());
    }

    protected SingleHashAdapter(String name, byte[] hash) {
        this.init(name, hash);
    }

    protected void init(String name, byte[] hash) {
        this.name = name;
        this.nameBytes = Convert.stringAToByteArr(name);
        this.hash = hash;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameBytes() {
        return this.nameBytes;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] toByteArr() {
        return this.generateByteArray();
    }

    protected byte[] generateByteArray() {
        int expectedSize = this.calculateExpectedByteArraySize();
        byte[] data = new byte[expectedSize];
        this.encodeToByteArray(data, 0, expectedSize);
        return data;
    }

    protected boolean compareHashes(Entry otherEntry) {
        return HashCompare.compareHash(this.hash, otherEntry.getHash());
    }

    public int compareTo(Object o) {
        Entry other = (Entry)o;
        return this.name.compareTo(other.getName());
    }

    protected void encodeHeaderData(byte[] data, int offset, int recordSize) {
        Convert.writeIntToByteArr(data, offset + 0, recordSize);
        IndexUtils.encodeVersion(data, offset + 4, this.getType());
        System.arraycopy(this.hash, 0, data, offset + 8, 16);
        Convert.writeIntToByteArr(data, offset + 24, this.nameBytes.length);
        System.arraycopy(this.nameBytes, 0, data, offset + 28, this.nameBytes.length);
    }

    protected void decodeHeaderData(byte[] data, int offset) {
        this.hash = new byte[16];
        System.arraycopy(data, offset + 8, this.hash, 0, 16);
        int nameLength = Convert.byteArrToInt(data, offset + 24);
        this.nameBytes = new byte[nameLength];
        System.arraycopy(data, offset + 28, this.nameBytes, 0, nameLength);
        this.name = Convert.byteArrToAString(this.nameBytes);
    }

    protected int calculateAdditionalDataOffset() {
        return 28 + this.nameBytes.length;
    }

    protected abstract int calculateExpectedByteArraySize();

    protected abstract void decodeFromByteArray(byte[] var1, int var2) throws CorruptedHashException;

    protected abstract void encodeToByteArray(byte[] var1, int var2, int var3);

    public String toString() {
        return "|-" + this.name + "\n";
    }

    protected String internalToString(String prefix) {
        return prefix + "|-" + this.name + " <" + Convert.byteArrToHexString(this.hash) + ">\n";
    }

    public boolean equals(Object obj) {
        return HashCompare.compareHash(this.hash, ((Entry)obj).getHash());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(this.generateByteArray());
        out.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ArrayByte serial = new ArrayByte();
        byte[] buffer = new byte[64000];
        int bufferIndex = 0;
        while (bufferIndex != -1) {
            serial.addAll(buffer, 0, bufferIndex);
            bufferIndex = in.read(buffer);
        }
        this.decodeFromByteArray(serial.toArray(), 0);
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.deepClone();
    }

    public Object deepClone() {
        Class<?> c = this.getClass();
        SingleHashAdapter clonning = null;
        try {
            clonning = (SingleHashAdapter)c.newInstance();
            clonning.init(this.name, this.getHash());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return clonning;
    }

    public abstract byte getType();
}

