/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.Entry;
import com.sap.engine.lib.io.hash.FileHash;
import com.sap.engine.lib.io.hash.FilteredInDepthIterator;
import com.sap.engine.lib.io.hash.FolderCompareResult;
import com.sap.engine.lib.io.hash.FolderInDepthIterator;
import com.sap.engine.lib.io.hash.HashCompare;
import com.sap.engine.lib.io.hash.Hasher;
import com.sap.engine.lib.io.hash.InDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.hash.IndexUtils;
import com.sap.engine.lib.io.hash.PathNotFoundException;
import com.sap.engine.lib.io.hash.SingleHashAdapter;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.LinkedList;
import com.sap.engine.lib.util.iterators.RootIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class MultipleHash
extends SingleHashAdapter
implements Index {
    static final long serialVersionUID = -8423615317441771121L;
    ArrayObject files = new ArrayObject();
    ArrayObject folders = new ArrayObject();
    protected boolean changed = true;
    transient FilenameFilter filter = null;

    protected MultipleHash() {
        this.setChanged();
    }

    protected MultipleHash(InDepthIterator iter) throws IOException {
        this.filter = iter instanceof FilteredInDepthIterator ? ((FilteredInDepthIterator)iter).getFilter() : null;
        this.iterateEntries(iter);
    }

    protected MultipleHash(byte[] data, int offset) throws CorruptedHashException {
        this.decodeFromByteArray(data, offset);
    }

    private MultipleHash(String name) {
        this.init(name, null);
        this.setChanged();
    }

    private MultipleHash(File f) throws IOException {
        this.iterateEntries(new FolderInDepthIterator(f, this.filter));
    }

    private MultipleHash(File f, FilenameFilter filter) throws IOException {
        this.filter = filter;
        this.iterateEntries(new FolderInDepthIterator(f, filter));
    }

    private void iterateEntries(InDepthIterator iterator) throws IOException {
        iterator.addEntries(this);
        if (this.changed) {
            this.init(iterator.getName(), this.calculateHash());
        }
    }

    public byte[] getHash() {
        if (this.changed) {
            this.hash = this.calculateHash();
        }
        return this.hash;
    }

    protected void decodeFromByteArray(byte[] data, int offset) throws CorruptedHashException {
        SingleHashAdapter.utils.verifyCRC(data, offset);
        this.decodeHeaderData(data, offset);
        this.files = new ArrayObject();
        this.folders = new ArrayObject();
        this.decodeAdditionalData(data, offset + this.calculateAdditionalDataOffset());
    }

    protected void decodeAdditionalData(byte[] data, int additionalDataOffset) throws CorruptedHashException {
        int index = additionalDataOffset;
        int count = Convert.byteArrToInt(data, index += 4);
        index += 4;
        int i = 0;
        while (i < count) {
            this.files.add((Object)new FileHash(data, index));
            index += Convert.byteArrToInt(data, index);
            ++i;
        }
        count = Convert.byteArrToInt(data, index += 4);
        index += 4;
        int i2 = 0;
        while (i2 < count) {
            this.folders.add((Object)new MultipleHash(data, index));
            index += Convert.byteArrToInt(data, index);
            ++i2;
        }
    }

    protected void encodeToByteArray(byte[] data, int offset, int recordSize) {
        this.encodeHeaderData(data, offset, recordSize);
        this.encodeAdditionalData(data, offset + this.calculateAdditionalDataOffset());
        SingleHashAdapter.utils.encodeCRC(data, offset, recordSize);
    }

    protected byte[] calculateHash() {
        Hasher localHasher = SingleHashAdapter.utils.getHasher();
        localHasher.updateHash(this.files.size());
        localHasher.updateHash(this.folders.size());
        this.files.sort();
        RootIterator iter = this.files.elementsIterator();
        Entry hashEntry = null;
        while (!iter.isAtEnd()) {
            hashEntry = (Entry)iter.next();
            localHasher.updateHash(hashEntry.getNameBytes());
            localHasher.updateHash(hashEntry.getHash());
        }
        this.folders.sort();
        iter = this.folders.elementsIterator();
        while (!iter.isAtEnd()) {
            hashEntry = (Entry)iter.next();
            localHasher.updateHash(hashEntry.getNameBytes());
            localHasher.updateHash(hashEntry.getHash());
        }
        byte[] localHash = localHasher.getHash();
        SingleHashAdapter.utils.releaseHasher(localHasher);
        this.changed = false;
        return localHash;
    }

    public int getFilesCount() {
        return this.files.size();
    }

    public int getFoldersCount() {
        return this.folders.size();
    }

    public FolderCompareResult compare(Index otherIndex, boolean traverseDeletedFolders) {
        FolderCompareResult fcr = new FolderCompareResult(this.getName(), otherIndex.getName());
        this.internalCompare("", this, (MultipleHash)otherIndex, fcr, traverseDeletedFolders);
        return fcr;
    }

    protected void internalCompare(String currentPath, MultipleHash first, MultipleHash second, FolderCompareResult fcr, boolean traverseDeletedFolders) {
        if (HashCompare.compareHash(first.getHash(), second.getHash())) {
            return;
        }
        this.differentiateEntries(currentPath, first.getFilesIterator(), second.getFilesIterator(), (byte)1, fcr, traverseDeletedFolders);
        this.differentiateEntries(currentPath, first.getFoldersIterator(), second.getFoldersIterator(), (byte)2, fcr, traverseDeletedFolders);
    }

    protected RootIterator getFilesIterator() {
        return this.files.elementsIterator();
    }

    protected RootIterator getFoldersIterator() {
        return this.folders.elementsIterator();
    }

    /*
     * Unable to fully structure code
     */
    protected void differentiateEntries(String currentPath, RootIterator first, RootIterator second, byte type, FolderCompareResult compareResult, boolean traverseDeletedFolders) {
        block14: {
            firstEntry = null;
            secondEntry = null;
            while (!first.isAtEnd() && !second.isAtEnd()) {
                fileComp = IndexUtils.compareNames(first.get(), second.get());
                switch (fileComp) {
                    case 0: {
                        firstEntry = (Entry)first.next();
                        secondEntry = (Entry)second.next();
                        if (firstEntry.equals(secondEntry)) break;
                        if (type == 2) {
                            this.internalCompare(currentPath + File.separator + firstEntry.getName(), (MultipleHash)firstEntry, (MultipleHash)secondEntry, compareResult, traverseDeletedFolders);
                            break;
                        }
                        compareResult.changedEntries.addLast((Object)(currentPath + File.separator + firstEntry.getName()));
                        break;
                    }
                    case 1: {
                        secondEntry = (Entry)second.next();
                        if (type == 2) {
                            compareResult.newEntries.addLast((Object)(currentPath + File.separator + secondEntry.getName()));
                            this.internalEntriesAdd(currentPath + File.separator + secondEntry.getName(), (MultipleHash)secondEntry, compareResult.changedEntries, compareResult.newEntries);
                            break;
                        }
                        compareResult.changedEntries.addLast((Object)(currentPath + File.separator + secondEntry.getName()));
                        break;
                    }
                    case -1: {
                        firstEntry = (Entry)first.next();
                        if (type == 2 && traverseDeletedFolders) {
                            this.internalEntriesAdd(currentPath + File.separator + firstEntry.getName(), (MultipleHash)firstEntry, compareResult.deletedEntries, compareResult.deletedEntries);
                        }
                        compareResult.deletedEntries.addLast((Object)(currentPath + File.separator + firstEntry.getName()));
                    }
                }
            }
            if (first.isAtEnd() && second.isAtEnd()) {
                return;
            }
            if (!first.isAtEnd()) ** GOTO lbl52
            while (!second.isAtEnd()) {
                secondEntry = (Entry)second.next();
                if (type == 2) {
                    compareResult.newEntries.addLast((Object)(currentPath + File.separator + secondEntry.getName()));
                    this.internalEntriesAdd(currentPath + File.separator + secondEntry.getName(), (MultipleHash)secondEntry, compareResult.changedEntries, compareResult.newEntries);
                    continue;
                }
                compareResult.changedEntries.addLast((Object)(currentPath + File.separator + secondEntry.getName()));
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                firstEntry = (Entry)first.next();
                if (type == 2 && traverseDeletedFolders) {
                    this.internalEntriesAdd(currentPath + File.separator + firstEntry.getName(), (MultipleHash)firstEntry, compareResult.deletedEntries, compareResult.deletedEntries);
                }
                compareResult.deletedEntries.addLast((Object)(currentPath + File.separator + firstEntry.getName()));
lbl52:
                // 2 sources

                ** while (!first.isAtEnd())
            }
        }
    }

    private void internalEntriesAdd(String currentPath, MultipleHash entry, LinkedList fileList, LinkedList folderList) {
        SingleHashAdapter next;
        RootIterator iter = entry.getFilesIterator();
        while (!iter.isAtEnd()) {
            next = (SingleHashAdapter)iter.next();
            fileList.addLast((Object)(currentPath + File.separator + next.getName()));
        }
        iter = entry.getFoldersIterator();
        while (!iter.isAtEnd()) {
            next = (MultipleHash)iter.next();
            this.internalEntriesAdd(currentPath + File.separator + next.getName(), (MultipleHash)next, fileList, folderList);
            folderList.addLast((Object)(currentPath + File.separator + next.getName()));
        }
    }

    protected void encodeAdditionalData(byte[] data, int additionalDataOffset) {
        int memberSize;
        int index;
        int sectionSizeOffset = index = additionalDataOffset;
        index += 8;
        int sectionSize = 0;
        RootIterator iter = this.files.elementsIterator();
        SingleHashAdapter member = null;
        while (!iter.isAtEnd()) {
            member = (SingleHashAdapter)iter.next();
            memberSize = member.calculateExpectedByteArraySize();
            member.encodeToByteArray(data, index, memberSize);
            index += memberSize;
            sectionSize += memberSize;
        }
        Convert.writeIntToByteArr(data, sectionSizeOffset, sectionSize);
        Convert.writeIntToByteArr(data, sectionSizeOffset + 4, this.files.size());
        sectionSizeOffset = index;
        sectionSize = 0;
        index += 8;
        iter = this.folders.elementsIterator();
        while (!iter.isAtEnd()) {
            member = (MultipleHash)iter.next();
            memberSize = member.calculateExpectedByteArraySize();
            member.encodeToByteArray(data, index, memberSize);
            index += memberSize;
            sectionSize += memberSize;
        }
        Convert.writeIntToByteArr(data, sectionSizeOffset, sectionSize);
        Convert.writeIntToByteArr(data, sectionSizeOffset + 4, this.folders.size());
    }

    protected int calculateExpectedByteArraySize() {
        if (this.changed) {
            this.init(this.name, this.calculateHash());
        }
        int expectedSize = this.calculateAdditionalDataOffset() + 16 + 16;
        RootIterator iter = this.files.elementsIterator();
        SingleHashAdapter member = null;
        while (!iter.isAtEnd()) {
            member = (SingleHashAdapter)iter.next();
            expectedSize += member.calculateExpectedByteArraySize();
        }
        iter = this.folders.elementsIterator();
        while (!iter.isAtEnd()) {
            member = (MultipleHash)iter.next();
            expectedSize += member.calculateExpectedByteArraySize();
        }
        return expectedSize;
    }

    public String toString() {
        return this.internalToString("");
    }

    public String internalToString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix + "[" + this.name + "] <" + Convert.byteArrToHexString(this.getHash()) + ">\n");
        int i = 0;
        while (i < this.files.size()) {
            sb.append(prefix + ((SingleHashAdapter)this.files.elementAt(i)).internalToString(prefix + " "));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.folders.size()) {
            sb.append(prefix + ((MultipleHash)this.folders.elementAt(i2)).internalToString(prefix + " "));
            ++i2;
        }
        return sb.toString();
    }

    protected void setChanged() {
        this.changed = true;
    }

    public Entry[] getFiles() {
        return (Entry[])this.files.toArray((Object[])new Entry[this.files.size()]);
    }

    public Index[] getFolders() {
        return (Index[])this.folders.toArray((Object[])new Index[this.folders.size()]);
    }

    protected boolean internalEntryAdd(String relativePath, Entry entry, boolean recursiveCreate, boolean replace) throws PathNotFoundException {
        LinkedList index = this.getFolder(this, relativePath, recursiveCreate);
        boolean result = false;
        if (index != null) {
            this.setNodesChanged(index);
            result = ((MultipleHash)index.getLast()).internalEntryAdd(entry, replace);
        }
        return result;
    }

    private void setNodesChanged(LinkedList index) {
        RootIterator itr = index.elementsIterator();
        while (!itr.isAtEnd()) {
            MultipleHash next = (MultipleHash)itr.next();
            next.setChanged();
        }
    }

    protected boolean internalEntryAdd(Entry entry, boolean replace) {
        ArrayObject list = null;
        list = entry.getType() == 1 ? this.files : this.folders;
        int i = 0;
        while (i < list.size()) {
            if (((SingleHashAdapter)list.elementAt(i)).getName().equals(entry.getName())) {
                if (replace) {
                    list.setElementAt((Object)entry, i);
                    this.setChanged();
                    return true;
                }
                return false;
            }
            ++i;
        }
        this.setChanged();
        list.add((Object)entry);
        return true;
    }

    protected boolean internalEntryDelete(String relativePath, String name, byte type) throws PathNotFoundException {
        LinkedList index = this.getFolder(this, relativePath, false);
        boolean result = false;
        if (index != null) {
            RootIterator itr = index.elementsIterator();
            while (!itr.isAtEnd()) {
                MultipleHash next = (MultipleHash)itr.next();
                next.setChanged();
            }
            result = ((MultipleHash)index.getLast()).internalEntryDelete(name, type);
        }
        return result;
    }

    protected boolean internalEntryDelete(String name, byte type) {
        ArrayObject list = null;
        list = 1 == type ? this.files : this.folders;
        int i = 0;
        while (i < list.size()) {
            if (((SingleHashAdapter)list.elementAt(i)).getName().equals(name)) {
                list.removeAt(i);
                this.setChanged();
                return true;
            }
            ++i;
        }
        return false;
    }

    protected LinkedList getFolder(MultipleHash start, String relativePath, boolean recursiveCreate) throws PathNotFoundException {
        LinkedList affectedIndexes = new LinkedList();
        affectedIndexes.addLast((Object)start);
        StringTokenizer st = new StringTokenizer(relativePath, "/\\");
        MultipleHash worker = start;
        MultipleHash iteratingFolder = null;
        RootIterator iter = null;
        String currentFolderName = null;
        while (st.hasMoreTokens()) {
            boolean breakFlag = true;
            currentFolderName = st.nextToken();
            iter = worker.getFoldersIterator();
            while (!iter.isAtEnd()) {
                iteratingFolder = (MultipleHash)iter.next();
                if (!iteratingFolder.getName().equals(currentFolderName)) continue;
                breakFlag = false;
                break;
            }
            if (breakFlag) {
                if (recursiveCreate) {
                    iteratingFolder = new MultipleHash(currentFolderName);
                    worker.internalEntryAdd(iteratingFolder, false);
                } else {
                    throw new PathNotFoundException();
                }
            }
            affectedIndexes.addLast((Object)iteratingFolder);
            worker = iteratingFolder;
        }
        return affectedIndexes;
    }

    protected SingleHashAdapter getElementByName(String name, byte type) {
        ArrayObject list = null;
        list = 1 == type ? this.files : this.folders;
        int i = 0;
        while (i < list.size()) {
            if (((SingleHashAdapter)list.elementAt(i)).getName().equals(name)) {
                return (SingleHashAdapter)list.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public byte getType() {
        return 2;
    }

    public boolean addFile(byte[] singleHashByteArray, boolean replace) throws CorruptedHashException {
        return this.internalEntryAdd(new FileHash(singleHashByteArray, 0), replace);
    }

    public boolean addFile(File file, boolean replace) throws IOException {
        boolean bl;
        FileInputStream fis = new FileInputStream(file);
        try {
            bl = this.internalEntryAdd(new FileHash(file.getName(), fis), replace);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return bl;
    }

    public boolean addFile(String name, InputStream stream, boolean replace) throws IOException {
        return this.internalEntryAdd(new FileHash(name, stream), replace);
    }

    public boolean addFileTo(String relativePath, byte[] singleHashByteArray, boolean createRecursive, boolean replace) throws CorruptedHashException, PathNotFoundException {
        return this.internalEntryAdd(relativePath, new FileHash(singleHashByteArray, 0), createRecursive, replace);
    }

    public boolean addFileTo(String relativePath, File file, boolean createRecursive, boolean replace) throws IOException, PathNotFoundException {
        boolean bl;
        FileInputStream fis = new FileInputStream(file);
        try {
            bl = this.internalEntryAdd(relativePath, new FileHash(file.getName(), fis), createRecursive, replace);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return bl;
    }

    public boolean addFileTo(String relativePath, String name, InputStream stream, boolean createRecursive, boolean replace) throws IOException, PathNotFoundException {
        return this.internalEntryAdd(relativePath, new FileHash(name, stream), createRecursive, replace);
    }

    public boolean deleteFile(String name) throws PathNotFoundException {
        return this.internalEntryDelete(name, (byte)1);
    }

    public boolean deleteFileFrom(String relativePath, String name) throws PathNotFoundException {
        return this.internalEntryDelete(relativePath, name, (byte)1);
    }

    public boolean addFolder(byte[] indexByteArray) throws CorruptedHashException {
        return this.internalEntryAdd(new MultipleHash(indexByteArray, 0), false);
    }

    public boolean addFolder(File folder) throws IOException {
        return this.internalEntryAdd(new MultipleHash(folder, this.filter), false);
    }

    public boolean addFolder(InDepthIterator iter) throws IOException {
        return this.internalEntryAdd(new MultipleHash(iter), false);
    }

    public boolean addFolderTo(String relativePath, byte[] indexByteArray, boolean createRecursive) throws CorruptedHashException, PathNotFoundException {
        return this.internalEntryAdd(relativePath, new MultipleHash(indexByteArray, 0), createRecursive, false);
    }

    public boolean addFolderTo(String relativePath, File folder, boolean createRecursive) throws IOException, PathNotFoundException {
        return this.internalEntryAdd(relativePath, new MultipleHash(folder), createRecursive, false);
    }

    public boolean addFolderTo(String relativePath, InDepthIterator iter, boolean createRecursive) throws IOException, PathNotFoundException {
        return this.internalEntryAdd(relativePath, new MultipleHash(iter), createRecursive, false);
    }

    public boolean deleteFolder(String name) throws PathNotFoundException {
        return this.internalEntryDelete(name, (byte)2);
    }

    public boolean deleteFolderFrom(String relativePath, String name) throws PathNotFoundException {
        return this.internalEntryDelete(relativePath, name, (byte)2);
    }

    public boolean addEmptyFolder(String name) {
        return this.internalEntryAdd(new MultipleHash(name), false);
    }

    public boolean addEmptyFolderTo(String relativePath, String name, boolean createRecursive) throws PathNotFoundException {
        return this.ensurePath(relativePath + File.separatorChar + name, createRecursive);
    }

    public boolean ensurePath(String path, boolean createRecursive) throws PathNotFoundException {
        LinkedList index = this.getFolder(this, path, createRecursive);
        this.setNodesChanged(index);
        return true;
    }

    public void deleteAll(boolean filesOnly) {
        if (filesOnly) {
            this.files.clear();
            this.setChanged();
        } else {
            this.clear();
        }
    }

    private void clear() {
        this.files.clear();
        RootIterator iter = this.folders.elementsIterator();
        while (!iter.isAtEnd()) {
            MultipleHash ind = (MultipleHash)iter.next();
            ind.clear();
        }
        this.folders.clear();
        this.setChanged();
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.deepClone();
    }

    public Object deepClone() {
        Class<?> c = this.getClass();
        MultipleHash clonning = null;
        try {
            clonning = (MultipleHash)c.newInstance();
            clonning.files = (ArrayObject)this.files.deepClone();
            clonning.folders = (ArrayObject)this.folders.deepClone();
            clonning.init(this.name, clonning.getHash());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return clonning;
    }
}

