/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.Hasher;
import com.sap.engine.lib.lang.Convert;
import java.util.Arrays;

public class MD5Hash
implements Hasher {
    private static final int HASH_SIZE = 16;
    private int[] hashBuffer = null;
    private long bitsCount;
    private byte[] inBuffer = null;
    int[] inInt = null;

    public MD5Hash() {
        this.init();
    }

    public void updateHash(int data) {
        int t = (int)this.bitsCount;
        t = t >>> 3 & 0x3F;
        this.bitsCount += 8L;
        this.inBuffer[t] = (byte)data;
        if (t == 63) {
            this.nextStep();
        }
    }

    public void updateHash(byte[] newBuff) {
        this.updateHash(newBuff, 0, newBuff.length);
    }

    public void updateHash(byte[] newBuff, int buffStart, int buffLength) {
        int len = buffLength;
        int t = (int)this.bitsCount;
        this.bitsCount += (long)(len << 3);
        if ((t = t >>> 3 & 0x3F) != 0) {
            int p = t;
            if (len < (t = 64 - t)) {
                System.arraycopy(newBuff, buffStart, this.inBuffer, p, len);
                return;
            }
            System.arraycopy(newBuff, buffStart, this.inBuffer, p, t);
            this.nextStep();
            buffStart += t;
            len -= t;
        }
        while (len >= 64) {
            System.arraycopy(newBuff, buffStart, this.inBuffer, 0, 64);
            this.nextStep();
            buffStart += 64;
            len -= 64;
        }
        System.arraycopy(newBuff, buffStart, this.inBuffer, 0, len);
    }

    public byte[] getHash() {
        int count;
        byte[] rezult = new byte[16];
        int p = count = (int)(this.bitsCount >>> 3 & 0x3FL);
        if ((count = 64 - count) < 8) {
            Arrays.fill(this.inBuffer, p, this.inBuffer.length, (byte)0);
            this.nextStep();
            Arrays.fill(this.inBuffer, 0, 56, (byte)0);
        } else {
            Arrays.fill(this.inBuffer, p, 56, (byte)0);
        }
        Convert.writeLongToByteArr(this.inBuffer, 56, this.bitsCount);
        this.nextStep();
        Convert.writeIntToByteArr(rezult, 0, this.hashBuffer[0]);
        Convert.writeIntToByteArr(rezult, 4, this.hashBuffer[1]);
        Convert.writeIntToByteArr(rezult, 8, this.hashBuffer[2]);
        Convert.writeIntToByteArr(rezult, 12, this.hashBuffer[3]);
        this.clear();
        return rezult;
    }

    public void writeHash(byte[] target, int offset) {
        int count;
        if (target == null) {
            throw new NullPointerException("Unable to write hash into a NULL byte[].");
        }
        if (offset + 16 > target.length) {
            throw new ArrayIndexOutOfBoundsException("Target array not large enough to handle the hash (array length: " + target.length + "; offset: " + offset + ")");
        }
        int p = count = (int)(this.bitsCount >>> 3 & 0x3FL);
        if ((count = 64 - count) < 8) {
            Arrays.fill(this.inBuffer, p, this.inBuffer.length, (byte)0);
            this.nextStep();
            Arrays.fill(this.inBuffer, 0, 56, (byte)0);
        } else {
            Arrays.fill(this.inBuffer, p, 56, (byte)0);
        }
        Convert.writeLongToByteArr(this.inBuffer, 56, this.bitsCount);
        this.nextStep();
        Convert.writeIntToByteArr(target, offset, this.hashBuffer[0]);
        Convert.writeIntToByteArr(target, offset + 4, this.hashBuffer[1]);
        Convert.writeIntToByteArr(target, offset + 8, this.hashBuffer[2]);
        Convert.writeIntToByteArr(target, offset + 12, this.hashBuffer[3]);
        this.clear();
    }

    public void init() {
        this.hashBuffer = new int[4];
        this.inBuffer = new byte[64];
        this.clear();
        this.inInt = new int[16];
    }

    public void clear() {
        this.hashBuffer[0] = 1732584193;
        this.hashBuffer[1] = -271733879;
        this.hashBuffer[2] = -1732584194;
        this.hashBuffer[3] = 271733878;
        this.bitsCount = 0L;
        Arrays.fill(this.inBuffer, (byte)0);
    }

    private int MD5Round1(int w, int x, int y, int z, int data, int s) {
        w += (z ^ x & (y ^ z)) + data;
        w = w << s | w >>> 32 - s;
        return w += x;
    }

    private int MD5Round2(int w, int x, int y, int z, int data, int s) {
        w += (y ^ z & (x ^ y)) + data;
        w = w << s | w >>> 32 - s;
        return w += x;
    }

    private int MD5Round3(int w, int x, int y, int z, int data, int s) {
        w += (x ^ y ^ z) + data;
        w = w << s | w >>> 32 - s;
        return w += x;
    }

    private int MD5Round4(int w, int x, int y, int z, int data, int s) {
        w += (y ^ (x | ~z)) + data;
        w = w << s | w >>> 32 - s;
        return w += x;
    }

    private void nextStep() {
        int i = 0;
        while (i < 16) {
            this.inInt[i] = Convert.byteArrToInt(this.inBuffer, 4 * i);
            ++i;
        }
        int a = this.hashBuffer[0];
        int b = this.hashBuffer[1];
        int c = this.hashBuffer[2];
        int d = this.hashBuffer[3];
        a = this.MD5Round1(a, b, c, d, this.inInt[0] + -680876936, 7);
        d = this.MD5Round1(d, a, b, c, this.inInt[1] + -389564586, 12);
        c = this.MD5Round1(c, d, a, b, this.inInt[2] + 606105819, 17);
        b = this.MD5Round1(b, c, d, a, this.inInt[3] + -1044525330, 22);
        a = this.MD5Round1(a, b, c, d, this.inInt[4] + -176418897, 7);
        d = this.MD5Round1(d, a, b, c, this.inInt[5] + 1200080426, 12);
        c = this.MD5Round1(c, d, a, b, this.inInt[6] + -1473231341, 17);
        b = this.MD5Round1(b, c, d, a, this.inInt[7] + -45705983, 22);
        a = this.MD5Round1(a, b, c, d, this.inInt[8] + 1770035416, 7);
        d = this.MD5Round1(d, a, b, c, this.inInt[9] + -1958414417, 12);
        c = this.MD5Round1(c, d, a, b, this.inInt[10] + -42063, 17);
        b = this.MD5Round1(b, c, d, a, this.inInt[11] + -1990404162, 22);
        a = this.MD5Round1(a, b, c, d, this.inInt[12] + 1804603682, 7);
        d = this.MD5Round1(d, a, b, c, this.inInt[13] + -40341101, 12);
        c = this.MD5Round1(c, d, a, b, this.inInt[14] + -1502002290, 17);
        b = this.MD5Round1(b, c, d, a, this.inInt[15] + 1236535329, 22);
        a = this.MD5Round2(a, b, c, d, this.inInt[1] + -165796510, 5);
        d = this.MD5Round2(d, a, b, c, this.inInt[6] + -1069501632, 9);
        c = this.MD5Round2(c, d, a, b, this.inInt[11] + 643717713, 14);
        b = this.MD5Round2(b, c, d, a, this.inInt[0] + -373897302, 20);
        a = this.MD5Round2(a, b, c, d, this.inInt[5] + -701558691, 5);
        d = this.MD5Round2(d, a, b, c, this.inInt[10] + 38016083, 9);
        c = this.MD5Round2(c, d, a, b, this.inInt[15] + -660478335, 14);
        b = this.MD5Round2(b, c, d, a, this.inInt[4] + -405537848, 20);
        a = this.MD5Round2(a, b, c, d, this.inInt[9] + 568446438, 5);
        d = this.MD5Round2(d, a, b, c, this.inInt[14] + -1019803690, 9);
        c = this.MD5Round2(c, d, a, b, this.inInt[3] + -187363961, 14);
        b = this.MD5Round2(b, c, d, a, this.inInt[8] + 1163531501, 20);
        a = this.MD5Round2(a, b, c, d, this.inInt[13] + -1444681467, 5);
        d = this.MD5Round2(d, a, b, c, this.inInt[2] + -51403784, 9);
        c = this.MD5Round2(c, d, a, b, this.inInt[7] + 1735328473, 14);
        b = this.MD5Round2(b, c, d, a, this.inInt[12] + -1926607734, 20);
        a = this.MD5Round3(a, b, c, d, this.inInt[5] + -378558, 4);
        d = this.MD5Round3(d, a, b, c, this.inInt[8] + -2022574463, 11);
        c = this.MD5Round3(c, d, a, b, this.inInt[11] + 1839030562, 16);
        b = this.MD5Round3(b, c, d, a, this.inInt[14] + -35309556, 23);
        a = this.MD5Round3(a, b, c, d, this.inInt[1] + -1530992060, 4);
        d = this.MD5Round3(d, a, b, c, this.inInt[4] + 1272893353, 11);
        c = this.MD5Round3(c, d, a, b, this.inInt[7] + -155497632, 16);
        b = this.MD5Round3(b, c, d, a, this.inInt[10] + -1094730640, 23);
        a = this.MD5Round3(a, b, c, d, this.inInt[13] + 681279174, 4);
        d = this.MD5Round3(d, a, b, c, this.inInt[0] + -358537222, 11);
        c = this.MD5Round3(c, d, a, b, this.inInt[3] + -722521979, 16);
        b = this.MD5Round3(b, c, d, a, this.inInt[6] + 76029189, 23);
        a = this.MD5Round3(a, b, c, d, this.inInt[9] + -640364487, 4);
        d = this.MD5Round3(d, a, b, c, this.inInt[12] + -421815835, 11);
        c = this.MD5Round3(c, d, a, b, this.inInt[15] + 530742520, 16);
        b = this.MD5Round3(b, c, d, a, this.inInt[2] + -995338651, 23);
        a = this.MD5Round4(a, b, c, d, this.inInt[0] + -198630844, 6);
        d = this.MD5Round4(d, a, b, c, this.inInt[7] + 1126891415, 10);
        c = this.MD5Round4(c, d, a, b, this.inInt[14] + -1416354905, 15);
        b = this.MD5Round4(b, c, d, a, this.inInt[5] + -57434055, 21);
        a = this.MD5Round4(a, b, c, d, this.inInt[12] + 1700485571, 6);
        d = this.MD5Round4(d, a, b, c, this.inInt[3] + -1894986606, 10);
        c = this.MD5Round4(c, d, a, b, this.inInt[10] + -1051523, 15);
        b = this.MD5Round4(b, c, d, a, this.inInt[1] + -2054922799, 21);
        a = this.MD5Round4(a, b, c, d, this.inInt[8] + 1873313359, 6);
        d = this.MD5Round4(d, a, b, c, this.inInt[15] + -30611744, 10);
        c = this.MD5Round4(c, d, a, b, this.inInt[6] + -1560198380, 15);
        b = this.MD5Round4(b, c, d, a, this.inInt[13] + 1309151649, 21);
        a = this.MD5Round4(a, b, c, d, this.inInt[4] + -145523070, 6);
        d = this.MD5Round4(d, a, b, c, this.inInt[11] + -1120210379, 10);
        c = this.MD5Round4(c, d, a, b, this.inInt[2] + 718787259, 15);
        b = this.MD5Round4(b, c, d, a, this.inInt[9] + -343485551, 21);
        this.hashBuffer[0] = this.hashBuffer[0] + a;
        this.hashBuffer[1] = this.hashBuffer[1] + b;
        this.hashBuffer[2] = this.hashBuffer[2] + c;
        this.hashBuffer[3] = this.hashBuffer[3] + d;
    }
}

