/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.hash;

import com.sap.engine.lib.io.hash.FilteredInDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class FolderInDepthIterator
implements FilteredInDepthIterator {
    final String name;
    File[] entries = null;
    transient FilenameFilter filter;

    public FolderInDepthIterator(File f) throws IOException {
        this(f, null);
    }

    protected FolderInDepthIterator(File f, FilenameFilter filter) throws IOException {
        this.name = f.getName();
        this.filter = filter;
        this.init(f, filter);
    }

    private void init(File f, FilenameFilter filter) throws IOException {
        if (f.exists() && f.isDirectory()) {
            this.entries = filter != null ? f.listFiles(filter) : f.listFiles();
        } else {
            throw new IOException("Folder [" + f.getName() + "] does not exists.");
        }
    }

    public void addEntries(Index targetIndex) throws IOException {
        int i = 0;
        while (i < this.entries.length) {
            File work = this.entries[i];
            if (work.isFile()) {
                targetIndex.addFile(work, false);
            } else {
                targetIndex.addFolder(work);
            }
            ++i;
        }
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }
}

