/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ReusableGZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    private boolean closed = false;
    private boolean headerWritten = false;
    private static final byte[] header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};

    public ReusableGZIPOutputStream(OutputStream out, int size) {
        super(out, new Deflater(-1, true), size);
        this.crc.reset();
    }

    public ReusableGZIPOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.ensureHeaderWritten();
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.ensureHeaderWritten();
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, len);
                    this.out.write(this.buf, 0, len += 8);
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            ((FilterOutputStream)this).flush();
            this.out.close();
            this.closed = true;
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(header);
        this.headerWritten = true;
    }

    private void writeTrailer(byte[] buf, int offset) {
        this.writeInt((int)this.crc.getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }

    private void ensureHeaderWritten() throws IOException {
        if (!this.headerWritten) {
            this.writeHeader();
            this.headerWritten = true;
        }
    }

    public void reset() {
        if (this.headerWritten) {
            this.def.reset();
            this.crc.reset();
            this.closed = false;
            this.headerWritten = false;
        }
    }
}

