/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.io.QRandomAccessFile;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;

public class MemoryRandomAccessFile
extends QRandomAccessFile {
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    private boolean isRW;
    private byte[] memFile;
    private int length;
    private long filePointer;
    private String fileName;

    public MemoryRandomAccessFile(String name, String mode) throws FileNotFoundException {
        super(name, mode);
        this.isRW = mode.equals("rw");
        this.fileName = name;
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "r");
            if (raf.length() > Integer.MAX_VALUE) {
                throw new FileNotFoundException("The file is too big to be loaded in memory");
            }
            this.length = (int)raf.length();
            this.memFile = new byte[this.length];
            raf.readFully(this.memFile);
            raf.close();
            raf = null;
        }
        catch (FileNotFoundException fnfe) {
            if (this.isRW) {
                this.length = 0;
                this.memFile = new byte[this.length];
            }
            throw new FileNotFoundException(fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(ioe.getMessage());
        }
        this.filePointer = 0L;
    }

    public MemoryRandomAccessFile(File file, String mode) throws IOException {
        this(file.getPath(), mode);
    }

    public synchronized int read() throws IOException {
        if (this.filePointer < (long)this.length) {
            return this.memFile[(int)this.filePointer++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.filePointer >= (long)this.length) {
            return -1;
        }
        if (this.filePointer + (long)len > (long)this.length) {
            int size = (int)((long)this.length - this.filePointer);
            System.arraycopy(this.memFile, (int)this.filePointer, b, off, size);
            this.filePointer = this.length;
            return size;
        }
        System.arraycopy(this.memFile, (int)this.filePointer, b, off, len);
        this.filePointer += (long)len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public synchronized void readFully(byte[] b, int off, int len) throws IOException {
        if (this.filePointer + (long)len > (long)this.length) {
            throw new EOFException();
        }
        System.arraycopy(this.memFile, (int)this.filePointer, b, off, len);
        this.filePointer += (long)len;
    }

    public synchronized int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        if (this.filePointer + (long)n > (long)this.length) {
            n = (int)this.filePointer;
            this.filePointer = this.length;
            return this.length - n;
        }
        this.filePointer += (long)n;
        return n;
    }

    public synchronized void write(int b) throws IOException {
        if (!this.isRW) {
            throw new IOException();
        }
        if (this.filePointer >= (long)this.length) {
            this.setLength(this.filePointer + 1L);
        }
        this.memFile[(int)this.filePointer++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (!this.isRW) {
            throw new IOException();
        }
        int temp = (int)this.filePointer + len;
        if (temp > this.length) {
            this.setLength(temp);
        }
        System.arraycopy(b, off, this.memFile, (int)this.filePointer, len);
        this.filePointer = temp;
    }

    public synchronized long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L || pos > Integer.MAX_VALUE) {
            throw new IOException();
        }
        this.filePointer = pos;
    }

    public synchronized long length() throws IOException {
        return this.length;
    }

    public synchronized void setLength(long newLength) throws IOException {
        if (newLength < 0L || newLength > Integer.MAX_VALUE) {
            throw new IOException();
        }
        if (newLength < (long)this.length) {
            if (newLength < (long)(this.memFile.length / 2)) {
                try {
                    byte[] newFile = new byte[(int)newLength];
                    System.arraycopy(this.memFile, 0, newFile, 0, (int)newLength);
                    this.memFile = newFile;
                }
                catch (Throwable e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                int i = (int)newLength;
                while (i < this.length) {
                    this.memFile[i] = 0;
                    ++i;
                }
            }
            if (this.filePointer > newLength) {
                this.filePointer = newLength;
            }
        } else if (newLength > (long)this.length && newLength > (long)this.memFile.length) {
            try {
                int newCapacity = this.memFile.length;
                newCapacity = (int)((double)newCapacity * 1.75);
                if (newLength > (long)newCapacity) {
                    newCapacity = (int)newLength;
                }
                byte[] newFile = new byte[newCapacity];
                System.arraycopy(this.memFile, 0, newFile, 0, this.length);
                this.memFile = newFile;
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage());
            }
        }
        this.length = (int)newLength;
    }

    public synchronized void close() throws IOException {
        if (this.isRW) {
            try {
                FileOutputStream fos = new FileOutputStream(this.fileName);
                fos.write(this.memFile, 0, this.length);
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.isRW = false;
        this.memFile = null;
        this.fileName = null;
        this.length = Integer.MIN_VALUE;
        this.filePointer = Long.MIN_VALUE;
    }

    public synchronized boolean readBoolean() throws IOException {
        if (this.filePointer >= (long)this.length) {
            throw new EOFException();
        }
        return this.memFile[(int)this.filePointer++] != 0;
    }

    public synchronized byte readByte() throws IOException {
        if (this.filePointer >= (long)this.length) {
            throw new EOFException();
        }
        return this.memFile[(int)this.filePointer++];
    }

    public synchronized int readUnsignedByte() throws IOException {
        if (this.filePointer >= (long)this.length) {
            throw new EOFException();
        }
        return this.memFile[(int)this.filePointer++] & 0xFF;
    }

    public synchronized short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public synchronized int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public synchronized char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public synchronized int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public synchronized long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public synchronized String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long current = this.filePointer;
                    if (this.read() == 10) continue block4;
                    this.filePointer = current;
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public synchronized String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public synchronized void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public synchronized void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public synchronized void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public synchronized void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public synchronized void writeBytes(String s) throws IOException {
        if (!this.isRW) {
            throw new IOException();
        }
        long current = this.filePointer + (long)s.length();
        if (current > (long)this.length) {
            this.setLength(current);
        }
        char[] ch = s.toCharArray();
        int i = 0;
        while (i < ch.length) {
            this.memFile[(int)this.filePointer + i] = (byte)ch[i];
            ++i;
        }
        this.filePointer = current;
    }

    public synchronized void writeChars(String s) throws IOException {
        if (!this.isRW) {
            throw new IOException();
        }
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int i = 0;
        int j = 0;
        while (i < clen) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
            ++i;
        }
        this.write(b, 0, blen);
    }

    public synchronized void writeUTF(String str) throws IOException {
        if (!this.isRW) {
            throw new IOException();
        }
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            char c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            char c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
    }
}

