/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.io.hash.MD5Hash;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HashOutputStream
extends FilterOutputStream {
    private MD5Hash hash = new MD5Hash();

    public HashOutputStream(OutputStream os) {
        super(os);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.hash.updateHash(b);
    }

    public void write(byte[] bytes) throws IOException {
        int index = 0;
        while (index < bytes.length) {
            this.out.write(bytes[index]);
            ++index;
        }
        this.hash.updateHash(bytes, 0, index - 1);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if ((off | len | bytes.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < len) {
            this.out.write(bytes[off + i]);
            ++i;
        }
        this.hash.updateHash(bytes, off, len);
    }

    public byte[] hash() {
        return this.hash.getHash();
    }
}

