/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.io.hash.MD5Hash;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HashInputStream
extends FilterInputStream {
    private MD5Hash hash = new MD5Hash();

    public HashInputStream(InputStream is) {
        super(is);
    }

    public int read() throws IOException {
        int data = this.in.read();
        if (data == -1) {
            return -1;
        }
        this.hash.updateHash(data);
        return data;
    }

    public int read(byte[] bytes) throws IOException {
        int count = this.in.read(bytes, 0, bytes.length);
        if (count == -1) {
            return -1;
        }
        this.hash.updateHash(bytes, 0, count);
        return count;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = this.in.read(bytes, offset, length);
        if (count == -1) {
            return -1;
        }
        this.hash.updateHash(bytes, offset, count);
        return count;
    }

    public byte[] hash() {
        return this.hash.getHash();
    }
}

