/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.lang.StringMatcher;
import java.io.File;

public class FilenameFilter
extends StringMatcher
implements java.io.FilenameFilter {
    private boolean negativeMatch = false;
    private boolean fullMatch = false;

    public FilenameFilter(String pattern, boolean negativeMatch) {
        super(File.separatorChar == '/' ? pattern.replace('\\', '/') : pattern.replace('/', '\\'));
        if (pattern.indexOf("/") != -1 || pattern.indexOf("\\") != -1) {
            this.fullMatch = true;
        }
        this.negativeMatch = negativeMatch;
    }

    public boolean accept(File dir, String name) {
        String toMatch = null;
        toMatch = this.fullMatch ? dir.getAbsolutePath() + File.separatorChar + name : name;
        boolean result = this.negativeMatch ? !this.matches(toMatch) : this.matches(toMatch);
        return result;
    }
}

