/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.lang.RunExec;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static void makeJar(File dir, File destDir, String jarn, boolean flat) throws IOException {
        ZipOutputStream jar = null;
        Vector entries = new Vector();
        FileInputStream fis = null;
        byte[] bytes = null;
        int size = -1;
        File tmp = null;
        try {
            jar = new ZipOutputStream(new FileOutputStream(new File(destDir, jarn)));
            FileUtils.listFiles(dir, entries, flat);
        }
        catch (IOException ioerr) {
            jar.close();
            throw ioerr;
        }
        catch (Exception er) {
            jar.close();
            throw new IOException(er.getMessage());
        }
        Enumeration e = entries.elements();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (!entryName.endsWith(".class")) continue;
            size = dir.getAbsolutePath().length();
            String jarEntry = entryName.substring(size + 1);
            jar.putNextEntry(new ZipEntry(jarEntry));
            try {
                tmp = new File(entryName);
                fis = new FileInputStream(tmp);
                bytes = new byte[fis.available()];
                size = fis.read(bytes, 0, bytes.length);
                jar.write(bytes, 0, size);
            }
            catch (IOException ioe) {
                fis.close();
                jar.close();
                throw ioe;
            }
            jar.closeEntry();
        }
        jar.close();
    }

    public static void listFiles(File dir, Vector result, boolean flat) throws IOException {
        String fileName = dir.getAbsolutePath();
        if (dir.isFile()) {
            result.add(fileName);
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                if (!flat) {
                    FileUtils.listFiles(files[i], result, false);
                }
            } else {
                result.add(files[i].getAbsolutePath());
            }
            ++i;
        }
    }

    public static void copy(File src, String dest) throws IOException {
        FileUtils.copyFile(src, new File(dest));
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        if (src == null || dest == null || !src.exists()) {
            return;
        }
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            int read;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((read = fis.read(buffer, 0, buffer.length)) != -1) {
                void var5_5;
                fos.write(buffer, 0, (int)var5_5);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                fis.close();
                fos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fis.close();
            fos.close();
        }
        catch (Exception e) {}
    }

    public static void writeToFile(InputStream src, File dst) throws IOException {
        dst.delete();
        FileOutputStream fileout = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        int received = 0;
        while ((received = src.read(buf)) != -1) {
            fileout.write(buf, 0, received);
        }
        src.close();
        fileout.close();
    }

    public static void copyDirectory(File source, File dest) throws IOException {
        File[] files = source.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File tempFile = new File(dest, files[i].getName());
                if (files[i].isFile()) {
                    FileUtils.copyFile(files[i], tempFile);
                } else {
                    tempFile.mkdirs();
                    FileUtils.copyDirectory(files[i], tempFile);
                }
                ++i;
            }
        }
    }

    public static boolean deleteDirectory(File tempDir) {
        boolean status = true;
        if (tempDir != null) {
            File[] files = tempDir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    status = files[i].isDirectory() ? FileUtils.deleteDirectory(files[i]) && status : files[i].delete() && status;
                    ++i;
                }
            }
            status = tempDir.delete() && status;
        } else {
            status = false;
        }
        return status;
    }

    public static boolean isCorrectFileName(String fileName) {
        return fileName.indexOf("*") == -1 && fileName.indexOf("?") == -1 && fileName.indexOf("\"") == -1 && fileName.indexOf("<") == -1 && fileName.indexOf(">") == -1 && fileName.indexOf("|") == -1 && fileName.indexOf("\\") == -1 && fileName.indexOf("/") == -1;
    }

    public static void deleteFiles(ArrayEnumeration names, String rootPath) {
        File work = null;
        while (names.hasNext()) {
            String filename = rootPath + File.separator + (String)names.next();
            work = new File(filename);
            if (work.delete()) continue;
            System.out.println("Entry [" + filename + "] not deleted successfully!");
        }
    }

    public static void createFolders(ArrayEnumeration names, String rootPath) {
        while (names.hasNext()) {
            String filename = rootPath + File.separator + (String)names.next();
            new File(filename);
        }
    }

    public static int chmod(File file, String mode) throws IOException, InterruptedException {
        RunExec executor = null;
        boolean err = false;
        try {
            executor = new RunExec(new String[]{"chmod", mode, file.getAbsolutePath()});
            executor.exec();
            err = false;
            return executor.waitFor();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 666;
        }
    }

    public static int chmod(File[] file, String mode) throws IOException {
        RunExec executor = null;
        try {
            String[] parameterList = new String[file.length + 2];
            parameterList[0] = "chmod";
            parameterList[1] = mode;
            int i = 0;
            while (i < file.length) {
                parameterList[i + 2] = file[i].getAbsolutePath();
                ++i;
            }
            executor = new RunExec(parameterList);
            executor.exec();
            return executor.waitFor();
        }
        catch (Exception exception) {
            return 666;
        }
    }
}

